/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.manipulation;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.runner.Description;
import org.junit.runner.manipulation.InvalidOrderingException;
import org.junit.runner.manipulation.Orderable;
import org.junit.runner.manipulation.Orderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ordering {
    private static final String CONSTRUCTOR_ERROR_FORMAT = "Ordering class %s should have a public constructor with signature %s(Ordering.Context context)";

    public static Ordering shuffledBy(final Random random) {
        return new Ordering(){

            @Override
            boolean validateOrderingIsCorrect() {
                return false;
            }

            @Override
            protected List<Description> orderItems(Collection<Description> descriptions) {
                ArrayList<Description> shuffled2 = new ArrayList<Description>(descriptions);
                Collections.shuffle(shuffled2, random);
                return shuffled2;
            }
        };
    }

    public static Ordering definedBy(Class<? extends Factory> factoryClass, Description annotatedTestClass) throws InvalidOrderingException {
        Factory factory;
        if (factoryClass == null) {
            throw new NullPointerException("factoryClass cannot be null");
        }
        if (annotatedTestClass == null) {
            throw new NullPointerException("annotatedTestClass cannot be null");
        }
        try {
            Constructor<? extends Factory> constructor = factoryClass.getConstructor(new Class[0]);
            factory = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidOrderingException(String.format(CONSTRUCTOR_ERROR_FORMAT, Ordering.getClassName(factoryClass), factoryClass.getSimpleName()));
        }
        catch (Exception e) {
            throw new InvalidOrderingException("Could not create ordering for " + annotatedTestClass, e);
        }
        return Ordering.definedBy(factory, annotatedTestClass);
    }

    public static Ordering definedBy(Factory factory, Description annotatedTestClass) throws InvalidOrderingException {
        if (factory == null) {
            throw new NullPointerException("factory cannot be null");
        }
        if (annotatedTestClass == null) {
            throw new NullPointerException("annotatedTestClass cannot be null");
        }
        return factory.create(new Context(annotatedTestClass));
    }

    private static String getClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            return clazz.getName();
        }
        return name;
    }

    public void apply(Object target) throws InvalidOrderingException {
        if (target instanceof Orderable) {
            Orderable orderable = (Orderable)target;
            orderable.order(new Orderer(this));
        }
    }

    boolean validateOrderingIsCorrect() {
        return true;
    }

    protected abstract List<Description> orderItems(Collection<Description> var1);

    public static interface Factory {
        public Ordering create(Context var1);
    }

    public static class Context {
        private final Description description;

        public Description getTarget() {
            return this.description;
        }

        private Context(Description description) {
            this.description = description;
        }
    }
}

