/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.AutoValue_Method;
import com.google.api.generator.gapic.model.HttpBindings;
import com.google.api.generator.gapic.model.LongrunningOperation;
import com.google.api.generator.gapic.model.MethodArgument;
import com.google.api.generator.gapic.model.RoutingHeaderRule;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class Method {
    public abstract String name();

    public abstract Stream stream();

    public abstract TypeNode inputType();

    public abstract TypeNode outputType();

    public abstract boolean isBatching();

    public boolean isPaged() {
        return this.pageSizeFieldName() != null;
    }

    @Nullable
    public abstract String pageSizeFieldName();

    public abstract boolean isDeprecated();

    @Nullable
    public abstract LongrunningOperation lro();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String mixedInApiName();

    @Nullable
    public abstract HttpBindings httpBindings();

    @Nullable
    public abstract RoutingHeaderRule routingHeaderRule();

    public abstract ImmutableList<List<MethodArgument>> methodSignatures();

    public abstract boolean operationPollingMethod();

    public boolean hasLro() {
        return this.lro() != null;
    }

    public boolean hasDescription() {
        return this.description() != null;
    }

    public boolean hasHttpBindings() {
        return this.httpBindings() != null && !this.httpBindings().pathParameters().isEmpty();
    }

    public boolean hasRoutingHeaderParams() {
        return this.routingHeaderRule() != null && !this.routingHeaderRule().routingHeaderParams().isEmpty();
    }

    public boolean shouldSetParamsExtractor() {
        return this.hasHttpBindings() && this.routingHeaderRule() == null || this.hasRoutingHeaderParams();
    }

    public boolean isMixin() {
        return this.mixedInApiName() != null;
    }

    public boolean isOperationPollingMethod() {
        return this.operationPollingMethod();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Method.Builder().setStream(Stream.NONE).setMethodSignatures(ImmutableList.of()).setIsBatching(false).setIsDeprecated(false).setOperationPollingMethod(false);
    }

    public static Stream toStream(boolean isClientStreaming, boolean isServerStreaming) {
        if (!isClientStreaming && !isServerStreaming) {
            return Stream.NONE;
        }
        if (isClientStreaming && isServerStreaming) {
            return Stream.BIDI;
        }
        if (isClientStreaming) {
            return Stream.CLIENT;
        }
        return Stream.SERVER;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setInputType(TypeNode var1);

        public abstract Builder setOutputType(TypeNode var1);

        public abstract Builder setStream(Stream var1);

        public abstract Builder setLro(LongrunningOperation var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setMixedInApiName(String var1);

        public abstract Builder setHttpBindings(HttpBindings var1);

        public abstract Builder setMethodSignatures(List<List<MethodArgument>> var1);

        public abstract Builder setIsBatching(boolean var1);

        public abstract Builder setPageSizeFieldName(String var1);

        public abstract Builder setIsDeprecated(boolean var1);

        public abstract Builder setOperationPollingMethod(boolean var1);

        public abstract Builder setRoutingHeaderRule(RoutingHeaderRule var1);

        public abstract Method build();
    }

    public static enum Stream {
        NONE,
        CLIENT,
        SERVER,
        BIDI;

    }
}

