/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.escape.CharEscapers;
import com.google.api.client.escape.Escaper;
import com.google.api.client.escape.PercentEscaper;
import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.util.GenericData;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericUrl
extends GenericData {
    private static final Escaper URI_FRAGMENT_ESCAPER = new PercentEscaper("=&-_.!~*'()@:$,;/?:", false);
    public String scheme;
    public String host;
    public int port = -1;
    public List<String> pathParts;
    public String fragment;

    public GenericUrl() {
    }

    public GenericUrl(String encodedUrl) {
        URI uri;
        try {
            uri = new URI(encodedUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.scheme = uri.getScheme().toLowerCase();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.pathParts = GenericUrl.toPathParts(uri.getRawPath());
        this.fragment = uri.getFragment();
        String query = uri.getRawQuery();
        if (query != null) {
            UrlEncodedParser.parse(query, (Object)this);
        }
    }

    public int hashCode() {
        return this.build().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof GenericUrl)) {
            return false;
        }
        GenericUrl other = (GenericUrl)((Object)obj);
        return this.build().equals(other.toString());
    }

    public String toString() {
        return this.build();
    }

    public GenericUrl clone() {
        GenericUrl result = (GenericUrl)super.clone();
        result.pathParts = new ArrayList<String>(this.pathParts);
        return result;
    }

    public final String build() {
        List<String> pathParts;
        StringBuilder buf = new StringBuilder();
        buf.append(this.scheme).append("://").append(this.host);
        int port = this.port;
        if (port != -1) {
            buf.append(':').append(port);
        }
        if ((pathParts = this.pathParts) != null) {
            this.appendRawPathFromParts(buf);
        }
        boolean first = true;
        for (Map.Entry nameValueEntry : this.entrySet()) {
            Object value = nameValueEntry.getValue();
            if (value == null) continue;
            String name = CharEscapers.escapeUriQuery((String)((String)nameValueEntry.getKey()));
            if (value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                for (Object repeatedValue : collectionValue) {
                    first = GenericUrl.appendParam(first, buf, name, repeatedValue);
                }
                continue;
            }
            first = GenericUrl.appendParam(first, buf, name, value);
        }
        String fragment = this.fragment;
        if (fragment != null) {
            buf.append('#').append(URI_FRAGMENT_ESCAPER.escape(fragment));
        }
        return buf.toString();
    }

    public Object getFirst(String name) {
        Object value = this.get(name);
        if (value instanceof Collection) {
            Collection collectionValue = (Collection)value;
            Iterator iterator = collectionValue.iterator();
            return iterator.hasNext() ? iterator.next() : null;
        }
        return value;
    }

    public Collection<Object> getAll(String name) {
        Object value = this.get(name);
        if (value == null) {
            return Collections.emptySet();
        }
        if (value instanceof Collection) {
            Collection collectionValue = (Collection)value;
            return Collections.unmodifiableCollection(collectionValue);
        }
        return Collections.singleton(value);
    }

    public String getRawPath() {
        List<String> pathParts = this.pathParts;
        if (pathParts == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        this.appendRawPathFromParts(buf);
        return buf.toString();
    }

    public void setRawPath(String encodedPath) {
        this.pathParts = GenericUrl.toPathParts(encodedPath);
    }

    public void appendRawPath(String encodedPath) {
        if (encodedPath != null && encodedPath.length() != 0) {
            List<String> pathParts = this.pathParts;
            List<String> appendedPathParts = GenericUrl.toPathParts(encodedPath);
            if (pathParts == null || pathParts.isEmpty()) {
                this.pathParts = appendedPathParts;
            } else {
                int size = pathParts.size();
                pathParts.set(size - 1, pathParts.get(size - 1) + appendedPathParts.get(0));
                pathParts.addAll(appendedPathParts.subList(1, appendedPathParts.size()));
            }
        }
    }

    public static List<String> toPathParts(String encodedPath) {
        if (encodedPath == null || encodedPath.length() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int cur = 0;
        boolean notDone = true;
        while (notDone) {
            int slash = encodedPath.indexOf(47, cur);
            notDone = slash != -1;
            String sub = notDone ? encodedPath.substring(cur, slash) : encodedPath.substring(cur);
            result.add(CharEscapers.decodeUri((String)sub));
            cur = slash + 1;
        }
        return result;
    }

    private void appendRawPathFromParts(StringBuilder buf) {
        List<String> pathParts = this.pathParts;
        int size = pathParts.size();
        for (int i = 0; i < size; ++i) {
            String pathPart = pathParts.get(i);
            if (i != 0) {
                buf.append('/');
            }
            if (pathPart.length() == 0) continue;
            buf.append(CharEscapers.escapeUriPath((String)pathPart));
        }
    }

    private static boolean appendParam(boolean first, StringBuilder buf, String name, Object value) {
        if (first) {
            first = false;
            buf.append('?');
        } else {
            buf.append('&');
        }
        buf.append(name);
        String stringValue = CharEscapers.escapeUriQuery((String)value.toString());
        if (stringValue.length() != 0) {
            buf.append('=').append(stringValue);
        }
        return first;
    }
}

