/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.appengine.auth.oauth2;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppIdentityCredential
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final List<String> scopes;

    public AppIdentityCredential(Iterable<String> scopes) {
        this.scopes = Lists.newArrayList(scopes.iterator());
    }

    public AppIdentityCredential(String ... scopes) {
        this.scopes = Lists.newArrayList((Object[])scopes);
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        String accessToken = AppIdentityServiceFactory.getAppIdentityService().getAccessToken(this.scopes).getAccessToken();
        BearerToken.authorizationHeaderAccessMethod().intercept(request, accessToken);
    }
}

