/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.apache.v5;

import com.google.api.client.googleapis.mtls.MtlsProvider;
import com.google.api.client.googleapis.mtls.MtlsUtils;
import com.google.api.client.http.apache.v5.Apache5HttpTransport;
import com.google.api.client.util.SslUtils;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

public final class GoogleApache5HttpTransport {
    public static Apache5HttpTransport newTrustedTransport() throws GeneralSecurityException, IOException {
        return GoogleApache5HttpTransport.newTrustedTransport(MtlsUtils.getDefaultMtlsProvider());
    }

    @Beta
    public static Apache5HttpTransport newTrustedTransport(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
        SocketFactoryRegistryHandler handler = new SocketFactoryRegistryHandler(mtlsProvider);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(handler.getSocketFactoryRegistry());
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive(-1L, TimeUnit.MILLISECONDS).setValidateAfterInactivity(-1L, TimeUnit.MILLISECONDS).build());
        CloseableHttpClient client = HttpClients.custom().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).disableRedirectHandling().disableAutomaticRetries().build();
        return new Apache5HttpTransport((HttpClient)client, handler.isMtls());
    }

    private GoogleApache5HttpTransport() {
    }

    @VisibleForTesting
    static class SocketFactoryRegistryHandler {
        private final Registry<ConnectionSocketFactory> socketFactoryRegistry;
        private final boolean isMtls;

        public SocketFactoryRegistryHandler(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
            KeyStore mtlsKeyStore = null;
            String mtlsKeyStorePassword = null;
            if (mtlsProvider.useMtlsClientCertificate()) {
                mtlsKeyStore = mtlsProvider.getKeyStore();
                mtlsKeyStorePassword = mtlsProvider.getKeyStorePassword();
            }
            SSLContext sslContext = SslUtils.getTlsSslContext();
            if (mtlsKeyStore != null && mtlsKeyStorePassword != null) {
                this.isMtls = true;
                SslUtils.initSslContext((SSLContext)sslContext, null, (TrustManagerFactory)SslUtils.getPkixTrustManagerFactory(), (KeyStore)mtlsKeyStore, (String)mtlsKeyStorePassword, (KeyManagerFactory)SslUtils.getDefaultKeyManagerFactory());
            } else {
                this.isMtls = false;
                SslUtils.initSslContext((SSLContext)sslContext, null, (TrustManagerFactory)SslUtils.getPkixTrustManagerFactory());
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
            this.socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)socketFactory).build();
        }

        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            return this.socketFactoryRegistry;
        }

        public boolean isMtls() {
            return this.isMtls;
        }
    }
}

