/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services.stub;

import com.google.ads.googleads.v21.services.GenerateConversionRatesRequest;
import com.google.ads.googleads.v21.services.GenerateConversionRatesResponse;
import com.google.ads.googleads.v21.services.GenerateReachForecastRequest;
import com.google.ads.googleads.v21.services.GenerateReachForecastResponse;
import com.google.ads.googleads.v21.services.ListPlannableLocationsRequest;
import com.google.ads.googleads.v21.services.ListPlannableLocationsResponse;
import com.google.ads.googleads.v21.services.ListPlannableProductsRequest;
import com.google.ads.googleads.v21.services.ListPlannableProductsResponse;
import com.google.ads.googleads.v21.services.ListPlannableUserInterestsRequest;
import com.google.ads.googleads.v21.services.ListPlannableUserInterestsResponse;
import com.google.ads.googleads.v21.services.ListPlannableUserListsRequest;
import com.google.ads.googleads.v21.services.ListPlannableUserListsResponse;
import com.google.ads.googleads.v21.services.stub.GrpcReachPlanServiceStub;
import com.google.ads.googleads.v21.services.stub.ReachPlanServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReachPlanServiceStubSettings
extends StubSettings<ReachPlanServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<GenerateConversionRatesRequest, GenerateConversionRatesResponse> generateConversionRatesSettings;
    private final UnaryCallSettings<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsSettings;
    private final UnaryCallSettings<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsSettings;
    private final UnaryCallSettings<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastSettings;
    private final UnaryCallSettings<ListPlannableUserListsRequest, ListPlannableUserListsResponse> listPlannableUserListsSettings;
    private final UnaryCallSettings<ListPlannableUserInterestsRequest, ListPlannableUserInterestsResponse> listPlannableUserInterestsSettings;

    public UnaryCallSettings<GenerateConversionRatesRequest, GenerateConversionRatesResponse> generateConversionRatesSettings() {
        return this.generateConversionRatesSettings;
    }

    public UnaryCallSettings<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsSettings() {
        return this.listPlannableLocationsSettings;
    }

    public UnaryCallSettings<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsSettings() {
        return this.listPlannableProductsSettings;
    }

    public UnaryCallSettings<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastSettings() {
        return this.generateReachForecastSettings;
    }

    public UnaryCallSettings<ListPlannableUserListsRequest, ListPlannableUserListsResponse> listPlannableUserListsSettings() {
        return this.listPlannableUserListsSettings;
    }

    public UnaryCallSettings<ListPlannableUserInterestsRequest, ListPlannableUserInterestsResponse> listPlannableUserInterestsSettings() {
        return this.listPlannableUserInterestsSettings;
    }

    public ReachPlanServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcReachPlanServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReachPlanServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReachPlanServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReachPlanServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.generateConversionRatesSettings = settingsBuilder.generateConversionRatesSettings().build();
        this.listPlannableLocationsSettings = settingsBuilder.listPlannableLocationsSettings().build();
        this.listPlannableProductsSettings = settingsBuilder.listPlannableProductsSettings().build();
        this.generateReachForecastSettings = settingsBuilder.generateReachForecastSettings().build();
        this.listPlannableUserListsSettings = settingsBuilder.listPlannableUserListsSettings().build();
        this.listPlannableUserInterestsSettings = settingsBuilder.listPlannableUserInterestsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReachPlanServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GenerateConversionRatesRequest, GenerateConversionRatesResponse> generateConversionRatesSettings;
        private final UnaryCallSettings.Builder<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsSettings;
        private final UnaryCallSettings.Builder<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsSettings;
        private final UnaryCallSettings.Builder<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastSettings;
        private final UnaryCallSettings.Builder<ListPlannableUserListsRequest, ListPlannableUserListsResponse> listPlannableUserListsSettings;
        private final UnaryCallSettings.Builder<ListPlannableUserInterestsRequest, ListPlannableUserInterestsResponse> listPlannableUserInterestsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.generateConversionRatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlannableLocationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlannableProductsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateReachForecastSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlannableUserListsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlannableUserInterestsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateConversionRatesSettings, this.listPlannableLocationsSettings, this.listPlannableProductsSettings, this.generateReachForecastSettings, this.listPlannableUserListsSettings, this.listPlannableUserInterestsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReachPlanServiceStubSettings settings) {
            super((StubSettings)settings);
            this.generateConversionRatesSettings = settings.generateConversionRatesSettings.toBuilder();
            this.listPlannableLocationsSettings = settings.listPlannableLocationsSettings.toBuilder();
            this.listPlannableProductsSettings = settings.listPlannableProductsSettings.toBuilder();
            this.generateReachForecastSettings = settings.generateReachForecastSettings.toBuilder();
            this.listPlannableUserListsSettings = settings.listPlannableUserListsSettings.toBuilder();
            this.listPlannableUserInterestsSettings = settings.listPlannableUserInterestsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateConversionRatesSettings, this.listPlannableLocationsSettings, this.listPlannableProductsSettings, this.generateReachForecastSettings, this.listPlannableUserListsSettings, this.listPlannableUserInterestsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReachPlanServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReachPlanServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReachPlanServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReachPlanServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.generateConversionRatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPlannableLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPlannableProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateReachForecastSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPlannableUserListsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPlannableUserInterestsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GenerateConversionRatesRequest, GenerateConversionRatesResponse> generateConversionRatesSettings() {
            return this.generateConversionRatesSettings;
        }

        public UnaryCallSettings.Builder<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsSettings() {
            return this.listPlannableLocationsSettings;
        }

        public UnaryCallSettings.Builder<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsSettings() {
            return this.listPlannableProductsSettings;
        }

        public UnaryCallSettings.Builder<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastSettings() {
            return this.generateReachForecastSettings;
        }

        public UnaryCallSettings.Builder<ListPlannableUserListsRequest, ListPlannableUserListsResponse> listPlannableUserListsSettings() {
            return this.listPlannableUserListsSettings;
        }

        public UnaryCallSettings.Builder<ListPlannableUserInterestsRequest, ListPlannableUserInterestsResponse> listPlannableUserInterestsSettings() {
            return this.listPlannableUserInterestsSettings;
        }

        public ReachPlanServiceStubSettings build() throws IOException {
            return new ReachPlanServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(14400000L)).setTotalTimeoutDuration(Duration.ofMillis(14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

