/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services.stub;

import com.google.ads.googleads.v21.services.GenerateCreatorInsightsRequest;
import com.google.ads.googleads.v21.services.GenerateCreatorInsightsResponse;
import com.google.ads.googleads.v21.services.GenerateTrendingInsightsRequest;
import com.google.ads.googleads.v21.services.GenerateTrendingInsightsResponse;
import com.google.ads.googleads.v21.services.stub.ContentCreatorInsightsServiceStub;
import com.google.ads.googleads.v21.services.stub.GrpcContentCreatorInsightsServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ContentCreatorInsightsServiceStubSettings
extends StubSettings<ContentCreatorInsightsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<GenerateCreatorInsightsRequest, GenerateCreatorInsightsResponse> generateCreatorInsightsSettings;
    private final UnaryCallSettings<GenerateTrendingInsightsRequest, GenerateTrendingInsightsResponse> generateTrendingInsightsSettings;

    public UnaryCallSettings<GenerateCreatorInsightsRequest, GenerateCreatorInsightsResponse> generateCreatorInsightsSettings() {
        return this.generateCreatorInsightsSettings;
    }

    public UnaryCallSettings<GenerateTrendingInsightsRequest, GenerateTrendingInsightsResponse> generateTrendingInsightsSettings() {
        return this.generateTrendingInsightsSettings;
    }

    public ContentCreatorInsightsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcContentCreatorInsightsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ContentCreatorInsightsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ContentCreatorInsightsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ContentCreatorInsightsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.generateCreatorInsightsSettings = settingsBuilder.generateCreatorInsightsSettings().build();
        this.generateTrendingInsightsSettings = settingsBuilder.generateTrendingInsightsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ContentCreatorInsightsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GenerateCreatorInsightsRequest, GenerateCreatorInsightsResponse> generateCreatorInsightsSettings;
        private final UnaryCallSettings.Builder<GenerateTrendingInsightsRequest, GenerateTrendingInsightsResponse> generateTrendingInsightsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.generateCreatorInsightsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateTrendingInsightsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateCreatorInsightsSettings, this.generateTrendingInsightsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ContentCreatorInsightsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.generateCreatorInsightsSettings = settings.generateCreatorInsightsSettings.toBuilder();
            this.generateTrendingInsightsSettings = settings.generateTrendingInsightsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateCreatorInsightsSettings, this.generateTrendingInsightsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ContentCreatorInsightsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ContentCreatorInsightsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ContentCreatorInsightsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ContentCreatorInsightsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.generateCreatorInsightsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateTrendingInsightsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GenerateCreatorInsightsRequest, GenerateCreatorInsightsResponse> generateCreatorInsightsSettings() {
            return this.generateCreatorInsightsSettings;
        }

        public UnaryCallSettings.Builder<GenerateTrendingInsightsRequest, GenerateTrendingInsightsResponse> generateTrendingInsightsSettings() {
            return this.generateTrendingInsightsSettings;
        }

        public ContentCreatorInsightsServiceStubSettings build() throws IOException {
            return new ContentCreatorInsightsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(14400000L)).setTotalTimeoutDuration(Duration.ofMillis(14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

