/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services;

import com.google.ads.googleads.v21.common.KeywordInfo;
import com.google.ads.googleads.v21.common.KeywordInfoOrBuilder;
import com.google.ads.googleads.v21.enums.AdGroupTypeEnum;
import com.google.ads.googleads.v21.enums.AdvertisingChannelTypeEnum;
import com.google.ads.googleads.v21.enums.BiddingStrategyTypeEnum;
import com.google.ads.googleads.v21.enums.ConversionTrackingStatusEnum;
import com.google.ads.googleads.v21.enums.RecommendationTypeEnum;
import com.google.ads.googleads.v21.enums.TargetImpressionShareLocationEnum;
import com.google.ads.googleads.v21.services.GenerateRecommendationsRequestOrBuilder;
import com.google.ads.googleads.v21.services.RecommendationServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GenerateRecommendationsRequest
extends GeneratedMessageV3
implements GenerateRecommendationsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int RECOMMENDATION_TYPES_FIELD_NUMBER = 2;
    private List<Integer> recommendationTypes_;
    private static final Internal.ListAdapter.Converter<Integer, RecommendationTypeEnum.RecommendationType> recommendationTypes_converter_ = new Internal.ListAdapter.Converter<Integer, RecommendationTypeEnum.RecommendationType>(){

        public RecommendationTypeEnum.RecommendationType convert(Integer from) {
            RecommendationTypeEnum.RecommendationType result = RecommendationTypeEnum.RecommendationType.forNumber(from);
            return result == null ? RecommendationTypeEnum.RecommendationType.UNRECOGNIZED : result;
        }
    };
    private int recommendationTypesMemoizedSerializedSize;
    public static final int ADVERTISING_CHANNEL_TYPE_FIELD_NUMBER = 3;
    private int advertisingChannelType_ = 0;
    public static final int CAMPAIGN_SITELINK_COUNT_FIELD_NUMBER = 4;
    private int campaignSitelinkCount_ = 0;
    public static final int CONVERSION_TRACKING_STATUS_FIELD_NUMBER = 5;
    private int conversionTrackingStatus_ = 0;
    public static final int BIDDING_INFO_FIELD_NUMBER = 6;
    private BiddingInfo biddingInfo_;
    public static final int AD_GROUP_INFO_FIELD_NUMBER = 7;
    private List<AdGroupInfo> adGroupInfo_;
    public static final int SEED_INFO_FIELD_NUMBER = 8;
    private SeedInfo seedInfo_;
    public static final int BUDGET_INFO_FIELD_NUMBER = 9;
    private BudgetInfo budgetInfo_;
    public static final int CAMPAIGN_IMAGE_ASSET_COUNT_FIELD_NUMBER = 10;
    private int campaignImageAssetCount_ = 0;
    public static final int CAMPAIGN_CALL_ASSET_COUNT_FIELD_NUMBER = 11;
    private int campaignCallAssetCount_ = 0;
    public static final int COUNTRY_CODES_FIELD_NUMBER = 13;
    private LazyStringArrayList countryCodes_ = LazyStringArrayList.emptyList();
    public static final int LANGUAGE_CODES_FIELD_NUMBER = 14;
    private LazyStringArrayList languageCodes_ = LazyStringArrayList.emptyList();
    public static final int POSITIVE_LOCATIONS_IDS_FIELD_NUMBER = 15;
    private Internal.LongList positiveLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
    private int positiveLocationsIdsMemoizedSerializedSize = -1;
    public static final int NEGATIVE_LOCATIONS_IDS_FIELD_NUMBER = 16;
    private Internal.LongList negativeLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
    private int negativeLocationsIdsMemoizedSerializedSize = -1;
    public static final int ASSET_GROUP_INFO_FIELD_NUMBER = 17;
    private List<AssetGroupInfo> assetGroupInfo_;
    public static final int TARGET_PARTNER_SEARCH_NETWORK_FIELD_NUMBER = 18;
    private boolean targetPartnerSearchNetwork_ = false;
    public static final int TARGET_CONTENT_NETWORK_FIELD_NUMBER = 19;
    private boolean targetContentNetwork_ = false;
    public static final int MERCHANT_CENTER_ACCOUNT_ID_FIELD_NUMBER = 20;
    private long merchantCenterAccountId_ = 0L;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateRecommendationsRequest DEFAULT_INSTANCE = new GenerateRecommendationsRequest();
    private static final Parser<GenerateRecommendationsRequest> PARSER = new AbstractParser<GenerateRecommendationsRequest>(){

        public GenerateRecommendationsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateRecommendationsRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateRecommendationsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateRecommendationsRequest() {
        this.customerId_ = "";
        this.recommendationTypes_ = Collections.emptyList();
        this.advertisingChannelType_ = 0;
        this.conversionTrackingStatus_ = 0;
        this.adGroupInfo_ = Collections.emptyList();
        this.countryCodes_ = LazyStringArrayList.emptyList();
        this.languageCodes_ = LazyStringArrayList.emptyList();
        this.positiveLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
        this.negativeLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
        this.assetGroupInfo_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateRecommendationsRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateRecommendationsRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<RecommendationTypeEnum.RecommendationType> getRecommendationTypesList() {
        return new Internal.ListAdapter(this.recommendationTypes_, recommendationTypes_converter_);
    }

    @Override
    public int getRecommendationTypesCount() {
        return this.recommendationTypes_.size();
    }

    @Override
    public RecommendationTypeEnum.RecommendationType getRecommendationTypes(int index) {
        return (RecommendationTypeEnum.RecommendationType)((Object)recommendationTypes_converter_.convert((Object)this.recommendationTypes_.get(index)));
    }

    @Override
    public List<Integer> getRecommendationTypesValueList() {
        return this.recommendationTypes_;
    }

    @Override
    public int getRecommendationTypesValue(int index) {
        return this.recommendationTypes_.get(index);
    }

    @Override
    public int getAdvertisingChannelTypeValue() {
        return this.advertisingChannelType_;
    }

    @Override
    public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
        AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber(this.advertisingChannelType_);
        return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasCampaignSitelinkCount() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public int getCampaignSitelinkCount() {
        return this.campaignSitelinkCount_;
    }

    @Override
    public boolean hasConversionTrackingStatus() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public int getConversionTrackingStatusValue() {
        return this.conversionTrackingStatus_;
    }

    @Override
    public ConversionTrackingStatusEnum.ConversionTrackingStatus getConversionTrackingStatus() {
        ConversionTrackingStatusEnum.ConversionTrackingStatus result = ConversionTrackingStatusEnum.ConversionTrackingStatus.forNumber(this.conversionTrackingStatus_);
        return result == null ? ConversionTrackingStatusEnum.ConversionTrackingStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasBiddingInfo() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public BiddingInfo getBiddingInfo() {
        return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
    }

    @Override
    public BiddingInfoOrBuilder getBiddingInfoOrBuilder() {
        return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
    }

    @Override
    public List<AdGroupInfo> getAdGroupInfoList() {
        return this.adGroupInfo_;
    }

    @Override
    public List<? extends AdGroupInfoOrBuilder> getAdGroupInfoOrBuilderList() {
        return this.adGroupInfo_;
    }

    @Override
    public int getAdGroupInfoCount() {
        return this.adGroupInfo_.size();
    }

    @Override
    public AdGroupInfo getAdGroupInfo(int index) {
        return this.adGroupInfo_.get(index);
    }

    @Override
    public AdGroupInfoOrBuilder getAdGroupInfoOrBuilder(int index) {
        return this.adGroupInfo_.get(index);
    }

    @Override
    public boolean hasSeedInfo() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public SeedInfo getSeedInfo() {
        return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
    }

    @Override
    public SeedInfoOrBuilder getSeedInfoOrBuilder() {
        return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
    }

    @Override
    public boolean hasBudgetInfo() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public BudgetInfo getBudgetInfo() {
        return this.budgetInfo_ == null ? BudgetInfo.getDefaultInstance() : this.budgetInfo_;
    }

    @Override
    public BudgetInfoOrBuilder getBudgetInfoOrBuilder() {
        return this.budgetInfo_ == null ? BudgetInfo.getDefaultInstance() : this.budgetInfo_;
    }

    @Override
    public boolean hasCampaignImageAssetCount() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public int getCampaignImageAssetCount() {
        return this.campaignImageAssetCount_;
    }

    @Override
    public boolean hasCampaignCallAssetCount() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public int getCampaignCallAssetCount() {
        return this.campaignCallAssetCount_;
    }

    public ProtocolStringList getCountryCodesList() {
        return this.countryCodes_;
    }

    @Override
    public int getCountryCodesCount() {
        return this.countryCodes_.size();
    }

    @Override
    public String getCountryCodes(int index) {
        return this.countryCodes_.get(index);
    }

    @Override
    public ByteString getCountryCodesBytes(int index) {
        return this.countryCodes_.getByteString(index);
    }

    public ProtocolStringList getLanguageCodesList() {
        return this.languageCodes_;
    }

    @Override
    public int getLanguageCodesCount() {
        return this.languageCodes_.size();
    }

    @Override
    public String getLanguageCodes(int index) {
        return this.languageCodes_.get(index);
    }

    @Override
    public ByteString getLanguageCodesBytes(int index) {
        return this.languageCodes_.getByteString(index);
    }

    @Override
    public List<Long> getPositiveLocationsIdsList() {
        return this.positiveLocationsIds_;
    }

    @Override
    public int getPositiveLocationsIdsCount() {
        return this.positiveLocationsIds_.size();
    }

    @Override
    public long getPositiveLocationsIds(int index) {
        return this.positiveLocationsIds_.getLong(index);
    }

    @Override
    public List<Long> getNegativeLocationsIdsList() {
        return this.negativeLocationsIds_;
    }

    @Override
    public int getNegativeLocationsIdsCount() {
        return this.negativeLocationsIds_.size();
    }

    @Override
    public long getNegativeLocationsIds(int index) {
        return this.negativeLocationsIds_.getLong(index);
    }

    @Override
    public List<AssetGroupInfo> getAssetGroupInfoList() {
        return this.assetGroupInfo_;
    }

    @Override
    public List<? extends AssetGroupInfoOrBuilder> getAssetGroupInfoOrBuilderList() {
        return this.assetGroupInfo_;
    }

    @Override
    public int getAssetGroupInfoCount() {
        return this.assetGroupInfo_.size();
    }

    @Override
    public AssetGroupInfo getAssetGroupInfo(int index) {
        return this.assetGroupInfo_.get(index);
    }

    @Override
    public AssetGroupInfoOrBuilder getAssetGroupInfoOrBuilder(int index) {
        return this.assetGroupInfo_.get(index);
    }

    @Override
    public boolean hasTargetPartnerSearchNetwork() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public boolean getTargetPartnerSearchNetwork() {
        return this.targetPartnerSearchNetwork_;
    }

    @Override
    public boolean hasTargetContentNetwork() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public boolean getTargetContentNetwork() {
        return this.targetContentNetwork_;
    }

    @Override
    public boolean hasMerchantCenterAccountId() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public long getMerchantCenterAccountId() {
        return this.merchantCenterAccountId_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if (this.getRecommendationTypesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.recommendationTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.recommendationTypes_.size(); ++i) {
            output.writeEnumNoTag(this.recommendationTypes_.get(i).intValue());
        }
        if (this.advertisingChannelType_ != AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.advertisingChannelType_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt32(4, this.campaignSitelinkCount_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeEnum(5, this.conversionTrackingStatus_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getBiddingInfo());
        }
        for (i = 0; i < this.adGroupInfo_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.adGroupInfo_.get(i));
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(8, (MessageLite)this.getSeedInfo());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(9, (MessageLite)this.getBudgetInfo());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeInt32(10, this.campaignImageAssetCount_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeInt32(11, this.campaignCallAssetCount_);
        }
        for (i = 0; i < this.countryCodes_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.countryCodes_.getRaw(i));
        }
        for (i = 0; i < this.languageCodes_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.languageCodes_.getRaw(i));
        }
        if (this.getPositiveLocationsIdsList().size() > 0) {
            output.writeUInt32NoTag(122);
            output.writeUInt32NoTag(this.positiveLocationsIdsMemoizedSerializedSize);
        }
        for (i = 0; i < this.positiveLocationsIds_.size(); ++i) {
            output.writeInt64NoTag(this.positiveLocationsIds_.getLong(i));
        }
        if (this.getNegativeLocationsIdsList().size() > 0) {
            output.writeUInt32NoTag(130);
            output.writeUInt32NoTag(this.negativeLocationsIdsMemoizedSerializedSize);
        }
        for (i = 0; i < this.negativeLocationsIds_.size(); ++i) {
            output.writeInt64NoTag(this.negativeLocationsIds_.getLong(i));
        }
        for (i = 0; i < this.assetGroupInfo_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.assetGroupInfo_.get(i));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeBool(18, this.targetPartnerSearchNetwork_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeBool(19, this.targetContentNetwork_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            output.writeInt64(20, this.merchantCenterAccountId_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        int dataSize = 0;
        for (i2 = 0; i2 < this.recommendationTypes_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.recommendationTypes_.get(i2));
        }
        size += dataSize;
        if (!this.getRecommendationTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.recommendationTypesMemoizedSerializedSize = dataSize;
        if (this.advertisingChannelType_ != AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.advertisingChannelType_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt32Size((int)4, (int)this.campaignSitelinkCount_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.conversionTrackingStatus_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getBiddingInfo());
        }
        for (i = 0; i < this.adGroupInfo_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.adGroupInfo_.get(i)));
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getSeedInfo());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getBudgetInfo());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeInt32Size((int)10, (int)this.campaignImageAssetCount_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeInt32Size((int)11, (int)this.campaignCallAssetCount_);
        }
        dataSize = 0;
        for (i2 = 0; i2 < this.countryCodes_.size(); ++i2) {
            dataSize += GenerateRecommendationsRequest.computeStringSizeNoTag((Object)this.countryCodes_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getCountryCodesList().size();
        dataSize = 0;
        for (i2 = 0; i2 < this.languageCodes_.size(); ++i2) {
            dataSize += GenerateRecommendationsRequest.computeStringSizeNoTag((Object)this.languageCodes_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getLanguageCodesList().size();
        dataSize = 0;
        for (i2 = 0; i2 < this.positiveLocationsIds_.size(); ++i2) {
            dataSize += CodedOutputStream.computeInt64SizeNoTag((long)this.positiveLocationsIds_.getLong(i2));
        }
        size += dataSize;
        if (!this.getPositiveLocationsIdsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.positiveLocationsIdsMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i2 = 0; i2 < this.negativeLocationsIds_.size(); ++i2) {
            dataSize += CodedOutputStream.computeInt64SizeNoTag((long)this.negativeLocationsIds_.getLong(i2));
        }
        size += dataSize;
        if (!this.getNegativeLocationsIdsList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.negativeLocationsIdsMemoizedSerializedSize = dataSize;
        for (i = 0; i < this.assetGroupInfo_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.assetGroupInfo_.get(i)));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeBoolSize((int)18, (boolean)this.targetPartnerSearchNetwork_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeBoolSize((int)19, (boolean)this.targetContentNetwork_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            size += CodedOutputStream.computeInt64Size((int)20, (long)this.merchantCenterAccountId_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateRecommendationsRequest)) {
            return super.equals(obj);
        }
        GenerateRecommendationsRequest other = (GenerateRecommendationsRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.recommendationTypes_.equals(other.recommendationTypes_)) {
            return false;
        }
        if (this.advertisingChannelType_ != other.advertisingChannelType_) {
            return false;
        }
        if (this.hasCampaignSitelinkCount() != other.hasCampaignSitelinkCount()) {
            return false;
        }
        if (this.hasCampaignSitelinkCount() && this.getCampaignSitelinkCount() != other.getCampaignSitelinkCount()) {
            return false;
        }
        if (this.hasConversionTrackingStatus() != other.hasConversionTrackingStatus()) {
            return false;
        }
        if (this.hasConversionTrackingStatus() && this.conversionTrackingStatus_ != other.conversionTrackingStatus_) {
            return false;
        }
        if (this.hasBiddingInfo() != other.hasBiddingInfo()) {
            return false;
        }
        if (this.hasBiddingInfo() && !this.getBiddingInfo().equals(other.getBiddingInfo())) {
            return false;
        }
        if (!this.getAdGroupInfoList().equals(other.getAdGroupInfoList())) {
            return false;
        }
        if (this.hasSeedInfo() != other.hasSeedInfo()) {
            return false;
        }
        if (this.hasSeedInfo() && !this.getSeedInfo().equals(other.getSeedInfo())) {
            return false;
        }
        if (this.hasBudgetInfo() != other.hasBudgetInfo()) {
            return false;
        }
        if (this.hasBudgetInfo() && !this.getBudgetInfo().equals(other.getBudgetInfo())) {
            return false;
        }
        if (this.hasCampaignImageAssetCount() != other.hasCampaignImageAssetCount()) {
            return false;
        }
        if (this.hasCampaignImageAssetCount() && this.getCampaignImageAssetCount() != other.getCampaignImageAssetCount()) {
            return false;
        }
        if (this.hasCampaignCallAssetCount() != other.hasCampaignCallAssetCount()) {
            return false;
        }
        if (this.hasCampaignCallAssetCount() && this.getCampaignCallAssetCount() != other.getCampaignCallAssetCount()) {
            return false;
        }
        if (!this.getCountryCodesList().equals(other.getCountryCodesList())) {
            return false;
        }
        if (!this.getLanguageCodesList().equals(other.getLanguageCodesList())) {
            return false;
        }
        if (!this.getPositiveLocationsIdsList().equals(other.getPositiveLocationsIdsList())) {
            return false;
        }
        if (!this.getNegativeLocationsIdsList().equals(other.getNegativeLocationsIdsList())) {
            return false;
        }
        if (!this.getAssetGroupInfoList().equals(other.getAssetGroupInfoList())) {
            return false;
        }
        if (this.hasTargetPartnerSearchNetwork() != other.hasTargetPartnerSearchNetwork()) {
            return false;
        }
        if (this.hasTargetPartnerSearchNetwork() && this.getTargetPartnerSearchNetwork() != other.getTargetPartnerSearchNetwork()) {
            return false;
        }
        if (this.hasTargetContentNetwork() != other.hasTargetContentNetwork()) {
            return false;
        }
        if (this.hasTargetContentNetwork() && this.getTargetContentNetwork() != other.getTargetContentNetwork()) {
            return false;
        }
        if (this.hasMerchantCenterAccountId() != other.hasMerchantCenterAccountId()) {
            return false;
        }
        if (this.hasMerchantCenterAccountId() && this.getMerchantCenterAccountId() != other.getMerchantCenterAccountId()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateRecommendationsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getRecommendationTypesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.recommendationTypes_.hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.advertisingChannelType_;
        if (this.hasCampaignSitelinkCount()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getCampaignSitelinkCount();
        }
        if (this.hasConversionTrackingStatus()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.conversionTrackingStatus_;
        }
        if (this.hasBiddingInfo()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getBiddingInfo().hashCode();
        }
        if (this.getAdGroupInfoCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAdGroupInfoList().hashCode();
        }
        if (this.hasSeedInfo()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getSeedInfo().hashCode();
        }
        if (this.hasBudgetInfo()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getBudgetInfo().hashCode();
        }
        if (this.hasCampaignImageAssetCount()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getCampaignImageAssetCount();
        }
        if (this.hasCampaignCallAssetCount()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getCampaignCallAssetCount();
        }
        if (this.getCountryCodesCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getCountryCodesList().hashCode();
        }
        if (this.getLanguageCodesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getLanguageCodesList().hashCode();
        }
        if (this.getPositiveLocationsIdsCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getPositiveLocationsIdsList().hashCode();
        }
        if (this.getNegativeLocationsIdsCount() > 0) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getNegativeLocationsIdsList().hashCode();
        }
        if (this.getAssetGroupInfoCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getAssetGroupInfoList().hashCode();
        }
        if (this.hasTargetPartnerSearchNetwork()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getTargetPartnerSearchNetwork());
        }
        if (this.hasTargetContentNetwork()) {
            hash = 37 * hash + 19;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getTargetContentNetwork());
        }
        if (this.hasMerchantCenterAccountId()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + Internal.hashLong((long)this.getMerchantCenterAccountId());
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateRecommendationsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data);
    }

    public static GenerateRecommendationsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data);
    }

    public static GenerateRecommendationsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data);
    }

    public static GenerateRecommendationsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(InputStream input) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateRecommendationsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateRecommendationsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateRecommendationsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateRecommendationsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateRecommendationsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateRecommendationsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateRecommendationsRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateRecommendationsRequest> getParserForType() {
        return PARSER;
    }

    public GenerateRecommendationsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.LongList access$7600() {
        return GenerateRecommendationsRequest.emptyLongList();
    }

    static /* synthetic */ Internal.LongList access$7900() {
        return GenerateRecommendationsRequest.emptyLongList();
    }

    public static final class BudgetInfo
    extends GeneratedMessageV3
    implements BudgetInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int CURRENT_BUDGET_FIELD_NUMBER = 1;
        private long currentBudget_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final BudgetInfo DEFAULT_INSTANCE = new BudgetInfo();
        private static final Parser<BudgetInfo> PARSER = new AbstractParser<BudgetInfo>(){

            public BudgetInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = BudgetInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private BudgetInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BudgetInfo() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new BudgetInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BudgetInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BudgetInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(BudgetInfo.class, Builder.class);
        }

        @Override
        public boolean hasCurrentBudget() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public long getCurrentBudget() {
            return this.currentBudget_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeInt64(1, this.currentBudget_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeInt64Size((int)1, (long)this.currentBudget_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BudgetInfo)) {
                return super.equals(obj);
            }
            BudgetInfo other = (BudgetInfo)obj;
            if (this.hasCurrentBudget() != other.hasCurrentBudget()) {
                return false;
            }
            if (this.hasCurrentBudget() && this.getCurrentBudget() != other.getCurrentBudget()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + BudgetInfo.getDescriptor().hashCode();
            if (this.hasCurrentBudget()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashLong((long)this.getCurrentBudget());
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static BudgetInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (BudgetInfo)PARSER.parseFrom(data);
        }

        public static BudgetInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BudgetInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BudgetInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BudgetInfo)PARSER.parseFrom(data);
        }

        public static BudgetInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BudgetInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BudgetInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BudgetInfo)PARSER.parseFrom(data);
        }

        public static BudgetInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BudgetInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BudgetInfo parseFrom(InputStream input) throws IOException {
            return (BudgetInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static BudgetInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BudgetInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BudgetInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (BudgetInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static BudgetInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BudgetInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BudgetInfo parseFrom(CodedInputStream input) throws IOException {
            return (BudgetInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static BudgetInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BudgetInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return BudgetInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(BudgetInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static BudgetInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<BudgetInfo> parser() {
            return PARSER;
        }

        public Parser<BudgetInfo> getParserForType() {
            return PARSER;
        }

        public BudgetInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements BudgetInfoOrBuilder {
            private int bitField0_;
            private long currentBudget_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BudgetInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BudgetInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(BudgetInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.currentBudget_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BudgetInfo_descriptor;
            }

            public BudgetInfo getDefaultInstanceForType() {
                return BudgetInfo.getDefaultInstance();
            }

            public BudgetInfo build() {
                BudgetInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public BudgetInfo buildPartial() {
                BudgetInfo result = new BudgetInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(BudgetInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.currentBudget_ = this.currentBudget_;
                    to_bitField0_ |= 1;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof BudgetInfo) {
                    return this.mergeFrom((BudgetInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(BudgetInfo other) {
                if (other == BudgetInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasCurrentBudget()) {
                    this.setCurrentBudget(other.getCurrentBudget());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 8: {
                                this.currentBudget_ = input.readInt64();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasCurrentBudget() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public long getCurrentBudget() {
                return this.currentBudget_;
            }

            public Builder setCurrentBudget(long value) {
                this.currentBudget_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCurrentBudget() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.currentBudget_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class SeedInfo
    extends GeneratedMessageV3
    implements SeedInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int URL_SEED_FIELD_NUMBER = 2;
        private volatile Object urlSeed_ = "";
        public static final int KEYWORD_SEEDS_FIELD_NUMBER = 3;
        private LazyStringArrayList keywordSeeds_ = LazyStringArrayList.emptyList();
        private byte memoizedIsInitialized = (byte)-1;
        private static final SeedInfo DEFAULT_INSTANCE = new SeedInfo();
        private static final Parser<SeedInfo> PARSER = new AbstractParser<SeedInfo>(){

            public SeedInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = SeedInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private SeedInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private SeedInfo() {
            this.urlSeed_ = "";
            this.keywordSeeds_ = LazyStringArrayList.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new SeedInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_SeedInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_SeedInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(SeedInfo.class, Builder.class);
        }

        @Override
        public boolean hasUrlSeed() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getUrlSeed() {
            Object ref = this.urlSeed_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.urlSeed_ = s;
            return s;
        }

        @Override
        public ByteString getUrlSeedBytes() {
            Object ref = this.urlSeed_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.urlSeed_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public ProtocolStringList getKeywordSeedsList() {
            return this.keywordSeeds_;
        }

        @Override
        public int getKeywordSeedsCount() {
            return this.keywordSeeds_.size();
        }

        @Override
        public String getKeywordSeeds(int index) {
            return this.keywordSeeds_.get(index);
        }

        @Override
        public ByteString getKeywordSeedsBytes(int index) {
            return this.keywordSeeds_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.urlSeed_);
            }
            for (int i = 0; i < this.keywordSeeds_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.keywordSeeds_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.urlSeed_);
            }
            int dataSize = 0;
            for (int i = 0; i < this.keywordSeeds_.size(); ++i) {
                dataSize += SeedInfo.computeStringSizeNoTag((Object)this.keywordSeeds_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getKeywordSeedsList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SeedInfo)) {
                return super.equals(obj);
            }
            SeedInfo other = (SeedInfo)obj;
            if (this.hasUrlSeed() != other.hasUrlSeed()) {
                return false;
            }
            if (this.hasUrlSeed() && !this.getUrlSeed().equals(other.getUrlSeed())) {
                return false;
            }
            if (!this.getKeywordSeedsList().equals(other.getKeywordSeedsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + SeedInfo.getDescriptor().hashCode();
            if (this.hasUrlSeed()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getUrlSeed().hashCode();
            }
            if (this.getKeywordSeedsCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getKeywordSeedsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static SeedInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data);
        }

        public static SeedInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SeedInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data);
        }

        public static SeedInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SeedInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data);
        }

        public static SeedInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SeedInfo parseFrom(InputStream input) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static SeedInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SeedInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static SeedInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SeedInfo parseFrom(CodedInputStream input) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static SeedInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return SeedInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(SeedInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static SeedInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<SeedInfo> parser() {
            return PARSER;
        }

        public Parser<SeedInfo> getParserForType() {
            return PARSER;
        }

        public SeedInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements SeedInfoOrBuilder {
            private int bitField0_;
            private Object urlSeed_ = "";
            private LazyStringArrayList keywordSeeds_ = LazyStringArrayList.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_SeedInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_SeedInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(SeedInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.urlSeed_ = "";
                this.keywordSeeds_ = LazyStringArrayList.emptyList();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_SeedInfo_descriptor;
            }

            public SeedInfo getDefaultInstanceForType() {
                return SeedInfo.getDefaultInstance();
            }

            public SeedInfo build() {
                SeedInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public SeedInfo buildPartial() {
                SeedInfo result = new SeedInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(SeedInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.urlSeed_ = this.urlSeed_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    this.keywordSeeds_.makeImmutable();
                    result.keywordSeeds_ = this.keywordSeeds_;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof SeedInfo) {
                    return this.mergeFrom((SeedInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(SeedInfo other) {
                if (other == SeedInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasUrlSeed()) {
                    this.urlSeed_ = other.urlSeed_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.keywordSeeds_.isEmpty()) {
                    if (this.keywordSeeds_.isEmpty()) {
                        this.keywordSeeds_ = other.keywordSeeds_;
                        this.bitField0_ |= 2;
                    } else {
                        this.ensureKeywordSeedsIsMutable();
                        this.keywordSeeds_.addAll((Collection)other.keywordSeeds_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 18: {
                                this.urlSeed_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 26: {
                                String s = input.readStringRequireUtf8();
                                this.ensureKeywordSeedsIsMutable();
                                this.keywordSeeds_.add(s);
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasUrlSeed() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getUrlSeed() {
                Object ref = this.urlSeed_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.urlSeed_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getUrlSeedBytes() {
                Object ref = this.urlSeed_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.urlSeed_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setUrlSeed(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.urlSeed_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearUrlSeed() {
                this.urlSeed_ = SeedInfo.getDefaultInstance().getUrlSeed();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setUrlSeedBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SeedInfo.checkByteStringIsUtf8((ByteString)value);
                this.urlSeed_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureKeywordSeedsIsMutable() {
                if (!this.keywordSeeds_.isModifiable()) {
                    this.keywordSeeds_ = new LazyStringArrayList((LazyStringList)this.keywordSeeds_);
                }
                this.bitField0_ |= 2;
            }

            public ProtocolStringList getKeywordSeedsList() {
                this.keywordSeeds_.makeImmutable();
                return this.keywordSeeds_;
            }

            @Override
            public int getKeywordSeedsCount() {
                return this.keywordSeeds_.size();
            }

            @Override
            public String getKeywordSeeds(int index) {
                return this.keywordSeeds_.get(index);
            }

            @Override
            public ByteString getKeywordSeedsBytes(int index) {
                return this.keywordSeeds_.getByteString(index);
            }

            public Builder setKeywordSeeds(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordSeedsIsMutable();
                this.keywordSeeds_.set(index, value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addKeywordSeeds(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordSeedsIsMutable();
                this.keywordSeeds_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllKeywordSeeds(Iterable<String> values) {
                this.ensureKeywordSeedsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.keywordSeeds_);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearKeywordSeeds() {
                this.keywordSeeds_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder addKeywordSeedsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SeedInfo.checkByteStringIsUtf8((ByteString)value);
                this.ensureKeywordSeedsIsMutable();
                this.keywordSeeds_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class BiddingInfo
    extends GeneratedMessageV3
    implements BiddingInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        private int biddingStrategyTargetInfoCase_ = 0;
        private Object biddingStrategyTargetInfo_;
        public static final int BIDDING_STRATEGY_TYPE_FIELD_NUMBER = 1;
        private int biddingStrategyType_ = 0;
        public static final int TARGET_CPA_MICROS_FIELD_NUMBER = 2;
        public static final int TARGET_ROAS_FIELD_NUMBER = 3;
        public static final int TARGET_IMPRESSION_SHARE_INFO_FIELD_NUMBER = 4;
        private byte memoizedIsInitialized = (byte)-1;
        private static final BiddingInfo DEFAULT_INSTANCE = new BiddingInfo();
        private static final Parser<BiddingInfo> PARSER = new AbstractParser<BiddingInfo>(){

            public BiddingInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = BiddingInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private BiddingInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BiddingInfo() {
            this.biddingStrategyType_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new BiddingInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BiddingInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BiddingInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(BiddingInfo.class, Builder.class);
        }

        @Override
        public BiddingStrategyTargetInfoCase getBiddingStrategyTargetInfoCase() {
            return BiddingStrategyTargetInfoCase.forNumber(this.biddingStrategyTargetInfoCase_);
        }

        @Override
        public boolean hasBiddingStrategyType() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getBiddingStrategyTypeValue() {
            return this.biddingStrategyType_;
        }

        @Override
        public BiddingStrategyTypeEnum.BiddingStrategyType getBiddingStrategyType() {
            BiddingStrategyTypeEnum.BiddingStrategyType result = BiddingStrategyTypeEnum.BiddingStrategyType.forNumber(this.biddingStrategyType_);
            return result == null ? BiddingStrategyTypeEnum.BiddingStrategyType.UNRECOGNIZED : result;
        }

        @Override
        public boolean hasTargetCpaMicros() {
            return this.biddingStrategyTargetInfoCase_ == 2;
        }

        @Override
        public long getTargetCpaMicros() {
            if (this.biddingStrategyTargetInfoCase_ == 2) {
                return (Long)this.biddingStrategyTargetInfo_;
            }
            return 0L;
        }

        @Override
        public boolean hasTargetRoas() {
            return this.biddingStrategyTargetInfoCase_ == 3;
        }

        @Override
        public double getTargetRoas() {
            if (this.biddingStrategyTargetInfoCase_ == 3) {
                return (Double)this.biddingStrategyTargetInfo_;
            }
            return 0.0;
        }

        @Override
        public boolean hasTargetImpressionShareInfo() {
            return this.biddingStrategyTargetInfoCase_ == 4;
        }

        @Override
        public TargetImpressionShareInfo getTargetImpressionShareInfo() {
            if (this.biddingStrategyTargetInfoCase_ == 4) {
                return (TargetImpressionShareInfo)this.biddingStrategyTargetInfo_;
            }
            return TargetImpressionShareInfo.getDefaultInstance();
        }

        @Override
        public TargetImpressionShareInfoOrBuilder getTargetImpressionShareInfoOrBuilder() {
            if (this.biddingStrategyTargetInfoCase_ == 4) {
                return (TargetImpressionShareInfo)this.biddingStrategyTargetInfo_;
            }
            return TargetImpressionShareInfo.getDefaultInstance();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.biddingStrategyType_);
            }
            if (this.biddingStrategyTargetInfoCase_ == 2) {
                output.writeInt64(2, ((Long)this.biddingStrategyTargetInfo_).longValue());
            }
            if (this.biddingStrategyTargetInfoCase_ == 3) {
                output.writeDouble(3, ((Double)this.biddingStrategyTargetInfo_).doubleValue());
            }
            if (this.biddingStrategyTargetInfoCase_ == 4) {
                output.writeMessage(4, (MessageLite)((TargetImpressionShareInfo)this.biddingStrategyTargetInfo_));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.biddingStrategyType_);
            }
            if (this.biddingStrategyTargetInfoCase_ == 2) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)((Long)this.biddingStrategyTargetInfo_));
            }
            if (this.biddingStrategyTargetInfoCase_ == 3) {
                size += CodedOutputStream.computeDoubleSize((int)3, (double)((Double)this.biddingStrategyTargetInfo_));
            }
            if (this.biddingStrategyTargetInfoCase_ == 4) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((TargetImpressionShareInfo)this.biddingStrategyTargetInfo_));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BiddingInfo)) {
                return super.equals(obj);
            }
            BiddingInfo other = (BiddingInfo)obj;
            if (this.hasBiddingStrategyType() != other.hasBiddingStrategyType()) {
                return false;
            }
            if (this.hasBiddingStrategyType() && this.biddingStrategyType_ != other.biddingStrategyType_) {
                return false;
            }
            if (!this.getBiddingStrategyTargetInfoCase().equals((Object)other.getBiddingStrategyTargetInfoCase())) {
                return false;
            }
            switch (this.biddingStrategyTargetInfoCase_) {
                case 2: {
                    if (this.getTargetCpaMicros() == other.getTargetCpaMicros()) break;
                    return false;
                }
                case 3: {
                    if (Double.doubleToLongBits(this.getTargetRoas()) == Double.doubleToLongBits(other.getTargetRoas())) break;
                    return false;
                }
                case 4: {
                    if (this.getTargetImpressionShareInfo().equals(other.getTargetImpressionShareInfo())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + BiddingInfo.getDescriptor().hashCode();
            if (this.hasBiddingStrategyType()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.biddingStrategyType_;
            }
            switch (this.biddingStrategyTargetInfoCase_) {
                case 2: {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + Internal.hashLong((long)this.getTargetCpaMicros());
                    break;
                }
                case 3: {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getTargetRoas()));
                    break;
                }
                case 4: {
                    hash = 37 * hash + 4;
                    hash = 53 * hash + this.getTargetImpressionShareInfo().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static BiddingInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data);
        }

        public static BiddingInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BiddingInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data);
        }

        public static BiddingInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BiddingInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data);
        }

        public static BiddingInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BiddingInfo parseFrom(InputStream input) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static BiddingInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BiddingInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static BiddingInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BiddingInfo parseFrom(CodedInputStream input) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static BiddingInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return BiddingInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(BiddingInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static BiddingInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<BiddingInfo> parser() {
            return PARSER;
        }

        public Parser<BiddingInfo> getParserForType() {
            return PARSER;
        }

        public BiddingInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements BiddingInfoOrBuilder {
            private int biddingStrategyTargetInfoCase_ = 0;
            private Object biddingStrategyTargetInfo_;
            private int bitField0_;
            private int biddingStrategyType_ = 0;
            private SingleFieldBuilderV3<TargetImpressionShareInfo, TargetImpressionShareInfo.Builder, TargetImpressionShareInfoOrBuilder> targetImpressionShareInfoBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BiddingInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BiddingInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(BiddingInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.biddingStrategyType_ = 0;
                if (this.targetImpressionShareInfoBuilder_ != null) {
                    this.targetImpressionShareInfoBuilder_.clear();
                }
                this.biddingStrategyTargetInfoCase_ = 0;
                this.biddingStrategyTargetInfo_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_BiddingInfo_descriptor;
            }

            public BiddingInfo getDefaultInstanceForType() {
                return BiddingInfo.getDefaultInstance();
            }

            public BiddingInfo build() {
                BiddingInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public BiddingInfo buildPartial() {
                BiddingInfo result = new BiddingInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(BiddingInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.biddingStrategyType_ = this.biddingStrategyType_;
                    to_bitField0_ |= 1;
                }
                result.bitField0_ |= to_bitField0_;
            }

            private void buildPartialOneofs(BiddingInfo result) {
                result.biddingStrategyTargetInfoCase_ = this.biddingStrategyTargetInfoCase_;
                result.biddingStrategyTargetInfo_ = this.biddingStrategyTargetInfo_;
                if (this.biddingStrategyTargetInfoCase_ == 4 && this.targetImpressionShareInfoBuilder_ != null) {
                    result.biddingStrategyTargetInfo_ = this.targetImpressionShareInfoBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof BiddingInfo) {
                    return this.mergeFrom((BiddingInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(BiddingInfo other) {
                if (other == BiddingInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasBiddingStrategyType()) {
                    this.setBiddingStrategyType(other.getBiddingStrategyType());
                }
                switch (other.getBiddingStrategyTargetInfoCase()) {
                    case TARGET_CPA_MICROS: {
                        this.setTargetCpaMicros(other.getTargetCpaMicros());
                        break;
                    }
                    case TARGET_ROAS: {
                        this.setTargetRoas(other.getTargetRoas());
                        break;
                    }
                    case TARGET_IMPRESSION_SHARE_INFO: {
                        this.mergeTargetImpressionShareInfo(other.getTargetImpressionShareInfo());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block12: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block12;
                            }
                            case 8: {
                                this.biddingStrategyType_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block12;
                            }
                            case 16: {
                                this.biddingStrategyTargetInfo_ = input.readInt64();
                                this.biddingStrategyTargetInfoCase_ = 2;
                                continue block12;
                            }
                            case 25: {
                                this.biddingStrategyTargetInfo_ = input.readDouble();
                                this.biddingStrategyTargetInfoCase_ = 3;
                                continue block12;
                            }
                            case 34: {
                                input.readMessage((MessageLite.Builder)this.getTargetImpressionShareInfoFieldBuilder().getBuilder(), extensionRegistry);
                                this.biddingStrategyTargetInfoCase_ = 4;
                                continue block12;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public BiddingStrategyTargetInfoCase getBiddingStrategyTargetInfoCase() {
                return BiddingStrategyTargetInfoCase.forNumber(this.biddingStrategyTargetInfoCase_);
            }

            public Builder clearBiddingStrategyTargetInfo() {
                this.biddingStrategyTargetInfoCase_ = 0;
                this.biddingStrategyTargetInfo_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBiddingStrategyType() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getBiddingStrategyTypeValue() {
                return this.biddingStrategyType_;
            }

            public Builder setBiddingStrategyTypeValue(int value) {
                this.biddingStrategyType_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public BiddingStrategyTypeEnum.BiddingStrategyType getBiddingStrategyType() {
                BiddingStrategyTypeEnum.BiddingStrategyType result = BiddingStrategyTypeEnum.BiddingStrategyType.forNumber(this.biddingStrategyType_);
                return result == null ? BiddingStrategyTypeEnum.BiddingStrategyType.UNRECOGNIZED : result;
            }

            public Builder setBiddingStrategyType(BiddingStrategyTypeEnum.BiddingStrategyType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.biddingStrategyType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearBiddingStrategyType() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.biddingStrategyType_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTargetCpaMicros() {
                return this.biddingStrategyTargetInfoCase_ == 2;
            }

            @Override
            public long getTargetCpaMicros() {
                if (this.biddingStrategyTargetInfoCase_ == 2) {
                    return (Long)this.biddingStrategyTargetInfo_;
                }
                return 0L;
            }

            public Builder setTargetCpaMicros(long value) {
                this.biddingStrategyTargetInfoCase_ = 2;
                this.biddingStrategyTargetInfo_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearTargetCpaMicros() {
                if (this.biddingStrategyTargetInfoCase_ == 2) {
                    this.biddingStrategyTargetInfoCase_ = 0;
                    this.biddingStrategyTargetInfo_ = null;
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasTargetRoas() {
                return this.biddingStrategyTargetInfoCase_ == 3;
            }

            @Override
            public double getTargetRoas() {
                if (this.biddingStrategyTargetInfoCase_ == 3) {
                    return (Double)this.biddingStrategyTargetInfo_;
                }
                return 0.0;
            }

            public Builder setTargetRoas(double value) {
                this.biddingStrategyTargetInfoCase_ = 3;
                this.biddingStrategyTargetInfo_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearTargetRoas() {
                if (this.biddingStrategyTargetInfoCase_ == 3) {
                    this.biddingStrategyTargetInfoCase_ = 0;
                    this.biddingStrategyTargetInfo_ = null;
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasTargetImpressionShareInfo() {
                return this.biddingStrategyTargetInfoCase_ == 4;
            }

            @Override
            public TargetImpressionShareInfo getTargetImpressionShareInfo() {
                if (this.targetImpressionShareInfoBuilder_ == null) {
                    if (this.biddingStrategyTargetInfoCase_ == 4) {
                        return (TargetImpressionShareInfo)this.biddingStrategyTargetInfo_;
                    }
                    return TargetImpressionShareInfo.getDefaultInstance();
                }
                if (this.biddingStrategyTargetInfoCase_ == 4) {
                    return (TargetImpressionShareInfo)this.targetImpressionShareInfoBuilder_.getMessage();
                }
                return TargetImpressionShareInfo.getDefaultInstance();
            }

            public Builder setTargetImpressionShareInfo(TargetImpressionShareInfo value) {
                if (this.targetImpressionShareInfoBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.biddingStrategyTargetInfo_ = value;
                    this.onChanged();
                } else {
                    this.targetImpressionShareInfoBuilder_.setMessage((AbstractMessage)value);
                }
                this.biddingStrategyTargetInfoCase_ = 4;
                return this;
            }

            public Builder setTargetImpressionShareInfo(TargetImpressionShareInfo.Builder builderForValue) {
                if (this.targetImpressionShareInfoBuilder_ == null) {
                    this.biddingStrategyTargetInfo_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.targetImpressionShareInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.biddingStrategyTargetInfoCase_ = 4;
                return this;
            }

            public Builder mergeTargetImpressionShareInfo(TargetImpressionShareInfo value) {
                if (this.targetImpressionShareInfoBuilder_ == null) {
                    this.biddingStrategyTargetInfo_ = this.biddingStrategyTargetInfoCase_ == 4 && this.biddingStrategyTargetInfo_ != TargetImpressionShareInfo.getDefaultInstance() ? TargetImpressionShareInfo.newBuilder((TargetImpressionShareInfo)this.biddingStrategyTargetInfo_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.biddingStrategyTargetInfoCase_ == 4) {
                    this.targetImpressionShareInfoBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.targetImpressionShareInfoBuilder_.setMessage((AbstractMessage)value);
                }
                this.biddingStrategyTargetInfoCase_ = 4;
                return this;
            }

            public Builder clearTargetImpressionShareInfo() {
                if (this.targetImpressionShareInfoBuilder_ == null) {
                    if (this.biddingStrategyTargetInfoCase_ == 4) {
                        this.biddingStrategyTargetInfoCase_ = 0;
                        this.biddingStrategyTargetInfo_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.biddingStrategyTargetInfoCase_ == 4) {
                        this.biddingStrategyTargetInfoCase_ = 0;
                        this.biddingStrategyTargetInfo_ = null;
                    }
                    this.targetImpressionShareInfoBuilder_.clear();
                }
                return this;
            }

            public TargetImpressionShareInfo.Builder getTargetImpressionShareInfoBuilder() {
                return (TargetImpressionShareInfo.Builder)this.getTargetImpressionShareInfoFieldBuilder().getBuilder();
            }

            @Override
            public TargetImpressionShareInfoOrBuilder getTargetImpressionShareInfoOrBuilder() {
                if (this.biddingStrategyTargetInfoCase_ == 4 && this.targetImpressionShareInfoBuilder_ != null) {
                    return (TargetImpressionShareInfoOrBuilder)this.targetImpressionShareInfoBuilder_.getMessageOrBuilder();
                }
                if (this.biddingStrategyTargetInfoCase_ == 4) {
                    return (TargetImpressionShareInfo)this.biddingStrategyTargetInfo_;
                }
                return TargetImpressionShareInfo.getDefaultInstance();
            }

            private SingleFieldBuilderV3<TargetImpressionShareInfo, TargetImpressionShareInfo.Builder, TargetImpressionShareInfoOrBuilder> getTargetImpressionShareInfoFieldBuilder() {
                if (this.targetImpressionShareInfoBuilder_ == null) {
                    if (this.biddingStrategyTargetInfoCase_ != 4) {
                        this.biddingStrategyTargetInfo_ = TargetImpressionShareInfo.getDefaultInstance();
                    }
                    this.targetImpressionShareInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((TargetImpressionShareInfo)this.biddingStrategyTargetInfo_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.biddingStrategyTargetInfo_ = null;
                }
                this.biddingStrategyTargetInfoCase_ = 4;
                this.onChanged();
                return this.targetImpressionShareInfoBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum BiddingStrategyTargetInfoCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            TARGET_CPA_MICROS(2),
            TARGET_ROAS(3),
            TARGET_IMPRESSION_SHARE_INFO(4),
            BIDDINGSTRATEGYTARGETINFO_NOT_SET(0);

            private final int value;

            private BiddingStrategyTargetInfoCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static BiddingStrategyTargetInfoCase valueOf(int value) {
                return BiddingStrategyTargetInfoCase.forNumber(value);
            }

            public static BiddingStrategyTargetInfoCase forNumber(int value) {
                switch (value) {
                    case 2: {
                        return TARGET_CPA_MICROS;
                    }
                    case 3: {
                        return TARGET_ROAS;
                    }
                    case 4: {
                        return TARGET_IMPRESSION_SHARE_INFO;
                    }
                    case 0: {
                        return BIDDINGSTRATEGYTARGETINFO_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateRecommendationsRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private List<Integer> recommendationTypes_ = Collections.emptyList();
        private int advertisingChannelType_ = 0;
        private int campaignSitelinkCount_;
        private int conversionTrackingStatus_ = 0;
        private BiddingInfo biddingInfo_;
        private SingleFieldBuilderV3<BiddingInfo, BiddingInfo.Builder, BiddingInfoOrBuilder> biddingInfoBuilder_;
        private List<AdGroupInfo> adGroupInfo_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AdGroupInfo, AdGroupInfo.Builder, AdGroupInfoOrBuilder> adGroupInfoBuilder_;
        private SeedInfo seedInfo_;
        private SingleFieldBuilderV3<SeedInfo, SeedInfo.Builder, SeedInfoOrBuilder> seedInfoBuilder_;
        private BudgetInfo budgetInfo_;
        private SingleFieldBuilderV3<BudgetInfo, BudgetInfo.Builder, BudgetInfoOrBuilder> budgetInfoBuilder_;
        private int campaignImageAssetCount_;
        private int campaignCallAssetCount_;
        private LazyStringArrayList countryCodes_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList languageCodes_ = LazyStringArrayList.emptyList();
        private Internal.LongList positiveLocationsIds_ = GenerateRecommendationsRequest.access$7600();
        private Internal.LongList negativeLocationsIds_ = GenerateRecommendationsRequest.access$7900();
        private List<AssetGroupInfo> assetGroupInfo_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AssetGroupInfo, AssetGroupInfo.Builder, AssetGroupInfoOrBuilder> assetGroupInfoBuilder_;
        private boolean targetPartnerSearchNetwork_;
        private boolean targetContentNetwork_;
        private long merchantCenterAccountId_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateRecommendationsRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getBiddingInfoFieldBuilder();
                this.getAdGroupInfoFieldBuilder();
                this.getSeedInfoFieldBuilder();
                this.getBudgetInfoFieldBuilder();
                this.getAssetGroupInfoFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.recommendationTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.advertisingChannelType_ = 0;
            this.campaignSitelinkCount_ = 0;
            this.conversionTrackingStatus_ = 0;
            this.biddingInfo_ = null;
            if (this.biddingInfoBuilder_ != null) {
                this.biddingInfoBuilder_.dispose();
                this.biddingInfoBuilder_ = null;
            }
            if (this.adGroupInfoBuilder_ == null) {
                this.adGroupInfo_ = Collections.emptyList();
            } else {
                this.adGroupInfo_ = null;
                this.adGroupInfoBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.seedInfo_ = null;
            if (this.seedInfoBuilder_ != null) {
                this.seedInfoBuilder_.dispose();
                this.seedInfoBuilder_ = null;
            }
            this.budgetInfo_ = null;
            if (this.budgetInfoBuilder_ != null) {
                this.budgetInfoBuilder_.dispose();
                this.budgetInfoBuilder_ = null;
            }
            this.campaignImageAssetCount_ = 0;
            this.campaignCallAssetCount_ = 0;
            this.countryCodes_ = LazyStringArrayList.emptyList();
            this.languageCodes_ = LazyStringArrayList.emptyList();
            this.positiveLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
            this.negativeLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
            if (this.assetGroupInfoBuilder_ == null) {
                this.assetGroupInfo_ = Collections.emptyList();
            } else {
                this.assetGroupInfo_ = null;
                this.assetGroupInfoBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFF7FFF;
            this.targetPartnerSearchNetwork_ = false;
            this.targetContentNetwork_ = false;
            this.merchantCenterAccountId_ = 0L;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_descriptor;
        }

        public GenerateRecommendationsRequest getDefaultInstanceForType() {
            return GenerateRecommendationsRequest.getDefaultInstance();
        }

        public GenerateRecommendationsRequest build() {
            GenerateRecommendationsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateRecommendationsRequest buildPartial() {
            GenerateRecommendationsRequest result = new GenerateRecommendationsRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateRecommendationsRequest result) {
            if ((this.bitField0_ & 2) != 0) {
                this.recommendationTypes_ = Collections.unmodifiableList(this.recommendationTypes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.recommendationTypes_ = this.recommendationTypes_;
            if (this.adGroupInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.adGroupInfo_ = Collections.unmodifiableList(this.adGroupInfo_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.adGroupInfo_ = this.adGroupInfo_;
            } else {
                result.adGroupInfo_ = this.adGroupInfoBuilder_.build();
            }
            if (this.assetGroupInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x8000) != 0) {
                    this.assetGroupInfo_ = Collections.unmodifiableList(this.assetGroupInfo_);
                    this.bitField0_ &= 0xFFFF7FFF;
                }
                result.assetGroupInfo_ = this.assetGroupInfo_;
            } else {
                result.assetGroupInfo_ = this.assetGroupInfoBuilder_.build();
            }
        }

        private void buildPartial0(GenerateRecommendationsRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.advertisingChannelType_ = this.advertisingChannelType_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.campaignSitelinkCount_ = this.campaignSitelinkCount_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.conversionTrackingStatus_ = this.conversionTrackingStatus_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.biddingInfo_ = this.biddingInfoBuilder_ == null ? this.biddingInfo_ : (BiddingInfo)this.biddingInfoBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.seedInfo_ = this.seedInfoBuilder_ == null ? this.seedInfo_ : (SeedInfo)this.seedInfoBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.budgetInfo_ = this.budgetInfoBuilder_ == null ? this.budgetInfo_ : (BudgetInfo)this.budgetInfoBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.campaignImageAssetCount_ = this.campaignImageAssetCount_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.campaignCallAssetCount_ = this.campaignCallAssetCount_;
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                this.countryCodes_.makeImmutable();
                result.countryCodes_ = this.countryCodes_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                this.languageCodes_.makeImmutable();
                result.languageCodes_ = this.languageCodes_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                this.positiveLocationsIds_.makeImmutable();
                result.positiveLocationsIds_ = this.positiveLocationsIds_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                this.negativeLocationsIds_.makeImmutable();
                result.negativeLocationsIds_ = this.negativeLocationsIds_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.targetPartnerSearchNetwork_ = this.targetPartnerSearchNetwork_;
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.targetContentNetwork_ = this.targetContentNetwork_;
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.merchantCenterAccountId_ = this.merchantCenterAccountId_;
                to_bitField0_ |= 0x200;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateRecommendationsRequest) {
                return this.mergeFrom((GenerateRecommendationsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateRecommendationsRequest other) {
            if (other == GenerateRecommendationsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.recommendationTypes_.isEmpty()) {
                if (this.recommendationTypes_.isEmpty()) {
                    this.recommendationTypes_ = other.recommendationTypes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureRecommendationTypesIsMutable();
                    this.recommendationTypes_.addAll(other.recommendationTypes_);
                }
                this.onChanged();
            }
            if (other.advertisingChannelType_ != 0) {
                this.setAdvertisingChannelTypeValue(other.getAdvertisingChannelTypeValue());
            }
            if (other.hasCampaignSitelinkCount()) {
                this.setCampaignSitelinkCount(other.getCampaignSitelinkCount());
            }
            if (other.hasConversionTrackingStatus()) {
                this.setConversionTrackingStatus(other.getConversionTrackingStatus());
            }
            if (other.hasBiddingInfo()) {
                this.mergeBiddingInfo(other.getBiddingInfo());
            }
            if (this.adGroupInfoBuilder_ == null) {
                if (!other.adGroupInfo_.isEmpty()) {
                    if (this.adGroupInfo_.isEmpty()) {
                        this.adGroupInfo_ = other.adGroupInfo_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureAdGroupInfoIsMutable();
                        this.adGroupInfo_.addAll(other.adGroupInfo_);
                    }
                    this.onChanged();
                }
            } else if (!other.adGroupInfo_.isEmpty()) {
                if (this.adGroupInfoBuilder_.isEmpty()) {
                    this.adGroupInfoBuilder_.dispose();
                    this.adGroupInfoBuilder_ = null;
                    this.adGroupInfo_ = other.adGroupInfo_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.adGroupInfoBuilder_ = alwaysUseFieldBuilders ? this.getAdGroupInfoFieldBuilder() : null;
                } else {
                    this.adGroupInfoBuilder_.addAllMessages((Iterable)other.adGroupInfo_);
                }
            }
            if (other.hasSeedInfo()) {
                this.mergeSeedInfo(other.getSeedInfo());
            }
            if (other.hasBudgetInfo()) {
                this.mergeBudgetInfo(other.getBudgetInfo());
            }
            if (other.hasCampaignImageAssetCount()) {
                this.setCampaignImageAssetCount(other.getCampaignImageAssetCount());
            }
            if (other.hasCampaignCallAssetCount()) {
                this.setCampaignCallAssetCount(other.getCampaignCallAssetCount());
            }
            if (!other.countryCodes_.isEmpty()) {
                if (this.countryCodes_.isEmpty()) {
                    this.countryCodes_ = other.countryCodes_;
                    this.bitField0_ |= 0x800;
                } else {
                    this.ensureCountryCodesIsMutable();
                    this.countryCodes_.addAll((Collection)other.countryCodes_);
                }
                this.onChanged();
            }
            if (!other.languageCodes_.isEmpty()) {
                if (this.languageCodes_.isEmpty()) {
                    this.languageCodes_ = other.languageCodes_;
                    this.bitField0_ |= 0x1000;
                } else {
                    this.ensureLanguageCodesIsMutable();
                    this.languageCodes_.addAll((Collection)other.languageCodes_);
                }
                this.onChanged();
            }
            if (!other.positiveLocationsIds_.isEmpty()) {
                if (this.positiveLocationsIds_.isEmpty()) {
                    this.positiveLocationsIds_ = other.positiveLocationsIds_;
                    this.positiveLocationsIds_.makeImmutable();
                    this.bitField0_ |= 0x2000;
                } else {
                    this.ensurePositiveLocationsIdsIsMutable();
                    this.positiveLocationsIds_.addAll((Collection)other.positiveLocationsIds_);
                }
                this.onChanged();
            }
            if (!other.negativeLocationsIds_.isEmpty()) {
                if (this.negativeLocationsIds_.isEmpty()) {
                    this.negativeLocationsIds_ = other.negativeLocationsIds_;
                    this.negativeLocationsIds_.makeImmutable();
                    this.bitField0_ |= 0x4000;
                } else {
                    this.ensureNegativeLocationsIdsIsMutable();
                    this.negativeLocationsIds_.addAll((Collection)other.negativeLocationsIds_);
                }
                this.onChanged();
            }
            if (this.assetGroupInfoBuilder_ == null) {
                if (!other.assetGroupInfo_.isEmpty()) {
                    if (this.assetGroupInfo_.isEmpty()) {
                        this.assetGroupInfo_ = other.assetGroupInfo_;
                        this.bitField0_ &= 0xFFFF7FFF;
                    } else {
                        this.ensureAssetGroupInfoIsMutable();
                        this.assetGroupInfo_.addAll(other.assetGroupInfo_);
                    }
                    this.onChanged();
                }
            } else if (!other.assetGroupInfo_.isEmpty()) {
                if (this.assetGroupInfoBuilder_.isEmpty()) {
                    this.assetGroupInfoBuilder_.dispose();
                    this.assetGroupInfoBuilder_ = null;
                    this.assetGroupInfo_ = other.assetGroupInfo_;
                    this.bitField0_ &= 0xFFFF7FFF;
                    this.assetGroupInfoBuilder_ = alwaysUseFieldBuilders ? this.getAssetGroupInfoFieldBuilder() : null;
                } else {
                    this.assetGroupInfoBuilder_.addAllMessages((Iterable)other.assetGroupInfo_);
                }
            }
            if (other.hasTargetPartnerSearchNetwork()) {
                this.setTargetPartnerSearchNetwork(other.getTargetPartnerSearchNetwork());
            }
            if (other.hasTargetContentNetwork()) {
                this.setTargetContentNetwork(other.getTargetContentNetwork());
            }
            if (other.hasMerchantCenterAccountId()) {
                this.setMerchantCenterAccountId(other.getMerchantCenterAccountId());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block30: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block30;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block30;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureRecommendationTypesIsMutable();
                            this.recommendationTypes_.add(tmpRaw);
                            continue block30;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureRecommendationTypesIsMutable();
                                this.recommendationTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block30;
                        }
                        case 24: {
                            this.advertisingChannelType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block30;
                        }
                        case 32: {
                            this.campaignSitelinkCount_ = input.readInt32();
                            this.bitField0_ |= 8;
                            continue block30;
                        }
                        case 40: {
                            this.conversionTrackingStatus_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block30;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getBiddingInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block30;
                        }
                        case 58: {
                            AdGroupInfo m = (AdGroupInfo)input.readMessage(AdGroupInfo.parser(), extensionRegistry);
                            if (this.adGroupInfoBuilder_ == null) {
                                this.ensureAdGroupInfoIsMutable();
                                this.adGroupInfo_.add(m);
                                continue block30;
                            }
                            this.adGroupInfoBuilder_.addMessage((AbstractMessage)m);
                            continue block30;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getSeedInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block30;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getBudgetInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block30;
                        }
                        case 80: {
                            this.campaignImageAssetCount_ = input.readInt32();
                            this.bitField0_ |= 0x200;
                            continue block30;
                        }
                        case 88: {
                            this.campaignCallAssetCount_ = input.readInt32();
                            this.bitField0_ |= 0x400;
                            continue block30;
                        }
                        case 106: {
                            String s = input.readStringRequireUtf8();
                            this.ensureCountryCodesIsMutable();
                            this.countryCodes_.add(s);
                            continue block30;
                        }
                        case 114: {
                            String s = input.readStringRequireUtf8();
                            this.ensureLanguageCodesIsMutable();
                            this.languageCodes_.add(s);
                            continue block30;
                        }
                        case 120: {
                            long v = input.readInt64();
                            this.ensurePositiveLocationsIdsIsMutable();
                            this.positiveLocationsIds_.addLong(v);
                            continue block30;
                        }
                        case 122: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensurePositiveLocationsIdsIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.positiveLocationsIds_.addLong(input.readInt64());
                            }
                            input.popLimit(limit);
                            continue block30;
                        }
                        case 128: {
                            long v = input.readInt64();
                            this.ensureNegativeLocationsIdsIsMutable();
                            this.negativeLocationsIds_.addLong(v);
                            continue block30;
                        }
                        case 130: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensureNegativeLocationsIdsIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.negativeLocationsIds_.addLong(input.readInt64());
                            }
                            input.popLimit(limit);
                            continue block30;
                        }
                        case 138: {
                            AssetGroupInfo m = (AssetGroupInfo)input.readMessage(AssetGroupInfo.parser(), extensionRegistry);
                            if (this.assetGroupInfoBuilder_ == null) {
                                this.ensureAssetGroupInfoIsMutable();
                                this.assetGroupInfo_.add(m);
                                continue block30;
                            }
                            this.assetGroupInfoBuilder_.addMessage((AbstractMessage)m);
                            continue block30;
                        }
                        case 144: {
                            this.targetPartnerSearchNetwork_ = input.readBool();
                            this.bitField0_ |= 0x10000;
                            continue block30;
                        }
                        case 152: {
                            this.targetContentNetwork_ = input.readBool();
                            this.bitField0_ |= 0x20000;
                            continue block30;
                        }
                        case 160: {
                            this.merchantCenterAccountId_ = input.readInt64();
                            this.bitField0_ |= 0x40000;
                            continue block30;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateRecommendationsRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateRecommendationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureRecommendationTypesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.recommendationTypes_ = new ArrayList<Integer>(this.recommendationTypes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<RecommendationTypeEnum.RecommendationType> getRecommendationTypesList() {
            return new Internal.ListAdapter(this.recommendationTypes_, recommendationTypes_converter_);
        }

        @Override
        public int getRecommendationTypesCount() {
            return this.recommendationTypes_.size();
        }

        @Override
        public RecommendationTypeEnum.RecommendationType getRecommendationTypes(int index) {
            return (RecommendationTypeEnum.RecommendationType)((Object)recommendationTypes_converter_.convert((Object)this.recommendationTypes_.get(index)));
        }

        public Builder setRecommendationTypes(int index, RecommendationTypeEnum.RecommendationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addRecommendationTypes(RecommendationTypeEnum.RecommendationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllRecommendationTypes(Iterable<? extends RecommendationTypeEnum.RecommendationType> values) {
            this.ensureRecommendationTypesIsMutable();
            for (RecommendationTypeEnum.RecommendationType recommendationType : values) {
                this.recommendationTypes_.add(recommendationType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearRecommendationTypes() {
            this.recommendationTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getRecommendationTypesValueList() {
            return Collections.unmodifiableList(this.recommendationTypes_);
        }

        @Override
        public int getRecommendationTypesValue(int index) {
            return this.recommendationTypes_.get(index);
        }

        public Builder setRecommendationTypesValue(int index, int value) {
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRecommendationTypesValue(int value) {
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRecommendationTypesValue(Iterable<Integer> values) {
            this.ensureRecommendationTypesIsMutable();
            for (int value : values) {
                this.recommendationTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public int getAdvertisingChannelTypeValue() {
            return this.advertisingChannelType_;
        }

        public Builder setAdvertisingChannelTypeValue(int value) {
            this.advertisingChannelType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
            AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber(this.advertisingChannelType_);
            return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
        }

        public Builder setAdvertisingChannelType(AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.advertisingChannelType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisingChannelType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.advertisingChannelType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCampaignSitelinkCount() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public int getCampaignSitelinkCount() {
            return this.campaignSitelinkCount_;
        }

        public Builder setCampaignSitelinkCount(int value) {
            this.campaignSitelinkCount_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearCampaignSitelinkCount() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.campaignSitelinkCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasConversionTrackingStatus() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public int getConversionTrackingStatusValue() {
            return this.conversionTrackingStatus_;
        }

        public Builder setConversionTrackingStatusValue(int value) {
            this.conversionTrackingStatus_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ConversionTrackingStatusEnum.ConversionTrackingStatus getConversionTrackingStatus() {
            ConversionTrackingStatusEnum.ConversionTrackingStatus result = ConversionTrackingStatusEnum.ConversionTrackingStatus.forNumber(this.conversionTrackingStatus_);
            return result == null ? ConversionTrackingStatusEnum.ConversionTrackingStatus.UNRECOGNIZED : result;
        }

        public Builder setConversionTrackingStatus(ConversionTrackingStatusEnum.ConversionTrackingStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.conversionTrackingStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConversionTrackingStatus() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.conversionTrackingStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBiddingInfo() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public BiddingInfo getBiddingInfo() {
            if (this.biddingInfoBuilder_ == null) {
                return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
            }
            return (BiddingInfo)this.biddingInfoBuilder_.getMessage();
        }

        public Builder setBiddingInfo(BiddingInfo value) {
            if (this.biddingInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.biddingInfo_ = value;
            } else {
                this.biddingInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setBiddingInfo(BiddingInfo.Builder builderForValue) {
            if (this.biddingInfoBuilder_ == null) {
                this.biddingInfo_ = builderForValue.build();
            } else {
                this.biddingInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeBiddingInfo(BiddingInfo value) {
            if (this.biddingInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.biddingInfo_ != null && this.biddingInfo_ != BiddingInfo.getDefaultInstance()) {
                    this.getBiddingInfoBuilder().mergeFrom(value);
                } else {
                    this.biddingInfo_ = value;
                }
            } else {
                this.biddingInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.biddingInfo_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearBiddingInfo() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.biddingInfo_ = null;
            if (this.biddingInfoBuilder_ != null) {
                this.biddingInfoBuilder_.dispose();
                this.biddingInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public BiddingInfo.Builder getBiddingInfoBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (BiddingInfo.Builder)this.getBiddingInfoFieldBuilder().getBuilder();
        }

        @Override
        public BiddingInfoOrBuilder getBiddingInfoOrBuilder() {
            if (this.biddingInfoBuilder_ != null) {
                return (BiddingInfoOrBuilder)this.biddingInfoBuilder_.getMessageOrBuilder();
            }
            return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
        }

        private SingleFieldBuilderV3<BiddingInfo, BiddingInfo.Builder, BiddingInfoOrBuilder> getBiddingInfoFieldBuilder() {
            if (this.biddingInfoBuilder_ == null) {
                this.biddingInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBiddingInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.biddingInfo_ = null;
            }
            return this.biddingInfoBuilder_;
        }

        private void ensureAdGroupInfoIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.adGroupInfo_ = new ArrayList<AdGroupInfo>(this.adGroupInfo_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<AdGroupInfo> getAdGroupInfoList() {
            if (this.adGroupInfoBuilder_ == null) {
                return Collections.unmodifiableList(this.adGroupInfo_);
            }
            return this.adGroupInfoBuilder_.getMessageList();
        }

        @Override
        public int getAdGroupInfoCount() {
            if (this.adGroupInfoBuilder_ == null) {
                return this.adGroupInfo_.size();
            }
            return this.adGroupInfoBuilder_.getCount();
        }

        @Override
        public AdGroupInfo getAdGroupInfo(int index) {
            if (this.adGroupInfoBuilder_ == null) {
                return this.adGroupInfo_.get(index);
            }
            return (AdGroupInfo)this.adGroupInfoBuilder_.getMessage(index);
        }

        public Builder setAdGroupInfo(int index, AdGroupInfo value) {
            if (this.adGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.set(index, value);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdGroupInfo(int index, AdGroupInfo.Builder builderForValue) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdGroupInfo(AdGroupInfo value) {
            if (this.adGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(value);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdGroupInfo(int index, AdGroupInfo value) {
            if (this.adGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(index, value);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdGroupInfo(AdGroupInfo.Builder builderForValue) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdGroupInfo(int index, AdGroupInfo.Builder builderForValue) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdGroupInfo(Iterable<? extends AdGroupInfo> values) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.adGroupInfo_);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdGroupInfo() {
            if (this.adGroupInfoBuilder_ == null) {
                this.adGroupInfo_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdGroupInfo(int index) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.remove(index);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.remove(index);
            }
            return this;
        }

        public AdGroupInfo.Builder getAdGroupInfoBuilder(int index) {
            return (AdGroupInfo.Builder)this.getAdGroupInfoFieldBuilder().getBuilder(index);
        }

        @Override
        public AdGroupInfoOrBuilder getAdGroupInfoOrBuilder(int index) {
            if (this.adGroupInfoBuilder_ == null) {
                return this.adGroupInfo_.get(index);
            }
            return (AdGroupInfoOrBuilder)this.adGroupInfoBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AdGroupInfoOrBuilder> getAdGroupInfoOrBuilderList() {
            if (this.adGroupInfoBuilder_ != null) {
                return this.adGroupInfoBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.adGroupInfo_);
        }

        public AdGroupInfo.Builder addAdGroupInfoBuilder() {
            return (AdGroupInfo.Builder)this.getAdGroupInfoFieldBuilder().addBuilder((AbstractMessage)AdGroupInfo.getDefaultInstance());
        }

        public AdGroupInfo.Builder addAdGroupInfoBuilder(int index) {
            return (AdGroupInfo.Builder)this.getAdGroupInfoFieldBuilder().addBuilder(index, (AbstractMessage)AdGroupInfo.getDefaultInstance());
        }

        public List<AdGroupInfo.Builder> getAdGroupInfoBuilderList() {
            return this.getAdGroupInfoFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AdGroupInfo, AdGroupInfo.Builder, AdGroupInfoOrBuilder> getAdGroupInfoFieldBuilder() {
            if (this.adGroupInfoBuilder_ == null) {
                this.adGroupInfoBuilder_ = new RepeatedFieldBuilderV3(this.adGroupInfo_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.adGroupInfo_ = null;
            }
            return this.adGroupInfoBuilder_;
        }

        @Override
        public boolean hasSeedInfo() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public SeedInfo getSeedInfo() {
            if (this.seedInfoBuilder_ == null) {
                return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
            }
            return (SeedInfo)this.seedInfoBuilder_.getMessage();
        }

        public Builder setSeedInfo(SeedInfo value) {
            if (this.seedInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.seedInfo_ = value;
            } else {
                this.seedInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setSeedInfo(SeedInfo.Builder builderForValue) {
            if (this.seedInfoBuilder_ == null) {
                this.seedInfo_ = builderForValue.build();
            } else {
                this.seedInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeSeedInfo(SeedInfo value) {
            if (this.seedInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.seedInfo_ != null && this.seedInfo_ != SeedInfo.getDefaultInstance()) {
                    this.getSeedInfoBuilder().mergeFrom(value);
                } else {
                    this.seedInfo_ = value;
                }
            } else {
                this.seedInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.seedInfo_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSeedInfo() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.seedInfo_ = null;
            if (this.seedInfoBuilder_ != null) {
                this.seedInfoBuilder_.dispose();
                this.seedInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public SeedInfo.Builder getSeedInfoBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (SeedInfo.Builder)this.getSeedInfoFieldBuilder().getBuilder();
        }

        @Override
        public SeedInfoOrBuilder getSeedInfoOrBuilder() {
            if (this.seedInfoBuilder_ != null) {
                return (SeedInfoOrBuilder)this.seedInfoBuilder_.getMessageOrBuilder();
            }
            return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
        }

        private SingleFieldBuilderV3<SeedInfo, SeedInfo.Builder, SeedInfoOrBuilder> getSeedInfoFieldBuilder() {
            if (this.seedInfoBuilder_ == null) {
                this.seedInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSeedInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.seedInfo_ = null;
            }
            return this.seedInfoBuilder_;
        }

        @Override
        public boolean hasBudgetInfo() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public BudgetInfo getBudgetInfo() {
            if (this.budgetInfoBuilder_ == null) {
                return this.budgetInfo_ == null ? BudgetInfo.getDefaultInstance() : this.budgetInfo_;
            }
            return (BudgetInfo)this.budgetInfoBuilder_.getMessage();
        }

        public Builder setBudgetInfo(BudgetInfo value) {
            if (this.budgetInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.budgetInfo_ = value;
            } else {
                this.budgetInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setBudgetInfo(BudgetInfo.Builder builderForValue) {
            if (this.budgetInfoBuilder_ == null) {
                this.budgetInfo_ = builderForValue.build();
            } else {
                this.budgetInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeBudgetInfo(BudgetInfo value) {
            if (this.budgetInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.budgetInfo_ != null && this.budgetInfo_ != BudgetInfo.getDefaultInstance()) {
                    this.getBudgetInfoBuilder().mergeFrom(value);
                } else {
                    this.budgetInfo_ = value;
                }
            } else {
                this.budgetInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.budgetInfo_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearBudgetInfo() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.budgetInfo_ = null;
            if (this.budgetInfoBuilder_ != null) {
                this.budgetInfoBuilder_.dispose();
                this.budgetInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public BudgetInfo.Builder getBudgetInfoBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (BudgetInfo.Builder)this.getBudgetInfoFieldBuilder().getBuilder();
        }

        @Override
        public BudgetInfoOrBuilder getBudgetInfoOrBuilder() {
            if (this.budgetInfoBuilder_ != null) {
                return (BudgetInfoOrBuilder)this.budgetInfoBuilder_.getMessageOrBuilder();
            }
            return this.budgetInfo_ == null ? BudgetInfo.getDefaultInstance() : this.budgetInfo_;
        }

        private SingleFieldBuilderV3<BudgetInfo, BudgetInfo.Builder, BudgetInfoOrBuilder> getBudgetInfoFieldBuilder() {
            if (this.budgetInfoBuilder_ == null) {
                this.budgetInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBudgetInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.budgetInfo_ = null;
            }
            return this.budgetInfoBuilder_;
        }

        @Override
        public boolean hasCampaignImageAssetCount() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public int getCampaignImageAssetCount() {
            return this.campaignImageAssetCount_;
        }

        public Builder setCampaignImageAssetCount(int value) {
            this.campaignImageAssetCount_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearCampaignImageAssetCount() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.campaignImageAssetCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCampaignCallAssetCount() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public int getCampaignCallAssetCount() {
            return this.campaignCallAssetCount_;
        }

        public Builder setCampaignCallAssetCount(int value) {
            this.campaignCallAssetCount_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearCampaignCallAssetCount() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.campaignCallAssetCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureCountryCodesIsMutable() {
            if (!this.countryCodes_.isModifiable()) {
                this.countryCodes_ = new LazyStringArrayList((LazyStringList)this.countryCodes_);
            }
            this.bitField0_ |= 0x800;
        }

        public ProtocolStringList getCountryCodesList() {
            this.countryCodes_.makeImmutable();
            return this.countryCodes_;
        }

        @Override
        public int getCountryCodesCount() {
            return this.countryCodes_.size();
        }

        @Override
        public String getCountryCodes(int index) {
            return this.countryCodes_.get(index);
        }

        @Override
        public ByteString getCountryCodesBytes(int index) {
            return this.countryCodes_.getByteString(index);
        }

        public Builder setCountryCodes(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCountryCodesIsMutable();
            this.countryCodes_.set(index, value);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder addCountryCodes(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCountryCodesIsMutable();
            this.countryCodes_.add(value);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder addAllCountryCodes(Iterable<String> values) {
            this.ensureCountryCodesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.countryCodes_);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearCountryCodes() {
            this.countryCodes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder addCountryCodesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateRecommendationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureCountryCodesIsMutable();
            this.countryCodes_.add(value);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        private void ensureLanguageCodesIsMutable() {
            if (!this.languageCodes_.isModifiable()) {
                this.languageCodes_ = new LazyStringArrayList((LazyStringList)this.languageCodes_);
            }
            this.bitField0_ |= 0x1000;
        }

        public ProtocolStringList getLanguageCodesList() {
            this.languageCodes_.makeImmutable();
            return this.languageCodes_;
        }

        @Override
        public int getLanguageCodesCount() {
            return this.languageCodes_.size();
        }

        @Override
        public String getLanguageCodes(int index) {
            return this.languageCodes_.get(index);
        }

        @Override
        public ByteString getLanguageCodesBytes(int index) {
            return this.languageCodes_.getByteString(index);
        }

        public Builder setLanguageCodes(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLanguageCodesIsMutable();
            this.languageCodes_.set(index, value);
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder addLanguageCodes(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLanguageCodesIsMutable();
            this.languageCodes_.add(value);
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder addAllLanguageCodes(Iterable<String> values) {
            this.ensureLanguageCodesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.languageCodes_);
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearLanguageCodes() {
            this.languageCodes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder addLanguageCodesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateRecommendationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureLanguageCodesIsMutable();
            this.languageCodes_.add(value);
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        private void ensurePositiveLocationsIdsIsMutable() {
            if (!this.positiveLocationsIds_.isModifiable()) {
                this.positiveLocationsIds_ = (Internal.LongList)GenerateRecommendationsRequest.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.positiveLocationsIds_));
            }
            this.bitField0_ |= 0x2000;
        }

        @Override
        public List<Long> getPositiveLocationsIdsList() {
            this.positiveLocationsIds_.makeImmutable();
            return this.positiveLocationsIds_;
        }

        @Override
        public int getPositiveLocationsIdsCount() {
            return this.positiveLocationsIds_.size();
        }

        @Override
        public long getPositiveLocationsIds(int index) {
            return this.positiveLocationsIds_.getLong(index);
        }

        public Builder setPositiveLocationsIds(int index, long value) {
            this.ensurePositiveLocationsIdsIsMutable();
            this.positiveLocationsIds_.setLong(index, value);
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder addPositiveLocationsIds(long value) {
            this.ensurePositiveLocationsIdsIsMutable();
            this.positiveLocationsIds_.addLong(value);
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder addAllPositiveLocationsIds(Iterable<? extends Long> values) {
            this.ensurePositiveLocationsIdsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.positiveLocationsIds_);
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearPositiveLocationsIds() {
            this.positiveLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        private void ensureNegativeLocationsIdsIsMutable() {
            if (!this.negativeLocationsIds_.isModifiable()) {
                this.negativeLocationsIds_ = (Internal.LongList)GenerateRecommendationsRequest.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.negativeLocationsIds_));
            }
            this.bitField0_ |= 0x4000;
        }

        @Override
        public List<Long> getNegativeLocationsIdsList() {
            this.negativeLocationsIds_.makeImmutable();
            return this.negativeLocationsIds_;
        }

        @Override
        public int getNegativeLocationsIdsCount() {
            return this.negativeLocationsIds_.size();
        }

        @Override
        public long getNegativeLocationsIds(int index) {
            return this.negativeLocationsIds_.getLong(index);
        }

        public Builder setNegativeLocationsIds(int index, long value) {
            this.ensureNegativeLocationsIdsIsMutable();
            this.negativeLocationsIds_.setLong(index, value);
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder addNegativeLocationsIds(long value) {
            this.ensureNegativeLocationsIdsIsMutable();
            this.negativeLocationsIds_.addLong(value);
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder addAllNegativeLocationsIds(Iterable<? extends Long> values) {
            this.ensureNegativeLocationsIdsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.negativeLocationsIds_);
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearNegativeLocationsIds() {
            this.negativeLocationsIds_ = GenerateRecommendationsRequest.emptyLongList();
            this.bitField0_ &= 0xFFFFBFFF;
            this.onChanged();
            return this;
        }

        private void ensureAssetGroupInfoIsMutable() {
            if ((this.bitField0_ & 0x8000) == 0) {
                this.assetGroupInfo_ = new ArrayList<AssetGroupInfo>(this.assetGroupInfo_);
                this.bitField0_ |= 0x8000;
            }
        }

        @Override
        public List<AssetGroupInfo> getAssetGroupInfoList() {
            if (this.assetGroupInfoBuilder_ == null) {
                return Collections.unmodifiableList(this.assetGroupInfo_);
            }
            return this.assetGroupInfoBuilder_.getMessageList();
        }

        @Override
        public int getAssetGroupInfoCount() {
            if (this.assetGroupInfoBuilder_ == null) {
                return this.assetGroupInfo_.size();
            }
            return this.assetGroupInfoBuilder_.getCount();
        }

        @Override
        public AssetGroupInfo getAssetGroupInfo(int index) {
            if (this.assetGroupInfoBuilder_ == null) {
                return this.assetGroupInfo_.get(index);
            }
            return (AssetGroupInfo)this.assetGroupInfoBuilder_.getMessage(index);
        }

        public Builder setAssetGroupInfo(int index, AssetGroupInfo value) {
            if (this.assetGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.set(index, value);
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAssetGroupInfo(int index, AssetGroupInfo.Builder builderForValue) {
            if (this.assetGroupInfoBuilder_ == null) {
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAssetGroupInfo(AssetGroupInfo value) {
            if (this.assetGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.add(value);
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAssetGroupInfo(int index, AssetGroupInfo value) {
            if (this.assetGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.add(index, value);
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAssetGroupInfo(AssetGroupInfo.Builder builderForValue) {
            if (this.assetGroupInfoBuilder_ == null) {
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAssetGroupInfo(int index, AssetGroupInfo.Builder builderForValue) {
            if (this.assetGroupInfoBuilder_ == null) {
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAssetGroupInfo(Iterable<? extends AssetGroupInfo> values) {
            if (this.assetGroupInfoBuilder_ == null) {
                this.ensureAssetGroupInfoIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.assetGroupInfo_);
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAssetGroupInfo() {
            if (this.assetGroupInfoBuilder_ == null) {
                this.assetGroupInfo_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFF7FFF;
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.clear();
            }
            return this;
        }

        public Builder removeAssetGroupInfo(int index) {
            if (this.assetGroupInfoBuilder_ == null) {
                this.ensureAssetGroupInfoIsMutable();
                this.assetGroupInfo_.remove(index);
                this.onChanged();
            } else {
                this.assetGroupInfoBuilder_.remove(index);
            }
            return this;
        }

        public AssetGroupInfo.Builder getAssetGroupInfoBuilder(int index) {
            return (AssetGroupInfo.Builder)this.getAssetGroupInfoFieldBuilder().getBuilder(index);
        }

        @Override
        public AssetGroupInfoOrBuilder getAssetGroupInfoOrBuilder(int index) {
            if (this.assetGroupInfoBuilder_ == null) {
                return this.assetGroupInfo_.get(index);
            }
            return (AssetGroupInfoOrBuilder)this.assetGroupInfoBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AssetGroupInfoOrBuilder> getAssetGroupInfoOrBuilderList() {
            if (this.assetGroupInfoBuilder_ != null) {
                return this.assetGroupInfoBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.assetGroupInfo_);
        }

        public AssetGroupInfo.Builder addAssetGroupInfoBuilder() {
            return (AssetGroupInfo.Builder)this.getAssetGroupInfoFieldBuilder().addBuilder((AbstractMessage)AssetGroupInfo.getDefaultInstance());
        }

        public AssetGroupInfo.Builder addAssetGroupInfoBuilder(int index) {
            return (AssetGroupInfo.Builder)this.getAssetGroupInfoFieldBuilder().addBuilder(index, (AbstractMessage)AssetGroupInfo.getDefaultInstance());
        }

        public List<AssetGroupInfo.Builder> getAssetGroupInfoBuilderList() {
            return this.getAssetGroupInfoFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AssetGroupInfo, AssetGroupInfo.Builder, AssetGroupInfoOrBuilder> getAssetGroupInfoFieldBuilder() {
            if (this.assetGroupInfoBuilder_ == null) {
                this.assetGroupInfoBuilder_ = new RepeatedFieldBuilderV3(this.assetGroupInfo_, (this.bitField0_ & 0x8000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.assetGroupInfo_ = null;
            }
            return this.assetGroupInfoBuilder_;
        }

        @Override
        public boolean hasTargetPartnerSearchNetwork() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public boolean getTargetPartnerSearchNetwork() {
            return this.targetPartnerSearchNetwork_;
        }

        public Builder setTargetPartnerSearchNetwork(boolean value) {
            this.targetPartnerSearchNetwork_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearTargetPartnerSearchNetwork() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.targetPartnerSearchNetwork_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTargetContentNetwork() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public boolean getTargetContentNetwork() {
            return this.targetContentNetwork_;
        }

        public Builder setTargetContentNetwork(boolean value) {
            this.targetContentNetwork_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearTargetContentNetwork() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.targetContentNetwork_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMerchantCenterAccountId() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public long getMerchantCenterAccountId() {
            return this.merchantCenterAccountId_;
        }

        public Builder setMerchantCenterAccountId(long value) {
            this.merchantCenterAccountId_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearMerchantCenterAccountId() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.merchantCenterAccountId_ = 0L;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AdGroupInfo
    extends GeneratedMessageV3
    implements AdGroupInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int AD_GROUP_TYPE_FIELD_NUMBER = 1;
        private int adGroupType_ = 0;
        public static final int KEYWORDS_FIELD_NUMBER = 2;
        private List<KeywordInfo> keywords_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AdGroupInfo DEFAULT_INSTANCE = new AdGroupInfo();
        private static final Parser<AdGroupInfo> PARSER = new AbstractParser<AdGroupInfo>(){

            public AdGroupInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AdGroupInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AdGroupInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AdGroupInfo() {
            this.adGroupType_ = 0;
            this.keywords_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AdGroupInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AdGroupInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AdGroupInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupInfo.class, Builder.class);
        }

        @Override
        public boolean hasAdGroupType() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getAdGroupTypeValue() {
            return this.adGroupType_;
        }

        @Override
        public AdGroupTypeEnum.AdGroupType getAdGroupType() {
            AdGroupTypeEnum.AdGroupType result = AdGroupTypeEnum.AdGroupType.forNumber(this.adGroupType_);
            return result == null ? AdGroupTypeEnum.AdGroupType.UNRECOGNIZED : result;
        }

        @Override
        public List<KeywordInfo> getKeywordsList() {
            return this.keywords_;
        }

        @Override
        public List<? extends KeywordInfoOrBuilder> getKeywordsOrBuilderList() {
            return this.keywords_;
        }

        @Override
        public int getKeywordsCount() {
            return this.keywords_.size();
        }

        @Override
        public KeywordInfo getKeywords(int index) {
            return this.keywords_.get(index);
        }

        @Override
        public KeywordInfoOrBuilder getKeywordsOrBuilder(int index) {
            return this.keywords_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.adGroupType_);
            }
            for (int i = 0; i < this.keywords_.size(); ++i) {
                output.writeMessage(2, (MessageLite)this.keywords_.get(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.adGroupType_);
            }
            for (int i = 0; i < this.keywords_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.keywords_.get(i)));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AdGroupInfo)) {
                return super.equals(obj);
            }
            AdGroupInfo other = (AdGroupInfo)obj;
            if (this.hasAdGroupType() != other.hasAdGroupType()) {
                return false;
            }
            if (this.hasAdGroupType() && this.adGroupType_ != other.adGroupType_) {
                return false;
            }
            if (!this.getKeywordsList().equals(other.getKeywordsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AdGroupInfo.getDescriptor().hashCode();
            if (this.hasAdGroupType()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.adGroupType_;
            }
            if (this.getKeywordsCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getKeywordsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AdGroupInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data);
        }

        public static AdGroupInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AdGroupInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data);
        }

        public static AdGroupInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AdGroupInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data);
        }

        public static AdGroupInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AdGroupInfo parseFrom(InputStream input) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AdGroupInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AdGroupInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AdGroupInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AdGroupInfo parseFrom(CodedInputStream input) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AdGroupInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AdGroupInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AdGroupInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AdGroupInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AdGroupInfo> parser() {
            return PARSER;
        }

        public Parser<AdGroupInfo> getParserForType() {
            return PARSER;
        }

        public AdGroupInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AdGroupInfoOrBuilder {
            private int bitField0_;
            private int adGroupType_ = 0;
            private List<KeywordInfo> keywords_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<KeywordInfo, KeywordInfo.Builder, KeywordInfoOrBuilder> keywordsBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AdGroupInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AdGroupInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.adGroupType_ = 0;
                if (this.keywordsBuilder_ == null) {
                    this.keywords_ = Collections.emptyList();
                } else {
                    this.keywords_ = null;
                    this.keywordsBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFD;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AdGroupInfo_descriptor;
            }

            public AdGroupInfo getDefaultInstanceForType() {
                return AdGroupInfo.getDefaultInstance();
            }

            public AdGroupInfo build() {
                AdGroupInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AdGroupInfo buildPartial() {
                AdGroupInfo result = new AdGroupInfo(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(AdGroupInfo result) {
                if (this.keywordsBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0) {
                        this.keywords_ = Collections.unmodifiableList(this.keywords_);
                        this.bitField0_ &= 0xFFFFFFFD;
                    }
                    result.keywords_ = this.keywords_;
                } else {
                    result.keywords_ = this.keywordsBuilder_.build();
                }
            }

            private void buildPartial0(AdGroupInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.adGroupType_ = this.adGroupType_;
                    to_bitField0_ |= 1;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AdGroupInfo) {
                    return this.mergeFrom((AdGroupInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AdGroupInfo other) {
                if (other == AdGroupInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasAdGroupType()) {
                    this.setAdGroupType(other.getAdGroupType());
                }
                if (this.keywordsBuilder_ == null) {
                    if (!other.keywords_.isEmpty()) {
                        if (this.keywords_.isEmpty()) {
                            this.keywords_ = other.keywords_;
                            this.bitField0_ &= 0xFFFFFFFD;
                        } else {
                            this.ensureKeywordsIsMutable();
                            this.keywords_.addAll(other.keywords_);
                        }
                        this.onChanged();
                    }
                } else if (!other.keywords_.isEmpty()) {
                    if (this.keywordsBuilder_.isEmpty()) {
                        this.keywordsBuilder_.dispose();
                        this.keywordsBuilder_ = null;
                        this.keywords_ = other.keywords_;
                        this.bitField0_ &= 0xFFFFFFFD;
                        this.keywordsBuilder_ = alwaysUseFieldBuilders ? this.getKeywordsFieldBuilder() : null;
                    } else {
                        this.keywordsBuilder_.addAllMessages((Iterable)other.keywords_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.adGroupType_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                KeywordInfo m = (KeywordInfo)input.readMessage(KeywordInfo.parser(), extensionRegistry);
                                if (this.keywordsBuilder_ == null) {
                                    this.ensureKeywordsIsMutable();
                                    this.keywords_.add(m);
                                    continue block10;
                                }
                                this.keywordsBuilder_.addMessage((AbstractMessage)m);
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasAdGroupType() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getAdGroupTypeValue() {
                return this.adGroupType_;
            }

            public Builder setAdGroupTypeValue(int value) {
                this.adGroupType_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public AdGroupTypeEnum.AdGroupType getAdGroupType() {
                AdGroupTypeEnum.AdGroupType result = AdGroupTypeEnum.AdGroupType.forNumber(this.adGroupType_);
                return result == null ? AdGroupTypeEnum.AdGroupType.UNRECOGNIZED : result;
            }

            public Builder setAdGroupType(AdGroupTypeEnum.AdGroupType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.adGroupType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearAdGroupType() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.adGroupType_ = 0;
                this.onChanged();
                return this;
            }

            private void ensureKeywordsIsMutable() {
                if ((this.bitField0_ & 2) == 0) {
                    this.keywords_ = new ArrayList<KeywordInfo>(this.keywords_);
                    this.bitField0_ |= 2;
                }
            }

            @Override
            public List<KeywordInfo> getKeywordsList() {
                if (this.keywordsBuilder_ == null) {
                    return Collections.unmodifiableList(this.keywords_);
                }
                return this.keywordsBuilder_.getMessageList();
            }

            @Override
            public int getKeywordsCount() {
                if (this.keywordsBuilder_ == null) {
                    return this.keywords_.size();
                }
                return this.keywordsBuilder_.getCount();
            }

            @Override
            public KeywordInfo getKeywords(int index) {
                if (this.keywordsBuilder_ == null) {
                    return this.keywords_.get(index);
                }
                return (KeywordInfo)this.keywordsBuilder_.getMessage(index);
            }

            public Builder setKeywords(int index, KeywordInfo value) {
                if (this.keywordsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureKeywordsIsMutable();
                    this.keywords_.set(index, value);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setKeywords(int index, KeywordInfo.Builder builderForValue) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addKeywords(KeywordInfo value) {
                if (this.keywordsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(value);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addKeywords(int index, KeywordInfo value) {
                if (this.keywordsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(index, value);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addKeywords(KeywordInfo.Builder builderForValue) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addKeywords(int index, KeywordInfo.Builder builderForValue) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllKeywords(Iterable<? extends KeywordInfo> values) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.keywords_);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearKeywords() {
                if (this.keywordsBuilder_ == null) {
                    this.keywords_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.clear();
                }
                return this;
            }

            public Builder removeKeywords(int index) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.remove(index);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.remove(index);
                }
                return this;
            }

            public KeywordInfo.Builder getKeywordsBuilder(int index) {
                return (KeywordInfo.Builder)this.getKeywordsFieldBuilder().getBuilder(index);
            }

            @Override
            public KeywordInfoOrBuilder getKeywordsOrBuilder(int index) {
                if (this.keywordsBuilder_ == null) {
                    return this.keywords_.get(index);
                }
                return (KeywordInfoOrBuilder)this.keywordsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends KeywordInfoOrBuilder> getKeywordsOrBuilderList() {
                if (this.keywordsBuilder_ != null) {
                    return this.keywordsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.keywords_);
            }

            public KeywordInfo.Builder addKeywordsBuilder() {
                return (KeywordInfo.Builder)this.getKeywordsFieldBuilder().addBuilder((AbstractMessage)KeywordInfo.getDefaultInstance());
            }

            public KeywordInfo.Builder addKeywordsBuilder(int index) {
                return (KeywordInfo.Builder)this.getKeywordsFieldBuilder().addBuilder(index, (AbstractMessage)KeywordInfo.getDefaultInstance());
            }

            public List<KeywordInfo.Builder> getKeywordsBuilderList() {
                return this.getKeywordsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<KeywordInfo, KeywordInfo.Builder, KeywordInfoOrBuilder> getKeywordsFieldBuilder() {
                if (this.keywordsBuilder_ == null) {
                    this.keywordsBuilder_ = new RepeatedFieldBuilderV3(this.keywords_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.keywords_ = null;
                }
                return this.keywordsBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AdGroupInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasAdGroupType();

        public int getAdGroupTypeValue();

        public AdGroupTypeEnum.AdGroupType getAdGroupType();

        public List<KeywordInfo> getKeywordsList();

        public KeywordInfo getKeywords(int var1);

        public int getKeywordsCount();

        public List<? extends KeywordInfoOrBuilder> getKeywordsOrBuilderList();

        public KeywordInfoOrBuilder getKeywordsOrBuilder(int var1);
    }

    public static final class AssetGroupInfo
    extends GeneratedMessageV3
    implements AssetGroupInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int FINAL_URL_FIELD_NUMBER = 1;
        private volatile Object finalUrl_ = "";
        public static final int HEADLINE_FIELD_NUMBER = 2;
        private LazyStringArrayList headline_ = LazyStringArrayList.emptyList();
        public static final int DESCRIPTION_FIELD_NUMBER = 3;
        private LazyStringArrayList description_ = LazyStringArrayList.emptyList();
        private byte memoizedIsInitialized = (byte)-1;
        private static final AssetGroupInfo DEFAULT_INSTANCE = new AssetGroupInfo();
        private static final Parser<AssetGroupInfo> PARSER = new AbstractParser<AssetGroupInfo>(){

            public AssetGroupInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AssetGroupInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AssetGroupInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AssetGroupInfo() {
            this.finalUrl_ = "";
            this.headline_ = LazyStringArrayList.emptyList();
            this.description_ = LazyStringArrayList.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AssetGroupInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AssetGroupInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AssetGroupInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetGroupInfo.class, Builder.class);
        }

        @Override
        public boolean hasFinalUrl() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getFinalUrl() {
            Object ref = this.finalUrl_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.finalUrl_ = s;
            return s;
        }

        @Override
        public ByteString getFinalUrlBytes() {
            Object ref = this.finalUrl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.finalUrl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public ProtocolStringList getHeadlineList() {
            return this.headline_;
        }

        @Override
        public int getHeadlineCount() {
            return this.headline_.size();
        }

        @Override
        public String getHeadline(int index) {
            return this.headline_.get(index);
        }

        @Override
        public ByteString getHeadlineBytes(int index) {
            return this.headline_.getByteString(index);
        }

        public ProtocolStringList getDescriptionList() {
            return this.description_;
        }

        @Override
        public int getDescriptionCount() {
            return this.description_.size();
        }

        @Override
        public String getDescription(int index) {
            return this.description_.get(index);
        }

        @Override
        public ByteString getDescriptionBytes(int index) {
            return this.description_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            int i;
            if ((this.bitField0_ & 1) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.finalUrl_);
            }
            for (i = 0; i < this.headline_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.headline_.getRaw(i));
            }
            for (i = 0; i < this.description_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.description_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int i;
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.finalUrl_);
            }
            int dataSize = 0;
            for (i = 0; i < this.headline_.size(); ++i) {
                dataSize += AssetGroupInfo.computeStringSizeNoTag((Object)this.headline_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getHeadlineList().size();
            dataSize = 0;
            for (i = 0; i < this.description_.size(); ++i) {
                dataSize += AssetGroupInfo.computeStringSizeNoTag((Object)this.description_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getDescriptionList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AssetGroupInfo)) {
                return super.equals(obj);
            }
            AssetGroupInfo other = (AssetGroupInfo)obj;
            if (this.hasFinalUrl() != other.hasFinalUrl()) {
                return false;
            }
            if (this.hasFinalUrl() && !this.getFinalUrl().equals(other.getFinalUrl())) {
                return false;
            }
            if (!this.getHeadlineList().equals(other.getHeadlineList())) {
                return false;
            }
            if (!this.getDescriptionList().equals(other.getDescriptionList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AssetGroupInfo.getDescriptor().hashCode();
            if (this.hasFinalUrl()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getFinalUrl().hashCode();
            }
            if (this.getHeadlineCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getHeadlineList().hashCode();
            }
            if (this.getDescriptionCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getDescriptionList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AssetGroupInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AssetGroupInfo)PARSER.parseFrom(data);
        }

        public static AssetGroupInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AssetGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AssetGroupInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AssetGroupInfo)PARSER.parseFrom(data);
        }

        public static AssetGroupInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AssetGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AssetGroupInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AssetGroupInfo)PARSER.parseFrom(data);
        }

        public static AssetGroupInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AssetGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AssetGroupInfo parseFrom(InputStream input) throws IOException {
            return (AssetGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AssetGroupInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AssetGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AssetGroupInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (AssetGroupInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AssetGroupInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AssetGroupInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AssetGroupInfo parseFrom(CodedInputStream input) throws IOException {
            return (AssetGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AssetGroupInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AssetGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AssetGroupInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AssetGroupInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AssetGroupInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AssetGroupInfo> parser() {
            return PARSER;
        }

        public Parser<AssetGroupInfo> getParserForType() {
            return PARSER;
        }

        public AssetGroupInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AssetGroupInfoOrBuilder {
            private int bitField0_;
            private Object finalUrl_ = "";
            private LazyStringArrayList headline_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList description_ = LazyStringArrayList.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AssetGroupInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AssetGroupInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetGroupInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.finalUrl_ = "";
                this.headline_ = LazyStringArrayList.emptyList();
                this.description_ = LazyStringArrayList.emptyList();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_AssetGroupInfo_descriptor;
            }

            public AssetGroupInfo getDefaultInstanceForType() {
                return AssetGroupInfo.getDefaultInstance();
            }

            public AssetGroupInfo build() {
                AssetGroupInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AssetGroupInfo buildPartial() {
                AssetGroupInfo result = new AssetGroupInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(AssetGroupInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.finalUrl_ = this.finalUrl_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    this.headline_.makeImmutable();
                    result.headline_ = this.headline_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    this.description_.makeImmutable();
                    result.description_ = this.description_;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AssetGroupInfo) {
                    return this.mergeFrom((AssetGroupInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AssetGroupInfo other) {
                if (other == AssetGroupInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasFinalUrl()) {
                    this.finalUrl_ = other.finalUrl_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.headline_.isEmpty()) {
                    if (this.headline_.isEmpty()) {
                        this.headline_ = other.headline_;
                        this.bitField0_ |= 2;
                    } else {
                        this.ensureHeadlineIsMutable();
                        this.headline_.addAll((Collection)other.headline_);
                    }
                    this.onChanged();
                }
                if (!other.description_.isEmpty()) {
                    if (this.description_.isEmpty()) {
                        this.description_ = other.description_;
                        this.bitField0_ |= 4;
                    } else {
                        this.ensureDescriptionIsMutable();
                        this.description_.addAll((Collection)other.description_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 10: {
                                this.finalUrl_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 18: {
                                String s = input.readStringRequireUtf8();
                                this.ensureHeadlineIsMutable();
                                this.headline_.add(s);
                                continue block11;
                            }
                            case 26: {
                                String s = input.readStringRequireUtf8();
                                this.ensureDescriptionIsMutable();
                                this.description_.add(s);
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasFinalUrl() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getFinalUrl() {
                Object ref = this.finalUrl_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.finalUrl_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getFinalUrlBytes() {
                Object ref = this.finalUrl_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.finalUrl_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setFinalUrl(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.finalUrl_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearFinalUrl() {
                this.finalUrl_ = AssetGroupInfo.getDefaultInstance().getFinalUrl();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setFinalUrlBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AssetGroupInfo.checkByteStringIsUtf8((ByteString)value);
                this.finalUrl_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureHeadlineIsMutable() {
                if (!this.headline_.isModifiable()) {
                    this.headline_ = new LazyStringArrayList((LazyStringList)this.headline_);
                }
                this.bitField0_ |= 2;
            }

            public ProtocolStringList getHeadlineList() {
                this.headline_.makeImmutable();
                return this.headline_;
            }

            @Override
            public int getHeadlineCount() {
                return this.headline_.size();
            }

            @Override
            public String getHeadline(int index) {
                return this.headline_.get(index);
            }

            @Override
            public ByteString getHeadlineBytes(int index) {
                return this.headline_.getByteString(index);
            }

            public Builder setHeadline(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureHeadlineIsMutable();
                this.headline_.set(index, value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addHeadline(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureHeadlineIsMutable();
                this.headline_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllHeadline(Iterable<String> values) {
                this.ensureHeadlineIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.headline_);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearHeadline() {
                this.headline_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder addHeadlineBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AssetGroupInfo.checkByteStringIsUtf8((ByteString)value);
                this.ensureHeadlineIsMutable();
                this.headline_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            private void ensureDescriptionIsMutable() {
                if (!this.description_.isModifiable()) {
                    this.description_ = new LazyStringArrayList((LazyStringList)this.description_);
                }
                this.bitField0_ |= 4;
            }

            public ProtocolStringList getDescriptionList() {
                this.description_.makeImmutable();
                return this.description_;
            }

            @Override
            public int getDescriptionCount() {
                return this.description_.size();
            }

            @Override
            public String getDescription(int index) {
                return this.description_.get(index);
            }

            @Override
            public ByteString getDescriptionBytes(int index) {
                return this.description_.getByteString(index);
            }

            public Builder setDescription(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDescriptionIsMutable();
                this.description_.set(index, value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder addDescription(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDescriptionIsMutable();
                this.description_.add(value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder addAllDescription(Iterable<String> values) {
                this.ensureDescriptionIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.description_);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearDescription() {
                this.description_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder addDescriptionBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AssetGroupInfo.checkByteStringIsUtf8((ByteString)value);
                this.ensureDescriptionIsMutable();
                this.description_.add(value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AssetGroupInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasFinalUrl();

        public String getFinalUrl();

        public ByteString getFinalUrlBytes();

        public List<String> getHeadlineList();

        public int getHeadlineCount();

        public String getHeadline(int var1);

        public ByteString getHeadlineBytes(int var1);

        public List<String> getDescriptionList();

        public int getDescriptionCount();

        public String getDescription(int var1);

        public ByteString getDescriptionBytes(int var1);
    }

    public static final class TargetImpressionShareInfo
    extends GeneratedMessageV3
    implements TargetImpressionShareInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int LOCATION_FIELD_NUMBER = 1;
        private int location_ = 0;
        public static final int TARGET_IMPRESSION_SHARE_MICROS_FIELD_NUMBER = 2;
        private long targetImpressionShareMicros_ = 0L;
        public static final int MAX_CPC_BID_CEILING_FIELD_NUMBER = 3;
        private long maxCpcBidCeiling_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final TargetImpressionShareInfo DEFAULT_INSTANCE = new TargetImpressionShareInfo();
        private static final Parser<TargetImpressionShareInfo> PARSER = new AbstractParser<TargetImpressionShareInfo>(){

            public TargetImpressionShareInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = TargetImpressionShareInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private TargetImpressionShareInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private TargetImpressionShareInfo() {
            this.location_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new TargetImpressionShareInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_TargetImpressionShareInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_TargetImpressionShareInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(TargetImpressionShareInfo.class, Builder.class);
        }

        @Override
        public boolean hasLocation() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getLocationValue() {
            return this.location_;
        }

        @Override
        public TargetImpressionShareLocationEnum.TargetImpressionShareLocation getLocation() {
            TargetImpressionShareLocationEnum.TargetImpressionShareLocation result = TargetImpressionShareLocationEnum.TargetImpressionShareLocation.forNumber(this.location_);
            return result == null ? TargetImpressionShareLocationEnum.TargetImpressionShareLocation.UNRECOGNIZED : result;
        }

        @Override
        public boolean hasTargetImpressionShareMicros() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public long getTargetImpressionShareMicros() {
            return this.targetImpressionShareMicros_;
        }

        @Override
        public boolean hasMaxCpcBidCeiling() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public long getMaxCpcBidCeiling() {
            return this.maxCpcBidCeiling_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.location_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeInt64(2, this.targetImpressionShareMicros_);
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeInt64(3, this.maxCpcBidCeiling_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.location_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)this.targetImpressionShareMicros_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeInt64Size((int)3, (long)this.maxCpcBidCeiling_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TargetImpressionShareInfo)) {
                return super.equals(obj);
            }
            TargetImpressionShareInfo other = (TargetImpressionShareInfo)obj;
            if (this.hasLocation() != other.hasLocation()) {
                return false;
            }
            if (this.hasLocation() && this.location_ != other.location_) {
                return false;
            }
            if (this.hasTargetImpressionShareMicros() != other.hasTargetImpressionShareMicros()) {
                return false;
            }
            if (this.hasTargetImpressionShareMicros() && this.getTargetImpressionShareMicros() != other.getTargetImpressionShareMicros()) {
                return false;
            }
            if (this.hasMaxCpcBidCeiling() != other.hasMaxCpcBidCeiling()) {
                return false;
            }
            if (this.hasMaxCpcBidCeiling() && this.getMaxCpcBidCeiling() != other.getMaxCpcBidCeiling()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + TargetImpressionShareInfo.getDescriptor().hashCode();
            if (this.hasLocation()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.location_;
            }
            if (this.hasTargetImpressionShareMicros()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + Internal.hashLong((long)this.getTargetImpressionShareMicros());
            }
            if (this.hasMaxCpcBidCeiling()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong((long)this.getMaxCpcBidCeiling());
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static TargetImpressionShareInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (TargetImpressionShareInfo)PARSER.parseFrom(data);
        }

        public static TargetImpressionShareInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (TargetImpressionShareInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static TargetImpressionShareInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (TargetImpressionShareInfo)PARSER.parseFrom(data);
        }

        public static TargetImpressionShareInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (TargetImpressionShareInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static TargetImpressionShareInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (TargetImpressionShareInfo)PARSER.parseFrom(data);
        }

        public static TargetImpressionShareInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (TargetImpressionShareInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static TargetImpressionShareInfo parseFrom(InputStream input) throws IOException {
            return (TargetImpressionShareInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static TargetImpressionShareInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (TargetImpressionShareInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static TargetImpressionShareInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (TargetImpressionShareInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static TargetImpressionShareInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (TargetImpressionShareInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static TargetImpressionShareInfo parseFrom(CodedInputStream input) throws IOException {
            return (TargetImpressionShareInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static TargetImpressionShareInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (TargetImpressionShareInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return TargetImpressionShareInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(TargetImpressionShareInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static TargetImpressionShareInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<TargetImpressionShareInfo> parser() {
            return PARSER;
        }

        public Parser<TargetImpressionShareInfo> getParserForType() {
            return PARSER;
        }

        public TargetImpressionShareInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements TargetImpressionShareInfoOrBuilder {
            private int bitField0_;
            private int location_ = 0;
            private long targetImpressionShareMicros_;
            private long maxCpcBidCeiling_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_TargetImpressionShareInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_TargetImpressionShareInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(TargetImpressionShareInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.location_ = 0;
                this.targetImpressionShareMicros_ = 0L;
                this.maxCpcBidCeiling_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v21_services_GenerateRecommendationsRequest_TargetImpressionShareInfo_descriptor;
            }

            public TargetImpressionShareInfo getDefaultInstanceForType() {
                return TargetImpressionShareInfo.getDefaultInstance();
            }

            public TargetImpressionShareInfo build() {
                TargetImpressionShareInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public TargetImpressionShareInfo buildPartial() {
                TargetImpressionShareInfo result = new TargetImpressionShareInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(TargetImpressionShareInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.location_ = this.location_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.targetImpressionShareMicros_ = this.targetImpressionShareMicros_;
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.maxCpcBidCeiling_ = this.maxCpcBidCeiling_;
                    to_bitField0_ |= 4;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof TargetImpressionShareInfo) {
                    return this.mergeFrom((TargetImpressionShareInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(TargetImpressionShareInfo other) {
                if (other == TargetImpressionShareInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasLocation()) {
                    this.setLocation(other.getLocation());
                }
                if (other.hasTargetImpressionShareMicros()) {
                    this.setTargetImpressionShareMicros(other.getTargetImpressionShareMicros());
                }
                if (other.hasMaxCpcBidCeiling()) {
                    this.setMaxCpcBidCeiling(other.getMaxCpcBidCeiling());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 8: {
                                this.location_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 16: {
                                this.targetImpressionShareMicros_ = input.readInt64();
                                this.bitField0_ |= 2;
                                continue block11;
                            }
                            case 24: {
                                this.maxCpcBidCeiling_ = input.readInt64();
                                this.bitField0_ |= 4;
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasLocation() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getLocationValue() {
                return this.location_;
            }

            public Builder setLocationValue(int value) {
                this.location_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public TargetImpressionShareLocationEnum.TargetImpressionShareLocation getLocation() {
                TargetImpressionShareLocationEnum.TargetImpressionShareLocation result = TargetImpressionShareLocationEnum.TargetImpressionShareLocation.forNumber(this.location_);
                return result == null ? TargetImpressionShareLocationEnum.TargetImpressionShareLocation.UNRECOGNIZED : result;
            }

            public Builder setLocation(TargetImpressionShareLocationEnum.TargetImpressionShareLocation value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.location_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearLocation() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.location_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTargetImpressionShareMicros() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public long getTargetImpressionShareMicros() {
                return this.targetImpressionShareMicros_;
            }

            public Builder setTargetImpressionShareMicros(long value) {
                this.targetImpressionShareMicros_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearTargetImpressionShareMicros() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.targetImpressionShareMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasMaxCpcBidCeiling() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public long getMaxCpcBidCeiling() {
                return this.maxCpcBidCeiling_;
            }

            public Builder setMaxCpcBidCeiling(long value) {
                this.maxCpcBidCeiling_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearMaxCpcBidCeiling() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.maxCpcBidCeiling_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface TargetImpressionShareInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasLocation();

        public int getLocationValue();

        public TargetImpressionShareLocationEnum.TargetImpressionShareLocation getLocation();

        public boolean hasTargetImpressionShareMicros();

        public long getTargetImpressionShareMicros();

        public boolean hasMaxCpcBidCeiling();

        public long getMaxCpcBidCeiling();
    }

    public static interface BudgetInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasCurrentBudget();

        public long getCurrentBudget();
    }

    public static interface SeedInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasUrlSeed();

        public String getUrlSeed();

        public ByteString getUrlSeedBytes();

        public List<String> getKeywordSeedsList();

        public int getKeywordSeedsCount();

        public String getKeywordSeeds(int var1);

        public ByteString getKeywordSeedsBytes(int var1);
    }

    public static interface BiddingInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasBiddingStrategyType();

        public int getBiddingStrategyTypeValue();

        public BiddingStrategyTypeEnum.BiddingStrategyType getBiddingStrategyType();

        public boolean hasTargetCpaMicros();

        public long getTargetCpaMicros();

        public boolean hasTargetRoas();

        public double getTargetRoas();

        public boolean hasTargetImpressionShareInfo();

        public TargetImpressionShareInfo getTargetImpressionShareInfo();

        public TargetImpressionShareInfoOrBuilder getTargetImpressionShareInfoOrBuilder();

        public BiddingInfo.BiddingStrategyTargetInfoCase getBiddingStrategyTargetInfoCase();
    }
}

