/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services;

import com.google.ads.googleads.v21.common.AdditionalApplicationInfo;
import com.google.ads.googleads.v21.common.AdditionalApplicationInfoOrBuilder;
import com.google.ads.googleads.v21.common.AudienceInsightsAttribute;
import com.google.ads.googleads.v21.common.AudienceInsightsAttributeOrBuilder;
import com.google.ads.googleads.v21.common.LocationInfo;
import com.google.ads.googleads.v21.common.LocationInfoOrBuilder;
import com.google.ads.googleads.v21.enums.AudienceInsightsDimensionEnum;
import com.google.ads.googleads.v21.services.AudienceInsightsServiceProto;
import com.google.ads.googleads.v21.services.GenerateAudienceOverlapInsightsRequestOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GenerateAudienceOverlapInsightsRequest
extends GeneratedMessageV3
implements GenerateAudienceOverlapInsightsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int COUNTRY_LOCATION_FIELD_NUMBER = 2;
    private LocationInfo countryLocation_;
    public static final int PRIMARY_ATTRIBUTE_FIELD_NUMBER = 6;
    private AudienceInsightsAttribute primaryAttribute_;
    public static final int DIMENSIONS_FIELD_NUMBER = 4;
    private List<Integer> dimensions_;
    private static final Internal.ListAdapter.Converter<Integer, AudienceInsightsDimensionEnum.AudienceInsightsDimension> dimensions_converter_ = new Internal.ListAdapter.Converter<Integer, AudienceInsightsDimensionEnum.AudienceInsightsDimension>(){

        public AudienceInsightsDimensionEnum.AudienceInsightsDimension convert(Integer from) {
            AudienceInsightsDimensionEnum.AudienceInsightsDimension result = AudienceInsightsDimensionEnum.AudienceInsightsDimension.forNumber(from);
            return result == null ? AudienceInsightsDimensionEnum.AudienceInsightsDimension.UNRECOGNIZED : result;
        }
    };
    private int dimensionsMemoizedSerializedSize;
    public static final int CUSTOMER_INSIGHTS_GROUP_FIELD_NUMBER = 5;
    private volatile Object customerInsightsGroup_ = "";
    public static final int INSIGHTS_APPLICATION_INFO_FIELD_NUMBER = 7;
    private AdditionalApplicationInfo insightsApplicationInfo_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateAudienceOverlapInsightsRequest DEFAULT_INSTANCE = new GenerateAudienceOverlapInsightsRequest();
    private static final Parser<GenerateAudienceOverlapInsightsRequest> PARSER = new AbstractParser<GenerateAudienceOverlapInsightsRequest>(){

        public GenerateAudienceOverlapInsightsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateAudienceOverlapInsightsRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateAudienceOverlapInsightsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateAudienceOverlapInsightsRequest() {
        this.customerId_ = "";
        this.dimensions_ = Collections.emptyList();
        this.customerInsightsGroup_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateAudienceOverlapInsightsRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v21_services_GenerateAudienceOverlapInsightsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v21_services_GenerateAudienceOverlapInsightsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateAudienceOverlapInsightsRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCountryLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public LocationInfo getCountryLocation() {
        return this.countryLocation_ == null ? LocationInfo.getDefaultInstance() : this.countryLocation_;
    }

    @Override
    public LocationInfoOrBuilder getCountryLocationOrBuilder() {
        return this.countryLocation_ == null ? LocationInfo.getDefaultInstance() : this.countryLocation_;
    }

    @Override
    public boolean hasPrimaryAttribute() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public AudienceInsightsAttribute getPrimaryAttribute() {
        return this.primaryAttribute_ == null ? AudienceInsightsAttribute.getDefaultInstance() : this.primaryAttribute_;
    }

    @Override
    public AudienceInsightsAttributeOrBuilder getPrimaryAttributeOrBuilder() {
        return this.primaryAttribute_ == null ? AudienceInsightsAttribute.getDefaultInstance() : this.primaryAttribute_;
    }

    @Override
    public List<AudienceInsightsDimensionEnum.AudienceInsightsDimension> getDimensionsList() {
        return new Internal.ListAdapter(this.dimensions_, dimensions_converter_);
    }

    @Override
    public int getDimensionsCount() {
        return this.dimensions_.size();
    }

    @Override
    public AudienceInsightsDimensionEnum.AudienceInsightsDimension getDimensions(int index) {
        return (AudienceInsightsDimensionEnum.AudienceInsightsDimension)((Object)dimensions_converter_.convert((Object)this.dimensions_.get(index)));
    }

    @Override
    public List<Integer> getDimensionsValueList() {
        return this.dimensions_;
    }

    @Override
    public int getDimensionsValue(int index) {
        return this.dimensions_.get(index);
    }

    @Override
    public String getCustomerInsightsGroup() {
        Object ref = this.customerInsightsGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerInsightsGroup_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerInsightsGroupBytes() {
        Object ref = this.customerInsightsGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerInsightsGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasInsightsApplicationInfo() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public AdditionalApplicationInfo getInsightsApplicationInfo() {
        return this.insightsApplicationInfo_ == null ? AdditionalApplicationInfo.getDefaultInstance() : this.insightsApplicationInfo_;
    }

    @Override
    public AdditionalApplicationInfoOrBuilder getInsightsApplicationInfoOrBuilder() {
        return this.insightsApplicationInfo_ == null ? AdditionalApplicationInfo.getDefaultInstance() : this.insightsApplicationInfo_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(2, (MessageLite)this.getCountryLocation());
        }
        if (this.getDimensionsList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.dimensionsMemoizedSerializedSize);
        }
        for (int i = 0; i < this.dimensions_.size(); ++i) {
            output.writeEnumNoTag(this.dimensions_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerInsightsGroup_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.customerInsightsGroup_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(6, (MessageLite)this.getPrimaryAttribute());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(7, (MessageLite)this.getInsightsApplicationInfo());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getCountryLocation());
        }
        int dataSize = 0;
        for (int i = 0; i < this.dimensions_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.dimensions_.get(i));
        }
        size += dataSize;
        if (!this.getDimensionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.dimensionsMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerInsightsGroup_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.customerInsightsGroup_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getPrimaryAttribute());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getInsightsApplicationInfo());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateAudienceOverlapInsightsRequest)) {
            return super.equals(obj);
        }
        GenerateAudienceOverlapInsightsRequest other = (GenerateAudienceOverlapInsightsRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (this.hasCountryLocation() != other.hasCountryLocation()) {
            return false;
        }
        if (this.hasCountryLocation() && !this.getCountryLocation().equals(other.getCountryLocation())) {
            return false;
        }
        if (this.hasPrimaryAttribute() != other.hasPrimaryAttribute()) {
            return false;
        }
        if (this.hasPrimaryAttribute() && !this.getPrimaryAttribute().equals(other.getPrimaryAttribute())) {
            return false;
        }
        if (!this.dimensions_.equals(other.dimensions_)) {
            return false;
        }
        if (!this.getCustomerInsightsGroup().equals(other.getCustomerInsightsGroup())) {
            return false;
        }
        if (this.hasInsightsApplicationInfo() != other.hasInsightsApplicationInfo()) {
            return false;
        }
        if (this.hasInsightsApplicationInfo() && !this.getInsightsApplicationInfo().equals(other.getInsightsApplicationInfo())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateAudienceOverlapInsightsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.hasCountryLocation()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getCountryLocation().hashCode();
        }
        if (this.hasPrimaryAttribute()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getPrimaryAttribute().hashCode();
        }
        if (this.getDimensionsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.dimensions_.hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getCustomerInsightsGroup().hashCode();
        if (this.hasInsightsApplicationInfo()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getInsightsApplicationInfo().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateAudienceOverlapInsightsRequest)PARSER.parseFrom(data);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateAudienceOverlapInsightsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateAudienceOverlapInsightsRequest)PARSER.parseFrom(data);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateAudienceOverlapInsightsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateAudienceOverlapInsightsRequest)PARSER.parseFrom(data);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateAudienceOverlapInsightsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(InputStream input) throws IOException {
        return (GenerateAudienceOverlapInsightsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateAudienceOverlapInsightsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateAudienceOverlapInsightsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateAudienceOverlapInsightsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateAudienceOverlapInsightsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateAudienceOverlapInsightsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateAudienceOverlapInsightsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateAudienceOverlapInsightsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateAudienceOverlapInsightsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateAudienceOverlapInsightsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateAudienceOverlapInsightsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateAudienceOverlapInsightsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateAudienceOverlapInsightsRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateAudienceOverlapInsightsRequest> getParserForType() {
        return PARSER;
    }

    public GenerateAudienceOverlapInsightsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateAudienceOverlapInsightsRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private LocationInfo countryLocation_;
        private SingleFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> countryLocationBuilder_;
        private AudienceInsightsAttribute primaryAttribute_;
        private SingleFieldBuilderV3<AudienceInsightsAttribute, AudienceInsightsAttribute.Builder, AudienceInsightsAttributeOrBuilder> primaryAttributeBuilder_;
        private List<Integer> dimensions_ = Collections.emptyList();
        private Object customerInsightsGroup_ = "";
        private AdditionalApplicationInfo insightsApplicationInfo_;
        private SingleFieldBuilderV3<AdditionalApplicationInfo, AdditionalApplicationInfo.Builder, AdditionalApplicationInfoOrBuilder> insightsApplicationInfoBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v21_services_GenerateAudienceOverlapInsightsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v21_services_GenerateAudienceOverlapInsightsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateAudienceOverlapInsightsRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCountryLocationFieldBuilder();
                this.getPrimaryAttributeFieldBuilder();
                this.getInsightsApplicationInfoFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.countryLocation_ = null;
            if (this.countryLocationBuilder_ != null) {
                this.countryLocationBuilder_.dispose();
                this.countryLocationBuilder_ = null;
            }
            this.primaryAttribute_ = null;
            if (this.primaryAttributeBuilder_ != null) {
                this.primaryAttributeBuilder_.dispose();
                this.primaryAttributeBuilder_ = null;
            }
            this.dimensions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.customerInsightsGroup_ = "";
            this.insightsApplicationInfo_ = null;
            if (this.insightsApplicationInfoBuilder_ != null) {
                this.insightsApplicationInfoBuilder_.dispose();
                this.insightsApplicationInfoBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v21_services_GenerateAudienceOverlapInsightsRequest_descriptor;
        }

        public GenerateAudienceOverlapInsightsRequest getDefaultInstanceForType() {
            return GenerateAudienceOverlapInsightsRequest.getDefaultInstance();
        }

        public GenerateAudienceOverlapInsightsRequest build() {
            GenerateAudienceOverlapInsightsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateAudienceOverlapInsightsRequest buildPartial() {
            GenerateAudienceOverlapInsightsRequest result = new GenerateAudienceOverlapInsightsRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateAudienceOverlapInsightsRequest result) {
            if ((this.bitField0_ & 8) != 0) {
                this.dimensions_ = Collections.unmodifiableList(this.dimensions_);
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.dimensions_ = this.dimensions_;
        }

        private void buildPartial0(GenerateAudienceOverlapInsightsRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.countryLocation_ = this.countryLocationBuilder_ == null ? this.countryLocation_ : (LocationInfo)this.countryLocationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.primaryAttribute_ = this.primaryAttributeBuilder_ == null ? this.primaryAttribute_ : (AudienceInsightsAttribute)this.primaryAttributeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.customerInsightsGroup_ = this.customerInsightsGroup_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.insightsApplicationInfo_ = this.insightsApplicationInfoBuilder_ == null ? this.insightsApplicationInfo_ : (AdditionalApplicationInfo)this.insightsApplicationInfoBuilder_.build();
                to_bitField0_ |= 4;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateAudienceOverlapInsightsRequest) {
                return this.mergeFrom((GenerateAudienceOverlapInsightsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateAudienceOverlapInsightsRequest other) {
            if (other == GenerateAudienceOverlapInsightsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasCountryLocation()) {
                this.mergeCountryLocation(other.getCountryLocation());
            }
            if (other.hasPrimaryAttribute()) {
                this.mergePrimaryAttribute(other.getPrimaryAttribute());
            }
            if (!other.dimensions_.isEmpty()) {
                if (this.dimensions_.isEmpty()) {
                    this.dimensions_ = other.dimensions_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensureDimensionsIsMutable();
                    this.dimensions_.addAll(other.dimensions_);
                }
                this.onChanged();
            }
            if (!other.getCustomerInsightsGroup().isEmpty()) {
                this.customerInsightsGroup_ = other.customerInsightsGroup_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasInsightsApplicationInfo()) {
                this.mergeInsightsApplicationInfo(other.getInsightsApplicationInfo());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getCountryLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block15;
                        }
                        case 32: {
                            int tmpRaw = input.readEnum();
                            this.ensureDimensionsIsMutable();
                            this.dimensions_.add(tmpRaw);
                            continue block15;
                        }
                        case 34: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureDimensionsIsMutable();
                                this.dimensions_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block15;
                        }
                        case 42: {
                            this.customerInsightsGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block15;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getPrimaryAttributeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block15;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getInsightsApplicationInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateAudienceOverlapInsightsRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateAudienceOverlapInsightsRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCountryLocation() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public LocationInfo getCountryLocation() {
            if (this.countryLocationBuilder_ == null) {
                return this.countryLocation_ == null ? LocationInfo.getDefaultInstance() : this.countryLocation_;
            }
            return (LocationInfo)this.countryLocationBuilder_.getMessage();
        }

        public Builder setCountryLocation(LocationInfo value) {
            if (this.countryLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.countryLocation_ = value;
            } else {
                this.countryLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setCountryLocation(LocationInfo.Builder builderForValue) {
            if (this.countryLocationBuilder_ == null) {
                this.countryLocation_ = builderForValue.build();
            } else {
                this.countryLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeCountryLocation(LocationInfo value) {
            if (this.countryLocationBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.countryLocation_ != null && this.countryLocation_ != LocationInfo.getDefaultInstance()) {
                    this.getCountryLocationBuilder().mergeFrom(value);
                } else {
                    this.countryLocation_ = value;
                }
            } else {
                this.countryLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.countryLocation_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCountryLocation() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.countryLocation_ = null;
            if (this.countryLocationBuilder_ != null) {
                this.countryLocationBuilder_.dispose();
                this.countryLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LocationInfo.Builder getCountryLocationBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (LocationInfo.Builder)this.getCountryLocationFieldBuilder().getBuilder();
        }

        @Override
        public LocationInfoOrBuilder getCountryLocationOrBuilder() {
            if (this.countryLocationBuilder_ != null) {
                return (LocationInfoOrBuilder)this.countryLocationBuilder_.getMessageOrBuilder();
            }
            return this.countryLocation_ == null ? LocationInfo.getDefaultInstance() : this.countryLocation_;
        }

        private SingleFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> getCountryLocationFieldBuilder() {
            if (this.countryLocationBuilder_ == null) {
                this.countryLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCountryLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.countryLocation_ = null;
            }
            return this.countryLocationBuilder_;
        }

        @Override
        public boolean hasPrimaryAttribute() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public AudienceInsightsAttribute getPrimaryAttribute() {
            if (this.primaryAttributeBuilder_ == null) {
                return this.primaryAttribute_ == null ? AudienceInsightsAttribute.getDefaultInstance() : this.primaryAttribute_;
            }
            return (AudienceInsightsAttribute)this.primaryAttributeBuilder_.getMessage();
        }

        public Builder setPrimaryAttribute(AudienceInsightsAttribute value) {
            if (this.primaryAttributeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.primaryAttribute_ = value;
            } else {
                this.primaryAttributeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setPrimaryAttribute(AudienceInsightsAttribute.Builder builderForValue) {
            if (this.primaryAttributeBuilder_ == null) {
                this.primaryAttribute_ = builderForValue.build();
            } else {
                this.primaryAttributeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergePrimaryAttribute(AudienceInsightsAttribute value) {
            if (this.primaryAttributeBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.primaryAttribute_ != null && this.primaryAttribute_ != AudienceInsightsAttribute.getDefaultInstance()) {
                    this.getPrimaryAttributeBuilder().mergeFrom(value);
                } else {
                    this.primaryAttribute_ = value;
                }
            } else {
                this.primaryAttributeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.primaryAttribute_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPrimaryAttribute() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.primaryAttribute_ = null;
            if (this.primaryAttributeBuilder_ != null) {
                this.primaryAttributeBuilder_.dispose();
                this.primaryAttributeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AudienceInsightsAttribute.Builder getPrimaryAttributeBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (AudienceInsightsAttribute.Builder)this.getPrimaryAttributeFieldBuilder().getBuilder();
        }

        @Override
        public AudienceInsightsAttributeOrBuilder getPrimaryAttributeOrBuilder() {
            if (this.primaryAttributeBuilder_ != null) {
                return (AudienceInsightsAttributeOrBuilder)this.primaryAttributeBuilder_.getMessageOrBuilder();
            }
            return this.primaryAttribute_ == null ? AudienceInsightsAttribute.getDefaultInstance() : this.primaryAttribute_;
        }

        private SingleFieldBuilderV3<AudienceInsightsAttribute, AudienceInsightsAttribute.Builder, AudienceInsightsAttributeOrBuilder> getPrimaryAttributeFieldBuilder() {
            if (this.primaryAttributeBuilder_ == null) {
                this.primaryAttributeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPrimaryAttribute(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.primaryAttribute_ = null;
            }
            return this.primaryAttributeBuilder_;
        }

        private void ensureDimensionsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.dimensions_ = new ArrayList<Integer>(this.dimensions_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<AudienceInsightsDimensionEnum.AudienceInsightsDimension> getDimensionsList() {
            return new Internal.ListAdapter(this.dimensions_, dimensions_converter_);
        }

        @Override
        public int getDimensionsCount() {
            return this.dimensions_.size();
        }

        @Override
        public AudienceInsightsDimensionEnum.AudienceInsightsDimension getDimensions(int index) {
            return (AudienceInsightsDimensionEnum.AudienceInsightsDimension)((Object)dimensions_converter_.convert((Object)this.dimensions_.get(index)));
        }

        public Builder setDimensions(int index, AudienceInsightsDimensionEnum.AudienceInsightsDimension value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDimensionsIsMutable();
            this.dimensions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addDimensions(AudienceInsightsDimensionEnum.AudienceInsightsDimension value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDimensionsIsMutable();
            this.dimensions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllDimensions(Iterable<? extends AudienceInsightsDimensionEnum.AudienceInsightsDimension> values) {
            this.ensureDimensionsIsMutable();
            for (AudienceInsightsDimensionEnum.AudienceInsightsDimension audienceInsightsDimension : values) {
                this.dimensions_.add(audienceInsightsDimension.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearDimensions() {
            this.dimensions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getDimensionsValueList() {
            return Collections.unmodifiableList(this.dimensions_);
        }

        @Override
        public int getDimensionsValue(int index) {
            return this.dimensions_.get(index);
        }

        public Builder setDimensionsValue(int index, int value) {
            this.ensureDimensionsIsMutable();
            this.dimensions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addDimensionsValue(int value) {
            this.ensureDimensionsIsMutable();
            this.dimensions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllDimensionsValue(Iterable<Integer> values) {
            this.ensureDimensionsIsMutable();
            for (int value : values) {
                this.dimensions_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getCustomerInsightsGroup() {
            Object ref = this.customerInsightsGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerInsightsGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerInsightsGroupBytes() {
            Object ref = this.customerInsightsGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerInsightsGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerInsightsGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerInsightsGroup_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerInsightsGroup() {
            this.customerInsightsGroup_ = GenerateAudienceOverlapInsightsRequest.getDefaultInstance().getCustomerInsightsGroup();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setCustomerInsightsGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateAudienceOverlapInsightsRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerInsightsGroup_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasInsightsApplicationInfo() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public AdditionalApplicationInfo getInsightsApplicationInfo() {
            if (this.insightsApplicationInfoBuilder_ == null) {
                return this.insightsApplicationInfo_ == null ? AdditionalApplicationInfo.getDefaultInstance() : this.insightsApplicationInfo_;
            }
            return (AdditionalApplicationInfo)this.insightsApplicationInfoBuilder_.getMessage();
        }

        public Builder setInsightsApplicationInfo(AdditionalApplicationInfo value) {
            if (this.insightsApplicationInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.insightsApplicationInfo_ = value;
            } else {
                this.insightsApplicationInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setInsightsApplicationInfo(AdditionalApplicationInfo.Builder builderForValue) {
            if (this.insightsApplicationInfoBuilder_ == null) {
                this.insightsApplicationInfo_ = builderForValue.build();
            } else {
                this.insightsApplicationInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeInsightsApplicationInfo(AdditionalApplicationInfo value) {
            if (this.insightsApplicationInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.insightsApplicationInfo_ != null && this.insightsApplicationInfo_ != AdditionalApplicationInfo.getDefaultInstance()) {
                    this.getInsightsApplicationInfoBuilder().mergeFrom(value);
                } else {
                    this.insightsApplicationInfo_ = value;
                }
            } else {
                this.insightsApplicationInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.insightsApplicationInfo_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInsightsApplicationInfo() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.insightsApplicationInfo_ = null;
            if (this.insightsApplicationInfoBuilder_ != null) {
                this.insightsApplicationInfoBuilder_.dispose();
                this.insightsApplicationInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AdditionalApplicationInfo.Builder getInsightsApplicationInfoBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (AdditionalApplicationInfo.Builder)this.getInsightsApplicationInfoFieldBuilder().getBuilder();
        }

        @Override
        public AdditionalApplicationInfoOrBuilder getInsightsApplicationInfoOrBuilder() {
            if (this.insightsApplicationInfoBuilder_ != null) {
                return (AdditionalApplicationInfoOrBuilder)this.insightsApplicationInfoBuilder_.getMessageOrBuilder();
            }
            return this.insightsApplicationInfo_ == null ? AdditionalApplicationInfo.getDefaultInstance() : this.insightsApplicationInfo_;
        }

        private SingleFieldBuilderV3<AdditionalApplicationInfo, AdditionalApplicationInfo.Builder, AdditionalApplicationInfoOrBuilder> getInsightsApplicationInfoFieldBuilder() {
            if (this.insightsApplicationInfoBuilder_ == null) {
                this.insightsApplicationInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInsightsApplicationInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.insightsApplicationInfo_ = null;
            }
            return this.insightsApplicationInfoBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

