/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserLocationViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_COUNTRY_CRITERION_ID_IS_TARGETING_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/userLocationViews/{country_criterion_id}~{is_targeting_location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String countryCriterionId;
    private final String isTargetingLocation;

    @Deprecated
    protected UserLocationViewName() {
        this.customerId = null;
        this.countryCriterionId = null;
        this.isTargetingLocation = null;
    }

    private UserLocationViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.countryCriterionId = (String)Preconditions.checkNotNull((Object)builder.getCountryCriterionId());
        this.isTargetingLocation = (String)Preconditions.checkNotNull((Object)builder.getIsTargetingLocation());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCountryCriterionId() {
        return this.countryCriterionId;
    }

    public String getIsTargetingLocation() {
        return this.isTargetingLocation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserLocationViewName of(String customerId, String countryCriterionId, String isTargetingLocation) {
        return UserLocationViewName.newBuilder().setCustomerId(customerId).setCountryCriterionId(countryCriterionId).setIsTargetingLocation(isTargetingLocation).build();
    }

    public static String format(String customerId, String countryCriterionId, String isTargetingLocation) {
        return UserLocationViewName.newBuilder().setCustomerId(customerId).setCountryCriterionId(countryCriterionId).setIsTargetingLocation(isTargetingLocation).build().toString();
    }

    public static UserLocationViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_COUNTRY_CRITERION_ID_IS_TARGETING_LOCATION.validatedMatch(formattedString, "UserLocationViewName.parse: formattedString not in valid format");
        return UserLocationViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("country_criterion_id"), (String)matchMap.get("is_targeting_location"));
    }

    public static List<UserLocationViewName> parseList(List<String> formattedStrings) {
        ArrayList<UserLocationViewName> list = new ArrayList<UserLocationViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserLocationViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserLocationViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserLocationViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_COUNTRY_CRITERION_ID_IS_TARGETING_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserLocationViewName userLocationViewName = this;
            synchronized (userLocationViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.countryCriterionId != null) {
                        fieldMapBuilder.put((Object)"country_criterion_id", (Object)this.countryCriterionId);
                    }
                    if (this.isTargetingLocation != null) {
                        fieldMapBuilder.put((Object)"is_targeting_location", (Object)this.isTargetingLocation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_COUNTRY_CRITERION_ID_IS_TARGETING_LOCATION.instantiate(new String[]{"customer_id", this.customerId, "country_criterion_id", this.countryCriterionId, "is_targeting_location", this.isTargetingLocation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserLocationViewName that = (UserLocationViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.countryCriterionId, that.countryCriterionId) && Objects.equals(this.isTargetingLocation, that.isTargetingLocation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.countryCriterionId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.isTargetingLocation);
    }

    public static class Builder {
        private String customerId;
        private String countryCriterionId;
        private String isTargetingLocation;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCountryCriterionId() {
            return this.countryCriterionId;
        }

        public String getIsTargetingLocation() {
            return this.isTargetingLocation;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCountryCriterionId(String countryCriterionId) {
            this.countryCriterionId = countryCriterionId;
            return this;
        }

        public Builder setIsTargetingLocation(String isTargetingLocation) {
            this.isTargetingLocation = isTargetingLocation;
            return this;
        }

        private Builder(UserLocationViewName userLocationViewName) {
            this.customerId = userLocationViewName.customerId;
            this.countryCriterionId = userLocationViewName.countryCriterionId;
            this.isTargetingLocation = userLocationViewName.isTargetingLocation;
        }

        public UserLocationViewName build() {
            return new UserLocationViewName(this);
        }
    }
}

