/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ShoppingProductName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_MERCHANT_CENTER_ID_CHANNEL_LANGUAGE_CODE_FEED_LABEL_ITEM_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String merchantCenterId;
    private final String channel;
    private final String languageCode;
    private final String feedLabel;
    private final String itemId;

    @Deprecated
    protected ShoppingProductName() {
        this.customerId = null;
        this.merchantCenterId = null;
        this.channel = null;
        this.languageCode = null;
        this.feedLabel = null;
        this.itemId = null;
    }

    private ShoppingProductName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.merchantCenterId = (String)Preconditions.checkNotNull((Object)builder.getMerchantCenterId());
        this.channel = (String)Preconditions.checkNotNull((Object)builder.getChannel());
        this.languageCode = (String)Preconditions.checkNotNull((Object)builder.getLanguageCode());
        this.feedLabel = (String)Preconditions.checkNotNull((Object)builder.getFeedLabel());
        this.itemId = (String)Preconditions.checkNotNull((Object)builder.getItemId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getMerchantCenterId() {
        return this.merchantCenterId;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getFeedLabel() {
        return this.feedLabel;
    }

    public String getItemId() {
        return this.itemId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ShoppingProductName of(String customerId, String merchantCenterId, String channel, String languageCode, String feedLabel, String itemId) {
        return ShoppingProductName.newBuilder().setCustomerId(customerId).setMerchantCenterId(merchantCenterId).setChannel(channel).setLanguageCode(languageCode).setFeedLabel(feedLabel).setItemId(itemId).build();
    }

    public static String format(String customerId, String merchantCenterId, String channel, String languageCode, String feedLabel, String itemId) {
        return ShoppingProductName.newBuilder().setCustomerId(customerId).setMerchantCenterId(merchantCenterId).setChannel(channel).setLanguageCode(languageCode).setFeedLabel(feedLabel).setItemId(itemId).build().toString();
    }

    public static ShoppingProductName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_MERCHANT_CENTER_ID_CHANNEL_LANGUAGE_CODE_FEED_LABEL_ITEM_ID.validatedMatch(formattedString, "ShoppingProductName.parse: formattedString not in valid format");
        return ShoppingProductName.of((String)matchMap.get("customer_id"), (String)matchMap.get("merchant_center_id"), (String)matchMap.get("channel"), (String)matchMap.get("language_code"), (String)matchMap.get("feed_label"), (String)matchMap.get("item_id"));
    }

    public static List<ShoppingProductName> parseList(List<String> formattedStrings) {
        ArrayList<ShoppingProductName> list = new ArrayList<ShoppingProductName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ShoppingProductName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ShoppingProductName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ShoppingProductName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_MERCHANT_CENTER_ID_CHANNEL_LANGUAGE_CODE_FEED_LABEL_ITEM_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ShoppingProductName shoppingProductName = this;
            synchronized (shoppingProductName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.merchantCenterId != null) {
                        fieldMapBuilder.put((Object)"merchant_center_id", (Object)this.merchantCenterId);
                    }
                    if (this.channel != null) {
                        fieldMapBuilder.put((Object)"channel", (Object)this.channel);
                    }
                    if (this.languageCode != null) {
                        fieldMapBuilder.put((Object)"language_code", (Object)this.languageCode);
                    }
                    if (this.feedLabel != null) {
                        fieldMapBuilder.put((Object)"feed_label", (Object)this.feedLabel);
                    }
                    if (this.itemId != null) {
                        fieldMapBuilder.put((Object)"item_id", (Object)this.itemId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_MERCHANT_CENTER_ID_CHANNEL_LANGUAGE_CODE_FEED_LABEL_ITEM_ID.instantiate(new String[]{"customer_id", this.customerId, "merchant_center_id", this.merchantCenterId, "channel", this.channel, "language_code", this.languageCode, "feed_label", this.feedLabel, "item_id", this.itemId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ShoppingProductName that = (ShoppingProductName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.merchantCenterId, that.merchantCenterId) && Objects.equals(this.channel, that.channel) && Objects.equals(this.languageCode, that.languageCode) && Objects.equals(this.feedLabel, that.feedLabel) && Objects.equals(this.itemId, that.itemId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.merchantCenterId);
        h *= 1000003;
        h ^= Objects.hashCode(this.channel);
        h *= 1000003;
        h ^= Objects.hashCode(this.languageCode);
        h *= 1000003;
        h ^= Objects.hashCode(this.feedLabel);
        h *= 1000003;
        return h ^= Objects.hashCode(this.itemId);
    }

    public static class Builder {
        private String customerId;
        private String merchantCenterId;
        private String channel;
        private String languageCode;
        private String feedLabel;
        private String itemId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getMerchantCenterId() {
            return this.merchantCenterId;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public String getFeedLabel() {
            return this.feedLabel;
        }

        public String getItemId() {
            return this.itemId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setMerchantCenterId(String merchantCenterId) {
            this.merchantCenterId = merchantCenterId;
            return this;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder setFeedLabel(String feedLabel) {
            this.feedLabel = feedLabel;
            return this;
        }

        public Builder setItemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        private Builder(ShoppingProductName shoppingProductName) {
            this.customerId = shoppingProductName.customerId;
            this.merchantCenterId = shoppingProductName.merchantCenterId;
            this.channel = shoppingProductName.channel;
            this.languageCode = shoppingProductName.languageCode;
            this.feedLabel = shoppingProductName.feedLabel;
            this.itemId = shoppingProductName.itemId;
        }

        public ShoppingProductName build() {
            return new ShoppingProductName(this);
        }
    }
}

