/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.ads.googleads.v21.enums.LinkedProductTypeEnum;
import com.google.ads.googleads.v21.resources.AdvertisingPartnerIdentifier;
import com.google.ads.googleads.v21.resources.AdvertisingPartnerIdentifierOrBuilder;
import com.google.ads.googleads.v21.resources.DataPartnerIdentifier;
import com.google.ads.googleads.v21.resources.DataPartnerIdentifierOrBuilder;
import com.google.ads.googleads.v21.resources.GoogleAdsIdentifier;
import com.google.ads.googleads.v21.resources.GoogleAdsIdentifierOrBuilder;
import com.google.ads.googleads.v21.resources.MerchantCenterIdentifier;
import com.google.ads.googleads.v21.resources.MerchantCenterIdentifierOrBuilder;
import com.google.ads.googleads.v21.resources.ProductLinkOrBuilder;
import com.google.ads.googleads.v21.resources.ProductLinkProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ProductLink
extends GeneratedMessageV3
implements ProductLinkOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int linkedProductCase_ = 0;
    private Object linkedProduct_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int PRODUCT_LINK_ID_FIELD_NUMBER = 2;
    private long productLinkId_ = 0L;
    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_ = 0;
    public static final int DATA_PARTNER_FIELD_NUMBER = 4;
    public static final int GOOGLE_ADS_FIELD_NUMBER = 5;
    public static final int MERCHANT_CENTER_FIELD_NUMBER = 12;
    public static final int ADVERTISING_PARTNER_FIELD_NUMBER = 13;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ProductLink DEFAULT_INSTANCE = new ProductLink();
    private static final Parser<ProductLink> PARSER = new AbstractParser<ProductLink>(){

        public ProductLink parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ProductLink.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ProductLink(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ProductLink() {
        this.resourceName_ = "";
        this.type_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ProductLink();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ProductLinkProto.internal_static_google_ads_googleads_v21_resources_ProductLink_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ProductLinkProto.internal_static_google_ads_googleads_v21_resources_ProductLink_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductLink.class, Builder.class);
    }

    @Override
    public LinkedProductCase getLinkedProductCase() {
        return LinkedProductCase.forNumber(this.linkedProductCase_);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasProductLinkId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public long getProductLinkId() {
        return this.productLinkId_;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public LinkedProductTypeEnum.LinkedProductType getType() {
        LinkedProductTypeEnum.LinkedProductType result = LinkedProductTypeEnum.LinkedProductType.forNumber(this.type_);
        return result == null ? LinkedProductTypeEnum.LinkedProductType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasDataPartner() {
        return this.linkedProductCase_ == 4;
    }

    @Override
    public DataPartnerIdentifier getDataPartner() {
        if (this.linkedProductCase_ == 4) {
            return (DataPartnerIdentifier)this.linkedProduct_;
        }
        return DataPartnerIdentifier.getDefaultInstance();
    }

    @Override
    public DataPartnerIdentifierOrBuilder getDataPartnerOrBuilder() {
        if (this.linkedProductCase_ == 4) {
            return (DataPartnerIdentifier)this.linkedProduct_;
        }
        return DataPartnerIdentifier.getDefaultInstance();
    }

    @Override
    public boolean hasGoogleAds() {
        return this.linkedProductCase_ == 5;
    }

    @Override
    public GoogleAdsIdentifier getGoogleAds() {
        if (this.linkedProductCase_ == 5) {
            return (GoogleAdsIdentifier)this.linkedProduct_;
        }
        return GoogleAdsIdentifier.getDefaultInstance();
    }

    @Override
    public GoogleAdsIdentifierOrBuilder getGoogleAdsOrBuilder() {
        if (this.linkedProductCase_ == 5) {
            return (GoogleAdsIdentifier)this.linkedProduct_;
        }
        return GoogleAdsIdentifier.getDefaultInstance();
    }

    @Override
    public boolean hasMerchantCenter() {
        return this.linkedProductCase_ == 12;
    }

    @Override
    public MerchantCenterIdentifier getMerchantCenter() {
        if (this.linkedProductCase_ == 12) {
            return (MerchantCenterIdentifier)this.linkedProduct_;
        }
        return MerchantCenterIdentifier.getDefaultInstance();
    }

    @Override
    public MerchantCenterIdentifierOrBuilder getMerchantCenterOrBuilder() {
        if (this.linkedProductCase_ == 12) {
            return (MerchantCenterIdentifier)this.linkedProduct_;
        }
        return MerchantCenterIdentifier.getDefaultInstance();
    }

    @Override
    public boolean hasAdvertisingPartner() {
        return this.linkedProductCase_ == 13;
    }

    @Override
    public AdvertisingPartnerIdentifier getAdvertisingPartner() {
        if (this.linkedProductCase_ == 13) {
            return (AdvertisingPartnerIdentifier)this.linkedProduct_;
        }
        return AdvertisingPartnerIdentifier.getDefaultInstance();
    }

    @Override
    public AdvertisingPartnerIdentifierOrBuilder getAdvertisingPartnerOrBuilder() {
        if (this.linkedProductCase_ == 13) {
            return (AdvertisingPartnerIdentifier)this.linkedProduct_;
        }
        return AdvertisingPartnerIdentifier.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt64(2, this.productLinkId_);
        }
        if (this.type_ != LinkedProductTypeEnum.LinkedProductType.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.type_);
        }
        if (this.linkedProductCase_ == 4) {
            output.writeMessage(4, (MessageLite)((DataPartnerIdentifier)this.linkedProduct_));
        }
        if (this.linkedProductCase_ == 5) {
            output.writeMessage(5, (MessageLite)((GoogleAdsIdentifier)this.linkedProduct_));
        }
        if (this.linkedProductCase_ == 12) {
            output.writeMessage(12, (MessageLite)((MerchantCenterIdentifier)this.linkedProduct_));
        }
        if (this.linkedProductCase_ == 13) {
            output.writeMessage(13, (MessageLite)((AdvertisingPartnerIdentifier)this.linkedProduct_));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)this.productLinkId_);
        }
        if (this.type_ != LinkedProductTypeEnum.LinkedProductType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.type_);
        }
        if (this.linkedProductCase_ == 4) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((DataPartnerIdentifier)this.linkedProduct_));
        }
        if (this.linkedProductCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((GoogleAdsIdentifier)this.linkedProduct_));
        }
        if (this.linkedProductCase_ == 12) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MerchantCenterIdentifier)this.linkedProduct_));
        }
        if (this.linkedProductCase_ == 13) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)((AdvertisingPartnerIdentifier)this.linkedProduct_));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProductLink)) {
            return super.equals(obj);
        }
        ProductLink other = (ProductLink)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasProductLinkId() != other.hasProductLinkId()) {
            return false;
        }
        if (this.hasProductLinkId() && this.getProductLinkId() != other.getProductLinkId()) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (!this.getLinkedProductCase().equals((Object)other.getLinkedProductCase())) {
            return false;
        }
        switch (this.linkedProductCase_) {
            case 4: {
                if (this.getDataPartner().equals(other.getDataPartner())) break;
                return false;
            }
            case 5: {
                if (this.getGoogleAds().equals(other.getGoogleAds())) break;
                return false;
            }
            case 12: {
                if (this.getMerchantCenter().equals(other.getMerchantCenter())) break;
                return false;
            }
            case 13: {
                if (this.getAdvertisingPartner().equals(other.getAdvertisingPartner())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ProductLink.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasProductLinkId()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)this.getProductLinkId());
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.type_;
        switch (this.linkedProductCase_) {
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getDataPartner().hashCode();
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getGoogleAds().hashCode();
                break;
            }
            case 12: {
                hash = 37 * hash + 12;
                hash = 53 * hash + this.getMerchantCenter().hashCode();
                break;
            }
            case 13: {
                hash = 37 * hash + 13;
                hash = 53 * hash + this.getAdvertisingPartner().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ProductLink parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ProductLink)PARSER.parseFrom(data);
    }

    public static ProductLink parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductLink)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductLink parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ProductLink)PARSER.parseFrom(data);
    }

    public static ProductLink parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductLink)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductLink parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ProductLink)PARSER.parseFrom(data);
    }

    public static ProductLink parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductLink)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductLink parseFrom(InputStream input) throws IOException {
        return (ProductLink)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ProductLink parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductLink)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ProductLink parseDelimitedFrom(InputStream input) throws IOException {
        return (ProductLink)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ProductLink parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductLink)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ProductLink parseFrom(CodedInputStream input) throws IOException {
        return (ProductLink)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ProductLink parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductLink)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ProductLink.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ProductLink prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ProductLink getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ProductLink> parser() {
        return PARSER;
    }

    public Parser<ProductLink> getParserForType() {
        return PARSER;
    }

    public ProductLink getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ProductLinkOrBuilder {
        private int linkedProductCase_ = 0;
        private Object linkedProduct_;
        private int bitField0_;
        private Object resourceName_ = "";
        private long productLinkId_;
        private int type_ = 0;
        private SingleFieldBuilderV3<DataPartnerIdentifier, DataPartnerIdentifier.Builder, DataPartnerIdentifierOrBuilder> dataPartnerBuilder_;
        private SingleFieldBuilderV3<GoogleAdsIdentifier, GoogleAdsIdentifier.Builder, GoogleAdsIdentifierOrBuilder> googleAdsBuilder_;
        private SingleFieldBuilderV3<MerchantCenterIdentifier, MerchantCenterIdentifier.Builder, MerchantCenterIdentifierOrBuilder> merchantCenterBuilder_;
        private SingleFieldBuilderV3<AdvertisingPartnerIdentifier, AdvertisingPartnerIdentifier.Builder, AdvertisingPartnerIdentifierOrBuilder> advertisingPartnerBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ProductLinkProto.internal_static_google_ads_googleads_v21_resources_ProductLink_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProductLinkProto.internal_static_google_ads_googleads_v21_resources_ProductLink_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductLink.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.productLinkId_ = 0L;
            this.type_ = 0;
            if (this.dataPartnerBuilder_ != null) {
                this.dataPartnerBuilder_.clear();
            }
            if (this.googleAdsBuilder_ != null) {
                this.googleAdsBuilder_.clear();
            }
            if (this.merchantCenterBuilder_ != null) {
                this.merchantCenterBuilder_.clear();
            }
            if (this.advertisingPartnerBuilder_ != null) {
                this.advertisingPartnerBuilder_.clear();
            }
            this.linkedProductCase_ = 0;
            this.linkedProduct_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ProductLinkProto.internal_static_google_ads_googleads_v21_resources_ProductLink_descriptor;
        }

        public ProductLink getDefaultInstanceForType() {
            return ProductLink.getDefaultInstance();
        }

        public ProductLink build() {
            ProductLink result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ProductLink buildPartial() {
            ProductLink result = new ProductLink(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartial0(ProductLink result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.productLinkId_ = this.productLinkId_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.type_ = this.type_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(ProductLink result) {
            result.linkedProductCase_ = this.linkedProductCase_;
            result.linkedProduct_ = this.linkedProduct_;
            if (this.linkedProductCase_ == 4 && this.dataPartnerBuilder_ != null) {
                result.linkedProduct_ = this.dataPartnerBuilder_.build();
            }
            if (this.linkedProductCase_ == 5 && this.googleAdsBuilder_ != null) {
                result.linkedProduct_ = this.googleAdsBuilder_.build();
            }
            if (this.linkedProductCase_ == 12 && this.merchantCenterBuilder_ != null) {
                result.linkedProduct_ = this.merchantCenterBuilder_.build();
            }
            if (this.linkedProductCase_ == 13 && this.advertisingPartnerBuilder_ != null) {
                result.linkedProduct_ = this.advertisingPartnerBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ProductLink) {
                return this.mergeFrom((ProductLink)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ProductLink other) {
            if (other == ProductLink.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasProductLinkId()) {
                this.setProductLinkId(other.getProductLinkId());
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            switch (other.getLinkedProductCase()) {
                case DATA_PARTNER: {
                    this.mergeDataPartner(other.getDataPartner());
                    break;
                }
                case GOOGLE_ADS: {
                    this.mergeGoogleAds(other.getGoogleAds());
                    break;
                }
                case MERCHANT_CENTER: {
                    this.mergeMerchantCenter(other.getMerchantCenter());
                    break;
                }
                case ADVERTISING_PARTNER: {
                    this.mergeAdvertisingPartner(other.getAdvertisingPartner());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 16: {
                            this.productLinkId_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block15;
                        }
                        case 24: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block15;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getDataPartnerFieldBuilder().getBuilder(), extensionRegistry);
                            this.linkedProductCase_ = 4;
                            continue block15;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getGoogleAdsFieldBuilder().getBuilder(), extensionRegistry);
                            this.linkedProductCase_ = 5;
                            continue block15;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getMerchantCenterFieldBuilder().getBuilder(), extensionRegistry);
                            this.linkedProductCase_ = 12;
                            continue block15;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getAdvertisingPartnerFieldBuilder().getBuilder(), extensionRegistry);
                            this.linkedProductCase_ = 13;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public LinkedProductCase getLinkedProductCase() {
            return LinkedProductCase.forNumber(this.linkedProductCase_);
        }

        public Builder clearLinkedProduct() {
            this.linkedProductCase_ = 0;
            this.linkedProduct_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = ProductLink.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ProductLink.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasProductLinkId() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public long getProductLinkId() {
            return this.productLinkId_;
        }

        public Builder setProductLinkId(long value) {
            this.productLinkId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearProductLinkId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.productLinkId_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public LinkedProductTypeEnum.LinkedProductType getType() {
            LinkedProductTypeEnum.LinkedProductType result = LinkedProductTypeEnum.LinkedProductType.forNumber(this.type_);
            return result == null ? LinkedProductTypeEnum.LinkedProductType.UNRECOGNIZED : result;
        }

        public Builder setType(LinkedProductTypeEnum.LinkedProductType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDataPartner() {
            return this.linkedProductCase_ == 4;
        }

        @Override
        public DataPartnerIdentifier getDataPartner() {
            if (this.dataPartnerBuilder_ == null) {
                if (this.linkedProductCase_ == 4) {
                    return (DataPartnerIdentifier)this.linkedProduct_;
                }
                return DataPartnerIdentifier.getDefaultInstance();
            }
            if (this.linkedProductCase_ == 4) {
                return (DataPartnerIdentifier)this.dataPartnerBuilder_.getMessage();
            }
            return DataPartnerIdentifier.getDefaultInstance();
        }

        public Builder setDataPartner(DataPartnerIdentifier value) {
            if (this.dataPartnerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.linkedProduct_ = value;
                this.onChanged();
            } else {
                this.dataPartnerBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 4;
            return this;
        }

        public Builder setDataPartner(DataPartnerIdentifier.Builder builderForValue) {
            if (this.dataPartnerBuilder_ == null) {
                this.linkedProduct_ = builderForValue.build();
                this.onChanged();
            } else {
                this.dataPartnerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.linkedProductCase_ = 4;
            return this;
        }

        public Builder mergeDataPartner(DataPartnerIdentifier value) {
            if (this.dataPartnerBuilder_ == null) {
                this.linkedProduct_ = this.linkedProductCase_ == 4 && this.linkedProduct_ != DataPartnerIdentifier.getDefaultInstance() ? DataPartnerIdentifier.newBuilder((DataPartnerIdentifier)this.linkedProduct_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.linkedProductCase_ == 4) {
                this.dataPartnerBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.dataPartnerBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 4;
            return this;
        }

        public Builder clearDataPartner() {
            if (this.dataPartnerBuilder_ == null) {
                if (this.linkedProductCase_ == 4) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                    this.onChanged();
                }
            } else {
                if (this.linkedProductCase_ == 4) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                }
                this.dataPartnerBuilder_.clear();
            }
            return this;
        }

        public DataPartnerIdentifier.Builder getDataPartnerBuilder() {
            return (DataPartnerIdentifier.Builder)this.getDataPartnerFieldBuilder().getBuilder();
        }

        @Override
        public DataPartnerIdentifierOrBuilder getDataPartnerOrBuilder() {
            if (this.linkedProductCase_ == 4 && this.dataPartnerBuilder_ != null) {
                return (DataPartnerIdentifierOrBuilder)this.dataPartnerBuilder_.getMessageOrBuilder();
            }
            if (this.linkedProductCase_ == 4) {
                return (DataPartnerIdentifier)this.linkedProduct_;
            }
            return DataPartnerIdentifier.getDefaultInstance();
        }

        private SingleFieldBuilderV3<DataPartnerIdentifier, DataPartnerIdentifier.Builder, DataPartnerIdentifierOrBuilder> getDataPartnerFieldBuilder() {
            if (this.dataPartnerBuilder_ == null) {
                if (this.linkedProductCase_ != 4) {
                    this.linkedProduct_ = DataPartnerIdentifier.getDefaultInstance();
                }
                this.dataPartnerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((DataPartnerIdentifier)this.linkedProduct_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.linkedProduct_ = null;
            }
            this.linkedProductCase_ = 4;
            this.onChanged();
            return this.dataPartnerBuilder_;
        }

        @Override
        public boolean hasGoogleAds() {
            return this.linkedProductCase_ == 5;
        }

        @Override
        public GoogleAdsIdentifier getGoogleAds() {
            if (this.googleAdsBuilder_ == null) {
                if (this.linkedProductCase_ == 5) {
                    return (GoogleAdsIdentifier)this.linkedProduct_;
                }
                return GoogleAdsIdentifier.getDefaultInstance();
            }
            if (this.linkedProductCase_ == 5) {
                return (GoogleAdsIdentifier)this.googleAdsBuilder_.getMessage();
            }
            return GoogleAdsIdentifier.getDefaultInstance();
        }

        public Builder setGoogleAds(GoogleAdsIdentifier value) {
            if (this.googleAdsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.linkedProduct_ = value;
                this.onChanged();
            } else {
                this.googleAdsBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 5;
            return this;
        }

        public Builder setGoogleAds(GoogleAdsIdentifier.Builder builderForValue) {
            if (this.googleAdsBuilder_ == null) {
                this.linkedProduct_ = builderForValue.build();
                this.onChanged();
            } else {
                this.googleAdsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.linkedProductCase_ = 5;
            return this;
        }

        public Builder mergeGoogleAds(GoogleAdsIdentifier value) {
            if (this.googleAdsBuilder_ == null) {
                this.linkedProduct_ = this.linkedProductCase_ == 5 && this.linkedProduct_ != GoogleAdsIdentifier.getDefaultInstance() ? GoogleAdsIdentifier.newBuilder((GoogleAdsIdentifier)this.linkedProduct_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.linkedProductCase_ == 5) {
                this.googleAdsBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.googleAdsBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 5;
            return this;
        }

        public Builder clearGoogleAds() {
            if (this.googleAdsBuilder_ == null) {
                if (this.linkedProductCase_ == 5) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                    this.onChanged();
                }
            } else {
                if (this.linkedProductCase_ == 5) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                }
                this.googleAdsBuilder_.clear();
            }
            return this;
        }

        public GoogleAdsIdentifier.Builder getGoogleAdsBuilder() {
            return (GoogleAdsIdentifier.Builder)this.getGoogleAdsFieldBuilder().getBuilder();
        }

        @Override
        public GoogleAdsIdentifierOrBuilder getGoogleAdsOrBuilder() {
            if (this.linkedProductCase_ == 5 && this.googleAdsBuilder_ != null) {
                return (GoogleAdsIdentifierOrBuilder)this.googleAdsBuilder_.getMessageOrBuilder();
            }
            if (this.linkedProductCase_ == 5) {
                return (GoogleAdsIdentifier)this.linkedProduct_;
            }
            return GoogleAdsIdentifier.getDefaultInstance();
        }

        private SingleFieldBuilderV3<GoogleAdsIdentifier, GoogleAdsIdentifier.Builder, GoogleAdsIdentifierOrBuilder> getGoogleAdsFieldBuilder() {
            if (this.googleAdsBuilder_ == null) {
                if (this.linkedProductCase_ != 5) {
                    this.linkedProduct_ = GoogleAdsIdentifier.getDefaultInstance();
                }
                this.googleAdsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((GoogleAdsIdentifier)this.linkedProduct_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.linkedProduct_ = null;
            }
            this.linkedProductCase_ = 5;
            this.onChanged();
            return this.googleAdsBuilder_;
        }

        @Override
        public boolean hasMerchantCenter() {
            return this.linkedProductCase_ == 12;
        }

        @Override
        public MerchantCenterIdentifier getMerchantCenter() {
            if (this.merchantCenterBuilder_ == null) {
                if (this.linkedProductCase_ == 12) {
                    return (MerchantCenterIdentifier)this.linkedProduct_;
                }
                return MerchantCenterIdentifier.getDefaultInstance();
            }
            if (this.linkedProductCase_ == 12) {
                return (MerchantCenterIdentifier)this.merchantCenterBuilder_.getMessage();
            }
            return MerchantCenterIdentifier.getDefaultInstance();
        }

        public Builder setMerchantCenter(MerchantCenterIdentifier value) {
            if (this.merchantCenterBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.linkedProduct_ = value;
                this.onChanged();
            } else {
                this.merchantCenterBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 12;
            return this;
        }

        public Builder setMerchantCenter(MerchantCenterIdentifier.Builder builderForValue) {
            if (this.merchantCenterBuilder_ == null) {
                this.linkedProduct_ = builderForValue.build();
                this.onChanged();
            } else {
                this.merchantCenterBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.linkedProductCase_ = 12;
            return this;
        }

        public Builder mergeMerchantCenter(MerchantCenterIdentifier value) {
            if (this.merchantCenterBuilder_ == null) {
                this.linkedProduct_ = this.linkedProductCase_ == 12 && this.linkedProduct_ != MerchantCenterIdentifier.getDefaultInstance() ? MerchantCenterIdentifier.newBuilder((MerchantCenterIdentifier)this.linkedProduct_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.linkedProductCase_ == 12) {
                this.merchantCenterBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.merchantCenterBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 12;
            return this;
        }

        public Builder clearMerchantCenter() {
            if (this.merchantCenterBuilder_ == null) {
                if (this.linkedProductCase_ == 12) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                    this.onChanged();
                }
            } else {
                if (this.linkedProductCase_ == 12) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                }
                this.merchantCenterBuilder_.clear();
            }
            return this;
        }

        public MerchantCenterIdentifier.Builder getMerchantCenterBuilder() {
            return (MerchantCenterIdentifier.Builder)this.getMerchantCenterFieldBuilder().getBuilder();
        }

        @Override
        public MerchantCenterIdentifierOrBuilder getMerchantCenterOrBuilder() {
            if (this.linkedProductCase_ == 12 && this.merchantCenterBuilder_ != null) {
                return (MerchantCenterIdentifierOrBuilder)this.merchantCenterBuilder_.getMessageOrBuilder();
            }
            if (this.linkedProductCase_ == 12) {
                return (MerchantCenterIdentifier)this.linkedProduct_;
            }
            return MerchantCenterIdentifier.getDefaultInstance();
        }

        private SingleFieldBuilderV3<MerchantCenterIdentifier, MerchantCenterIdentifier.Builder, MerchantCenterIdentifierOrBuilder> getMerchantCenterFieldBuilder() {
            if (this.merchantCenterBuilder_ == null) {
                if (this.linkedProductCase_ != 12) {
                    this.linkedProduct_ = MerchantCenterIdentifier.getDefaultInstance();
                }
                this.merchantCenterBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((MerchantCenterIdentifier)this.linkedProduct_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.linkedProduct_ = null;
            }
            this.linkedProductCase_ = 12;
            this.onChanged();
            return this.merchantCenterBuilder_;
        }

        @Override
        public boolean hasAdvertisingPartner() {
            return this.linkedProductCase_ == 13;
        }

        @Override
        public AdvertisingPartnerIdentifier getAdvertisingPartner() {
            if (this.advertisingPartnerBuilder_ == null) {
                if (this.linkedProductCase_ == 13) {
                    return (AdvertisingPartnerIdentifier)this.linkedProduct_;
                }
                return AdvertisingPartnerIdentifier.getDefaultInstance();
            }
            if (this.linkedProductCase_ == 13) {
                return (AdvertisingPartnerIdentifier)this.advertisingPartnerBuilder_.getMessage();
            }
            return AdvertisingPartnerIdentifier.getDefaultInstance();
        }

        public Builder setAdvertisingPartner(AdvertisingPartnerIdentifier value) {
            if (this.advertisingPartnerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.linkedProduct_ = value;
                this.onChanged();
            } else {
                this.advertisingPartnerBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 13;
            return this;
        }

        public Builder setAdvertisingPartner(AdvertisingPartnerIdentifier.Builder builderForValue) {
            if (this.advertisingPartnerBuilder_ == null) {
                this.linkedProduct_ = builderForValue.build();
                this.onChanged();
            } else {
                this.advertisingPartnerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.linkedProductCase_ = 13;
            return this;
        }

        public Builder mergeAdvertisingPartner(AdvertisingPartnerIdentifier value) {
            if (this.advertisingPartnerBuilder_ == null) {
                this.linkedProduct_ = this.linkedProductCase_ == 13 && this.linkedProduct_ != AdvertisingPartnerIdentifier.getDefaultInstance() ? AdvertisingPartnerIdentifier.newBuilder((AdvertisingPartnerIdentifier)this.linkedProduct_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.linkedProductCase_ == 13) {
                this.advertisingPartnerBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.advertisingPartnerBuilder_.setMessage((AbstractMessage)value);
            }
            this.linkedProductCase_ = 13;
            return this;
        }

        public Builder clearAdvertisingPartner() {
            if (this.advertisingPartnerBuilder_ == null) {
                if (this.linkedProductCase_ == 13) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                    this.onChanged();
                }
            } else {
                if (this.linkedProductCase_ == 13) {
                    this.linkedProductCase_ = 0;
                    this.linkedProduct_ = null;
                }
                this.advertisingPartnerBuilder_.clear();
            }
            return this;
        }

        public AdvertisingPartnerIdentifier.Builder getAdvertisingPartnerBuilder() {
            return (AdvertisingPartnerIdentifier.Builder)this.getAdvertisingPartnerFieldBuilder().getBuilder();
        }

        @Override
        public AdvertisingPartnerIdentifierOrBuilder getAdvertisingPartnerOrBuilder() {
            if (this.linkedProductCase_ == 13 && this.advertisingPartnerBuilder_ != null) {
                return (AdvertisingPartnerIdentifierOrBuilder)this.advertisingPartnerBuilder_.getMessageOrBuilder();
            }
            if (this.linkedProductCase_ == 13) {
                return (AdvertisingPartnerIdentifier)this.linkedProduct_;
            }
            return AdvertisingPartnerIdentifier.getDefaultInstance();
        }

        private SingleFieldBuilderV3<AdvertisingPartnerIdentifier, AdvertisingPartnerIdentifier.Builder, AdvertisingPartnerIdentifierOrBuilder> getAdvertisingPartnerFieldBuilder() {
            if (this.advertisingPartnerBuilder_ == null) {
                if (this.linkedProductCase_ != 13) {
                    this.linkedProduct_ = AdvertisingPartnerIdentifier.getDefaultInstance();
                }
                this.advertisingPartnerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((AdvertisingPartnerIdentifier)this.linkedProduct_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.linkedProduct_ = null;
            }
            this.linkedProductCase_ = 13;
            this.onChanged();
            return this.advertisingPartnerBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum LinkedProductCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        DATA_PARTNER(4),
        GOOGLE_ADS(5),
        MERCHANT_CENTER(12),
        ADVERTISING_PARTNER(13),
        LINKEDPRODUCT_NOT_SET(0);

        private final int value;

        private LinkedProductCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static LinkedProductCase valueOf(int value) {
            return LinkedProductCase.forNumber(value);
        }

        public static LinkedProductCase forNumber(int value) {
            switch (value) {
                case 4: {
                    return DATA_PARTNER;
                }
                case 5: {
                    return GOOGLE_ADS;
                }
                case 12: {
                    return MERCHANT_CENTER;
                }
                case 13: {
                    return ADVERTISING_PARTNER;
                }
                case 0: {
                    return LINKEDPRODUCT_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

