/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocationInterestViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/locationInterestViews/{campaign_id}~{ad_group_id}~{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String adGroupId;
    private final String criterionId;

    @Deprecated
    protected LocationInterestViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.adGroupId = null;
        this.criterionId = null;
    }

    private LocationInterestViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocationInterestViewName of(String customerId, String campaignId, String adGroupId, String criterionId) {
        return LocationInterestViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAdGroupId(adGroupId).setCriterionId(criterionId).build();
    }

    public static String format(String customerId, String campaignId, String adGroupId, String criterionId) {
        return LocationInterestViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAdGroupId(adGroupId).setCriterionId(criterionId).build().toString();
    }

    public static LocationInterestViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_CRITERION_ID.validatedMatch(formattedString, "LocationInterestViewName.parse: formattedString not in valid format");
        return LocationInterestViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("criterion_id"));
    }

    public static List<LocationInterestViewName> parseList(List<String> formattedStrings) {
        ArrayList<LocationInterestViewName> list = new ArrayList<LocationInterestViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationInterestViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationInterestViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationInterestViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocationInterestViewName locationInterestViewName = this;
            synchronized (locationInterestViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_CRITERION_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "ad_group_id", this.adGroupId, "criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LocationInterestViewName that = (LocationInterestViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String adGroupId;
        private String criterionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(LocationInterestViewName locationInterestViewName) {
            this.customerId = locationInterestViewName.customerId;
            this.campaignId = locationInterestViewName.campaignId;
            this.adGroupId = locationInterestViewName.adGroupId;
            this.criterionId = locationInterestViewName.criterionId;
        }

        public LocationInterestViewName build() {
            return new LocationInterestViewName(this);
        }
    }
}

