// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v21/resources/offline_user_data_job.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v21.resources;

/**
 * <pre>
 * A job containing offline user data of store visitors, or user list members
 * that will be processed asynchronously. The uploaded data isn't readable and
 * the processing results of the job can only be read using
 * GoogleAdsService.Search/SearchStream.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v21.resources.OfflineUserDataJob}
 */
public final class OfflineUserDataJob extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v21.resources.OfflineUserDataJob)
    OfflineUserDataJobOrBuilder {
private static final long serialVersionUID = 0L;
  // Use OfflineUserDataJob.newBuilder() to construct.
  private OfflineUserDataJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private OfflineUserDataJob() {
    resourceName_ = "";
    type_ = 0;
    status_ = 0;
    failureReason_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new OfflineUserDataJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v21.resources.OfflineUserDataJobProto.internal_static_google_ads_googleads_v21_resources_OfflineUserDataJob_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v21.resources.OfflineUserDataJobProto.internal_static_google_ads_googleads_v21_resources_OfflineUserDataJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v21.resources.OfflineUserDataJob.class, com.google.ads.googleads.v21.resources.OfflineUserDataJob.Builder.class);
  }

  private int bitField0_;
  private int metadataCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object metadata_;
  public enum MetadataCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CUSTOMER_MATCH_USER_LIST_METADATA(7),
    STORE_SALES_METADATA(8),
    METADATA_NOT_SET(0);
    private final int value;
    private MetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 7: return CUSTOMER_MATCH_USER_LIST_METADATA;
        case 8: return STORE_SALES_METADATA;
        case 0: return METADATA_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase
  getMetadataCase() {
    return MetadataCase.forNumber(
        metadataCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the offline user data job.
   * Offline user data job resource names have the form:
   *
   * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the offline user data job.
   * Offline user data job resource names have the form:
   *
   * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 9;
  private long id_ = 0L;
  /**
   * <pre>
   * Output only. ID of this offline user data job.
   * </pre>
   *
   * <code>optional int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. ID of this offline user data job.
   * </pre>
   *
   * <code>optional int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int EXTERNAL_ID_FIELD_NUMBER = 10;
  private long externalId_ = 0L;
  /**
   * <pre>
   * Immutable. User specified job ID.
   * </pre>
   *
   * <code>optional int64 external_id = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the externalId field is set.
   */
  @java.lang.Override
  public boolean hasExternalId() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Immutable. User specified job ID.
   * </pre>
   *
   * <code>optional int64 external_id = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The externalId.
   */
  @java.lang.Override
  public long getExternalId() {
    return externalId_;
  }

  public static final int TYPE_FIELD_NUMBER = 4;
  private int type_ = 0;
  /**
   * <pre>
   * Immutable. Type of the job.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Immutable. Type of the job.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType getType() {
    com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType result = com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType.UNRECOGNIZED : result;
  }

  public static final int STATUS_FIELD_NUMBER = 5;
  private int status_ = 0;
  /**
   * <pre>
   * Output only. Status of the job.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. Status of the job.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus getStatus() {
    com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus result = com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus.UNRECOGNIZED : result;
  }

  public static final int FAILURE_REASON_FIELD_NUMBER = 6;
  private int failureReason_ = 0;
  /**
   * <pre>
   * Output only. Reason for the processing failure, if status is FAILED.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for failureReason.
   */
  @java.lang.Override public int getFailureReasonValue() {
    return failureReason_;
  }
  /**
   * <pre>
   * Output only. Reason for the processing failure, if status is FAILED.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The failureReason.
   */
  @java.lang.Override public com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason getFailureReason() {
    com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason result = com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason.forNumber(failureReason_);
    return result == null ? com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason.UNRECOGNIZED : result;
  }

  public static final int OPERATION_METADATA_FIELD_NUMBER = 11;
  private com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operationMetadata_;
  /**
   * <pre>
   * Output only. Metadata of offline user data job depicting match rate range.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the operationMetadata field is set.
   */
  @java.lang.Override
  public boolean hasOperationMetadata() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. Metadata of offline user data job depicting match rate range.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The operationMetadata.
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata getOperationMetadata() {
    return operationMetadata_ == null ? com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.getDefaultInstance() : operationMetadata_;
  }
  /**
   * <pre>
   * Output only. Metadata of offline user data job depicting match rate range.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadataOrBuilder getOperationMetadataOrBuilder() {
    return operationMetadata_ == null ? com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.getDefaultInstance() : operationMetadata_;
  }

  public static final int CUSTOMER_MATCH_USER_LIST_METADATA_FIELD_NUMBER = 7;
  /**
   * <pre>
   * Immutable. Metadata for data updates to a CRM-based user list.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the customerMatchUserListMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCustomerMatchUserListMetadata() {
    return metadataCase_ == 7;
  }
  /**
   * <pre>
   * Immutable. Metadata for data updates to a CRM-based user list.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The customerMatchUserListMetadata.
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata getCustomerMatchUserListMetadata() {
    if (metadataCase_ == 7) {
       return (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_;
    }
    return com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. Metadata for data updates to a CRM-based user list.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.CustomerMatchUserListMetadataOrBuilder getCustomerMatchUserListMetadataOrBuilder() {
    if (metadataCase_ == 7) {
       return (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_;
    }
    return com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance();
  }

  public static final int STORE_SALES_METADATA_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Immutable. Metadata for store sales data update.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the storeSalesMetadata field is set.
   */
  @java.lang.Override
  public boolean hasStoreSalesMetadata() {
    return metadataCase_ == 8;
  }
  /**
   * <pre>
   * Immutable. Metadata for store sales data update.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The storeSalesMetadata.
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.StoreSalesMetadata getStoreSalesMetadata() {
    if (metadataCase_ == 8) {
       return (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_;
    }
    return com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. Metadata for store sales data update.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.StoreSalesMetadataOrBuilder getStoreSalesMetadataOrBuilder() {
    if (metadataCase_ == 8) {
       return (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_;
    }
    return com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (type_ != com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, type_);
    }
    if (status_ != com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(5, status_);
    }
    if (failureReason_ != com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason.UNSPECIFIED.getNumber()) {
      output.writeEnum(6, failureReason_);
    }
    if (metadataCase_ == 7) {
      output.writeMessage(7, (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_);
    }
    if (metadataCase_ == 8) {
      output.writeMessage(8, (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(9, id_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(10, externalId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getOperationMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (type_ != com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, type_);
    }
    if (status_ != com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(5, status_);
    }
    if (failureReason_ != com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, failureReason_);
    }
    if (metadataCase_ == 7) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_);
    }
    if (metadataCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(9, id_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(10, externalId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, getOperationMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v21.resources.OfflineUserDataJob)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v21.resources.OfflineUserDataJob other = (com.google.ads.googleads.v21.resources.OfflineUserDataJob) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId()
          != other.getId()) return false;
    }
    if (hasExternalId() != other.hasExternalId()) return false;
    if (hasExternalId()) {
      if (getExternalId()
          != other.getExternalId()) return false;
    }
    if (type_ != other.type_) return false;
    if (status_ != other.status_) return false;
    if (failureReason_ != other.failureReason_) return false;
    if (hasOperationMetadata() != other.hasOperationMetadata()) return false;
    if (hasOperationMetadata()) {
      if (!getOperationMetadata()
          .equals(other.getOperationMetadata())) return false;
    }
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 7:
        if (!getCustomerMatchUserListMetadata()
            .equals(other.getCustomerMatchUserListMetadata())) return false;
        break;
      case 8:
        if (!getStoreSalesMetadata()
            .equals(other.getStoreSalesMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
    }
    if (hasExternalId()) {
      hash = (37 * hash) + EXTERNAL_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getExternalId());
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + failureReason_;
    if (hasOperationMetadata()) {
      hash = (37 * hash) + OPERATION_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getOperationMetadata().hashCode();
    }
    switch (metadataCase_) {
      case 7:
        hash = (37 * hash) + CUSTOMER_MATCH_USER_LIST_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerMatchUserListMetadata().hashCode();
        break;
      case 8:
        hash = (37 * hash) + STORE_SALES_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getStoreSalesMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v21.resources.OfflineUserDataJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A job containing offline user data of store visitors, or user list members
   * that will be processed asynchronously. The uploaded data isn't readable and
   * the processing results of the job can only be read using
   * GoogleAdsService.Search/SearchStream.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v21.resources.OfflineUserDataJob}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v21.resources.OfflineUserDataJob)
      com.google.ads.googleads.v21.resources.OfflineUserDataJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v21.resources.OfflineUserDataJobProto.internal_static_google_ads_googleads_v21_resources_OfflineUserDataJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v21.resources.OfflineUserDataJobProto.internal_static_google_ads_googleads_v21_resources_OfflineUserDataJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v21.resources.OfflineUserDataJob.class, com.google.ads.googleads.v21.resources.OfflineUserDataJob.Builder.class);
    }

    // Construct using com.google.ads.googleads.v21.resources.OfflineUserDataJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getOperationMetadataFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      id_ = 0L;
      externalId_ = 0L;
      type_ = 0;
      status_ = 0;
      failureReason_ = 0;
      operationMetadata_ = null;
      if (operationMetadataBuilder_ != null) {
        operationMetadataBuilder_.dispose();
        operationMetadataBuilder_ = null;
      }
      if (customerMatchUserListMetadataBuilder_ != null) {
        customerMatchUserListMetadataBuilder_.clear();
      }
      if (storeSalesMetadataBuilder_ != null) {
        storeSalesMetadataBuilder_.clear();
      }
      metadataCase_ = 0;
      metadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v21.resources.OfflineUserDataJobProto.internal_static_google_ads_googleads_v21_resources_OfflineUserDataJob_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v21.resources.OfflineUserDataJob getDefaultInstanceForType() {
      return com.google.ads.googleads.v21.resources.OfflineUserDataJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v21.resources.OfflineUserDataJob build() {
      com.google.ads.googleads.v21.resources.OfflineUserDataJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v21.resources.OfflineUserDataJob buildPartial() {
      com.google.ads.googleads.v21.resources.OfflineUserDataJob result = new com.google.ads.googleads.v21.resources.OfflineUserDataJob(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v21.resources.OfflineUserDataJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.externalId_ = externalId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.failureReason_ = failureReason_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.operationMetadata_ = operationMetadataBuilder_ == null
            ? operationMetadata_
            : operationMetadataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.ads.googleads.v21.resources.OfflineUserDataJob result) {
      result.metadataCase_ = metadataCase_;
      result.metadata_ = this.metadata_;
      if (metadataCase_ == 7 &&
          customerMatchUserListMetadataBuilder_ != null) {
        result.metadata_ = customerMatchUserListMetadataBuilder_.build();
      }
      if (metadataCase_ == 8 &&
          storeSalesMetadataBuilder_ != null) {
        result.metadata_ = storeSalesMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v21.resources.OfflineUserDataJob) {
        return mergeFrom((com.google.ads.googleads.v21.resources.OfflineUserDataJob)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v21.resources.OfflineUserDataJob other) {
      if (other == com.google.ads.googleads.v21.resources.OfflineUserDataJob.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasExternalId()) {
        setExternalId(other.getExternalId());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.failureReason_ != 0) {
        setFailureReasonValue(other.getFailureReasonValue());
      }
      if (other.hasOperationMetadata()) {
        mergeOperationMetadata(other.getOperationMetadata());
      }
      switch (other.getMetadataCase()) {
        case CUSTOMER_MATCH_USER_LIST_METADATA: {
          mergeCustomerMatchUserListMetadata(other.getCustomerMatchUserListMetadata());
          break;
        }
        case STORE_SALES_METADATA: {
          mergeStoreSalesMetadata(other.getStoreSalesMetadata());
          break;
        }
        case METADATA_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 32: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 40: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000010;
              break;
            } // case 40
            case 48: {
              failureReason_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 48
            case 58: {
              input.readMessage(
                  getCustomerMatchUserListMetadataFieldBuilder().getBuilder(),
                  extensionRegistry);
              metadataCase_ = 7;
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  getStoreSalesMetadataFieldBuilder().getBuilder(),
                  extensionRegistry);
              metadataCase_ = 8;
              break;
            } // case 66
            case 72: {
              id_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 72
            case 80: {
              externalId_ = input.readInt64();
              bitField0_ |= 0x00000004;
              break;
            } // case 80
            case 90: {
              input.readMessage(
                  getOperationMetadataFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000040;
              break;
            } // case 90
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int metadataCase_ = 0;
    private java.lang.Object metadata_;
    public MetadataCase
        getMetadataCase() {
      return MetadataCase.forNumber(
          metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the offline user data job.
     * Offline user data job resource names have the form:
     *
     * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the offline user data job.
     * Offline user data job resource names have the form:
     *
     * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the offline user data job.
     * Offline user data job resource names have the form:
     *
     * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the offline user data job.
     * Offline user data job resource names have the form:
     *
     * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the offline user data job.
     * Offline user data job resource names have the form:
     *
     * `customers/{customer_id}/offlineUserDataJobs/{offline_user_data_job_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long id_ ;
    /**
     * <pre>
     * Output only. ID of this offline user data job.
     * </pre>
     *
     * <code>optional int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. ID of this offline user data job.
     * </pre>
     *
     * <code>optional int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     * <pre>
     * Output only. ID of this offline user data job.
     * </pre>
     *
     * <code>optional int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. ID of this offline user data job.
     * </pre>
     *
     * <code>optional int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      id_ = 0L;
      onChanged();
      return this;
    }

    private long externalId_ ;
    /**
     * <pre>
     * Immutable. User specified job ID.
     * </pre>
     *
     * <code>optional int64 external_id = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the externalId field is set.
     */
    @java.lang.Override
    public boolean hasExternalId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Immutable. User specified job ID.
     * </pre>
     *
     * <code>optional int64 external_id = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The externalId.
     */
    @java.lang.Override
    public long getExternalId() {
      return externalId_;
    }
    /**
     * <pre>
     * Immutable. User specified job ID.
     * </pre>
     *
     * <code>optional int64 external_id = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param value The externalId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalId(long value) {

      externalId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. User specified job ID.
     * </pre>
     *
     * <code>optional int64 external_id = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return This builder for chaining.
     */
    public Builder clearExternalId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      externalId_ = 0L;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Immutable. Type of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Immutable. Type of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Type of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType getType() {
      com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType result = com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Immutable. Type of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Type of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobTypeEnum.OfflineUserDataJobType type = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      type_ = 0;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. Status of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. Status of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Status of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus getStatus() {
      com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus result = com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Status of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Status of the job.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobStatusEnum.OfflineUserDataJobStatus status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000010);
      status_ = 0;
      onChanged();
      return this;
    }

    private int failureReason_ = 0;
    /**
     * <pre>
     * Output only. Reason for the processing failure, if status is FAILED.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for failureReason.
     */
    @java.lang.Override public int getFailureReasonValue() {
      return failureReason_;
    }
    /**
     * <pre>
     * Output only. Reason for the processing failure, if status is FAILED.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for failureReason to set.
     * @return This builder for chaining.
     */
    public Builder setFailureReasonValue(int value) {
      failureReason_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Reason for the processing failure, if status is FAILED.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The failureReason.
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason getFailureReason() {
      com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason result = com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason.forNumber(failureReason_);
      return result == null ? com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Reason for the processing failure, if status is FAILED.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The failureReason to set.
     * @return This builder for chaining.
     */
    public Builder setFailureReason(com.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      failureReason_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Reason for the processing failure, if status is FAILED.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.OfflineUserDataJobFailureReasonEnum.OfflineUserDataJobFailureReason failure_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearFailureReason() {
      bitField0_ = (bitField0_ & ~0x00000020);
      failureReason_ = 0;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operationMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata, com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.Builder, com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadataOrBuilder> operationMetadataBuilder_;
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the operationMetadata field is set.
     */
    public boolean hasOperationMetadata() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The operationMetadata.
     */
    public com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata getOperationMetadata() {
      if (operationMetadataBuilder_ == null) {
        return operationMetadata_ == null ? com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.getDefaultInstance() : operationMetadata_;
      } else {
        return operationMetadataBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setOperationMetadata(com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata value) {
      if (operationMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operationMetadata_ = value;
      } else {
        operationMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setOperationMetadata(
        com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.Builder builderForValue) {
      if (operationMetadataBuilder_ == null) {
        operationMetadata_ = builderForValue.build();
      } else {
        operationMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeOperationMetadata(com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata value) {
      if (operationMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0) &&
          operationMetadata_ != null &&
          operationMetadata_ != com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.getDefaultInstance()) {
          getOperationMetadataBuilder().mergeFrom(value);
        } else {
          operationMetadata_ = value;
        }
      } else {
        operationMetadataBuilder_.mergeFrom(value);
      }
      if (operationMetadata_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearOperationMetadata() {
      bitField0_ = (bitField0_ & ~0x00000040);
      operationMetadata_ = null;
      if (operationMetadataBuilder_ != null) {
        operationMetadataBuilder_.dispose();
        operationMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.Builder getOperationMetadataBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getOperationMetadataFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadataOrBuilder getOperationMetadataOrBuilder() {
      if (operationMetadataBuilder_ != null) {
        return operationMetadataBuilder_.getMessageOrBuilder();
      } else {
        return operationMetadata_ == null ?
            com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.getDefaultInstance() : operationMetadata_;
      }
    }
    /**
     * <pre>
     * Output only. Metadata of offline user data job depicting match rate range.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata operation_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata, com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.Builder, com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadataOrBuilder> 
        getOperationMetadataFieldBuilder() {
      if (operationMetadataBuilder_ == null) {
        operationMetadataBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata, com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadata.Builder, com.google.ads.googleads.v21.resources.OfflineUserDataJobMetadataOrBuilder>(
                getOperationMetadata(),
                getParentForChildren(),
                isClean());
        operationMetadata_ = null;
      }
      return operationMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata, com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.Builder, com.google.ads.googleads.v21.common.CustomerMatchUserListMetadataOrBuilder> customerMatchUserListMetadataBuilder_;
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the customerMatchUserListMetadata field is set.
     */
    @java.lang.Override
    public boolean hasCustomerMatchUserListMetadata() {
      return metadataCase_ == 7;
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The customerMatchUserListMetadata.
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata getCustomerMatchUserListMetadata() {
      if (customerMatchUserListMetadataBuilder_ == null) {
        if (metadataCase_ == 7) {
          return (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_;
        }
        return com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 7) {
          return customerMatchUserListMetadataBuilder_.getMessage();
        }
        return com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setCustomerMatchUserListMetadata(com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata value) {
      if (customerMatchUserListMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        customerMatchUserListMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setCustomerMatchUserListMetadata(
        com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.Builder builderForValue) {
      if (customerMatchUserListMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        customerMatchUserListMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeCustomerMatchUserListMetadata(com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata value) {
      if (customerMatchUserListMetadataBuilder_ == null) {
        if (metadataCase_ == 7 &&
            metadata_ != com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance()) {
          metadata_ = com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.newBuilder((com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_)
              .mergeFrom(value).buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 7) {
          customerMatchUserListMetadataBuilder_.mergeFrom(value);
        } else {
          customerMatchUserListMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearCustomerMatchUserListMetadata() {
      if (customerMatchUserListMetadataBuilder_ == null) {
        if (metadataCase_ == 7) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 7) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        customerMatchUserListMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.Builder getCustomerMatchUserListMetadataBuilder() {
      return getCustomerMatchUserListMetadataFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.common.CustomerMatchUserListMetadataOrBuilder getCustomerMatchUserListMetadataOrBuilder() {
      if ((metadataCase_ == 7) && (customerMatchUserListMetadataBuilder_ != null)) {
        return customerMatchUserListMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 7) {
          return (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_;
        }
        return com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Metadata for data updates to a CRM-based user list.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.CustomerMatchUserListMetadata customer_match_user_list_metadata = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata, com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.Builder, com.google.ads.googleads.v21.common.CustomerMatchUserListMetadataOrBuilder> 
        getCustomerMatchUserListMetadataFieldBuilder() {
      if (customerMatchUserListMetadataBuilder_ == null) {
        if (!(metadataCase_ == 7)) {
          metadata_ = com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.getDefaultInstance();
        }
        customerMatchUserListMetadataBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata, com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata.Builder, com.google.ads.googleads.v21.common.CustomerMatchUserListMetadataOrBuilder>(
                (com.google.ads.googleads.v21.common.CustomerMatchUserListMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 7;
      onChanged();
      return customerMatchUserListMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v21.common.StoreSalesMetadata, com.google.ads.googleads.v21.common.StoreSalesMetadata.Builder, com.google.ads.googleads.v21.common.StoreSalesMetadataOrBuilder> storeSalesMetadataBuilder_;
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the storeSalesMetadata field is set.
     */
    @java.lang.Override
    public boolean hasStoreSalesMetadata() {
      return metadataCase_ == 8;
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The storeSalesMetadata.
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.common.StoreSalesMetadata getStoreSalesMetadata() {
      if (storeSalesMetadataBuilder_ == null) {
        if (metadataCase_ == 8) {
          return (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_;
        }
        return com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 8) {
          return storeSalesMetadataBuilder_.getMessage();
        }
        return com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setStoreSalesMetadata(com.google.ads.googleads.v21.common.StoreSalesMetadata value) {
      if (storeSalesMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        storeSalesMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setStoreSalesMetadata(
        com.google.ads.googleads.v21.common.StoreSalesMetadata.Builder builderForValue) {
      if (storeSalesMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        storeSalesMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeStoreSalesMetadata(com.google.ads.googleads.v21.common.StoreSalesMetadata value) {
      if (storeSalesMetadataBuilder_ == null) {
        if (metadataCase_ == 8 &&
            metadata_ != com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance()) {
          metadata_ = com.google.ads.googleads.v21.common.StoreSalesMetadata.newBuilder((com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_)
              .mergeFrom(value).buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 8) {
          storeSalesMetadataBuilder_.mergeFrom(value);
        } else {
          storeSalesMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearStoreSalesMetadata() {
      if (storeSalesMetadataBuilder_ == null) {
        if (metadataCase_ == 8) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 8) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        storeSalesMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v21.common.StoreSalesMetadata.Builder getStoreSalesMetadataBuilder() {
      return getStoreSalesMetadataFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.common.StoreSalesMetadataOrBuilder getStoreSalesMetadataOrBuilder() {
      if ((metadataCase_ == 8) && (storeSalesMetadataBuilder_ != null)) {
        return storeSalesMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 8) {
          return (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_;
        }
        return com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Metadata for store sales data update.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.common.StoreSalesMetadata store_sales_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v21.common.StoreSalesMetadata, com.google.ads.googleads.v21.common.StoreSalesMetadata.Builder, com.google.ads.googleads.v21.common.StoreSalesMetadataOrBuilder> 
        getStoreSalesMetadataFieldBuilder() {
      if (storeSalesMetadataBuilder_ == null) {
        if (!(metadataCase_ == 8)) {
          metadata_ = com.google.ads.googleads.v21.common.StoreSalesMetadata.getDefaultInstance();
        }
        storeSalesMetadataBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v21.common.StoreSalesMetadata, com.google.ads.googleads.v21.common.StoreSalesMetadata.Builder, com.google.ads.googleads.v21.common.StoreSalesMetadataOrBuilder>(
                (com.google.ads.googleads.v21.common.StoreSalesMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 8;
      onChanged();
      return storeSalesMetadataBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v21.resources.OfflineUserDataJob)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v21.resources.OfflineUserDataJob)
  private static final com.google.ads.googleads.v21.resources.OfflineUserDataJob DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v21.resources.OfflineUserDataJob();
  }

  public static com.google.ads.googleads.v21.resources.OfflineUserDataJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OfflineUserDataJob>
      PARSER = new com.google.protobuf.AbstractParser<OfflineUserDataJob>() {
    @java.lang.Override
    public OfflineUserDataJob parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<OfflineUserDataJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OfflineUserDataJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v21.resources.OfflineUserDataJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

