// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v21/common/policy.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v21.common;

/**
 * <pre>
 * Policy finding attached to a resource (for example, alcohol policy associated
 * with a site that sells alcohol).
 *
 * Each PolicyTopicEntry has a topic that indicates the specific ads policy
 * the entry is about and a type to indicate the effect that the entry will have
 * on serving. It may optionally have one or more evidences that indicate the
 * reason for the finding. It may also optionally have one or more constraints
 * that provide details about how serving may be restricted.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v21.common.PolicyTopicEntry}
 */
public final class PolicyTopicEntry extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v21.common.PolicyTopicEntry)
    PolicyTopicEntryOrBuilder {
private static final long serialVersionUID = 0L;
  // Use PolicyTopicEntry.newBuilder() to construct.
  private PolicyTopicEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private PolicyTopicEntry() {
    topic_ = "";
    type_ = 0;
    evidences_ = java.util.Collections.emptyList();
    constraints_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new PolicyTopicEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v21.common.PolicyProto.internal_static_google_ads_googleads_v21_common_PolicyTopicEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v21.common.PolicyProto.internal_static_google_ads_googleads_v21_common_PolicyTopicEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v21.common.PolicyTopicEntry.class, com.google.ads.googleads.v21.common.PolicyTopicEntry.Builder.class);
  }

  private int bitField0_;
  public static final int TOPIC_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object topic_ = "";
  /**
   * <pre>
   * Policy topic this finding refers to. For example, "ALCOHOL",
   * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
   * policy topics is not fixed for a particular API version and may change
   * at any time.
   * </pre>
   *
   * <code>optional string topic = 5;</code>
   * @return Whether the topic field is set.
   */
  @java.lang.Override
  public boolean hasTopic() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Policy topic this finding refers to. For example, "ALCOHOL",
   * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
   * policy topics is not fixed for a particular API version and may change
   * at any time.
   * </pre>
   *
   * <code>optional string topic = 5;</code>
   * @return The topic.
   */
  @java.lang.Override
  public java.lang.String getTopic() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      topic_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Policy topic this finding refers to. For example, "ALCOHOL",
   * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
   * policy topics is not fixed for a particular API version and may change
   * at any time.
   * </pre>
   *
   * <code>optional string topic = 5;</code>
   * @return The bytes for topic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTopicBytes() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      topic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   * <pre>
   * Describes the negative or positive effect this policy will have on serving.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Describes the negative or positive effect this policy will have on serving.
   * </pre>
   *
   * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType getType() {
    com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType result = com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType.UNRECOGNIZED : result;
  }

  public static final int EVIDENCES_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v21.common.PolicyTopicEvidence> evidences_;
  /**
   * <pre>
   * Additional information that explains policy finding
   * (for example, the brand name for a trademark finding).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v21.common.PolicyTopicEvidence> getEvidencesList() {
    return evidences_;
  }
  /**
   * <pre>
   * Additional information that explains policy finding
   * (for example, the brand name for a trademark finding).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder> 
      getEvidencesOrBuilderList() {
    return evidences_;
  }
  /**
   * <pre>
   * Additional information that explains policy finding
   * (for example, the brand name for a trademark finding).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
   */
  @java.lang.Override
  public int getEvidencesCount() {
    return evidences_.size();
  }
  /**
   * <pre>
   * Additional information that explains policy finding
   * (for example, the brand name for a trademark finding).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.PolicyTopicEvidence getEvidences(int index) {
    return evidences_.get(index);
  }
  /**
   * <pre>
   * Additional information that explains policy finding
   * (for example, the brand name for a trademark finding).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder getEvidencesOrBuilder(
      int index) {
    return evidences_.get(index);
  }

  public static final int CONSTRAINTS_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v21.common.PolicyTopicConstraint> constraints_;
  /**
   * <pre>
   * Indicates how serving of this resource may be affected (for example, not
   * serving in a country).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v21.common.PolicyTopicConstraint> getConstraintsList() {
    return constraints_;
  }
  /**
   * <pre>
   * Indicates how serving of this resource may be affected (for example, not
   * serving in a country).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder> 
      getConstraintsOrBuilderList() {
    return constraints_;
  }
  /**
   * <pre>
   * Indicates how serving of this resource may be affected (for example, not
   * serving in a country).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public int getConstraintsCount() {
    return constraints_.size();
  }
  /**
   * <pre>
   * Indicates how serving of this resource may be affected (for example, not
   * serving in a country).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.PolicyTopicConstraint getConstraints(int index) {
    return constraints_.get(index);
  }
  /**
   * <pre>
   * Indicates how serving of this resource may be affected (for example, not
   * serving in a country).
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder getConstraintsOrBuilder(
      int index) {
    return constraints_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (type_ != com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType.UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    for (int i = 0; i < evidences_.size(); i++) {
      output.writeMessage(3, evidences_.get(i));
    }
    for (int i = 0; i < constraints_.size(); i++) {
      output.writeMessage(4, constraints_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, topic_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, type_);
    }
    for (int i = 0; i < evidences_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, evidences_.get(i));
    }
    for (int i = 0; i < constraints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, constraints_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, topic_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v21.common.PolicyTopicEntry)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v21.common.PolicyTopicEntry other = (com.google.ads.googleads.v21.common.PolicyTopicEntry) obj;

    if (hasTopic() != other.hasTopic()) return false;
    if (hasTopic()) {
      if (!getTopic()
          .equals(other.getTopic())) return false;
    }
    if (type_ != other.type_) return false;
    if (!getEvidencesList()
        .equals(other.getEvidencesList())) return false;
    if (!getConstraintsList()
        .equals(other.getConstraintsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTopic()) {
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getEvidencesCount() > 0) {
      hash = (37 * hash) + EVIDENCES_FIELD_NUMBER;
      hash = (53 * hash) + getEvidencesList().hashCode();
    }
    if (getConstraintsCount() > 0) {
      hash = (37 * hash) + CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConstraintsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v21.common.PolicyTopicEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v21.common.PolicyTopicEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Policy finding attached to a resource (for example, alcohol policy associated
   * with a site that sells alcohol).
   *
   * Each PolicyTopicEntry has a topic that indicates the specific ads policy
   * the entry is about and a type to indicate the effect that the entry will have
   * on serving. It may optionally have one or more evidences that indicate the
   * reason for the finding. It may also optionally have one or more constraints
   * that provide details about how serving may be restricted.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v21.common.PolicyTopicEntry}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v21.common.PolicyTopicEntry)
      com.google.ads.googleads.v21.common.PolicyTopicEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v21.common.PolicyProto.internal_static_google_ads_googleads_v21_common_PolicyTopicEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v21.common.PolicyProto.internal_static_google_ads_googleads_v21_common_PolicyTopicEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v21.common.PolicyTopicEntry.class, com.google.ads.googleads.v21.common.PolicyTopicEntry.Builder.class);
    }

    // Construct using com.google.ads.googleads.v21.common.PolicyTopicEntry.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      topic_ = "";
      type_ = 0;
      if (evidencesBuilder_ == null) {
        evidences_ = java.util.Collections.emptyList();
      } else {
        evidences_ = null;
        evidencesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (constraintsBuilder_ == null) {
        constraints_ = java.util.Collections.emptyList();
      } else {
        constraints_ = null;
        constraintsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v21.common.PolicyProto.internal_static_google_ads_googleads_v21_common_PolicyTopicEntry_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v21.common.PolicyTopicEntry getDefaultInstanceForType() {
      return com.google.ads.googleads.v21.common.PolicyTopicEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v21.common.PolicyTopicEntry build() {
      com.google.ads.googleads.v21.common.PolicyTopicEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v21.common.PolicyTopicEntry buildPartial() {
      com.google.ads.googleads.v21.common.PolicyTopicEntry result = new com.google.ads.googleads.v21.common.PolicyTopicEntry(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v21.common.PolicyTopicEntry result) {
      if (evidencesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          evidences_ = java.util.Collections.unmodifiableList(evidences_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.evidences_ = evidences_;
      } else {
        result.evidences_ = evidencesBuilder_.build();
      }
      if (constraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          constraints_ = java.util.Collections.unmodifiableList(constraints_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.constraints_ = constraints_;
      } else {
        result.constraints_ = constraintsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v21.common.PolicyTopicEntry result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.topic_ = topic_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v21.common.PolicyTopicEntry) {
        return mergeFrom((com.google.ads.googleads.v21.common.PolicyTopicEntry)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v21.common.PolicyTopicEntry other) {
      if (other == com.google.ads.googleads.v21.common.PolicyTopicEntry.getDefaultInstance()) return this;
      if (other.hasTopic()) {
        topic_ = other.topic_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (evidencesBuilder_ == null) {
        if (!other.evidences_.isEmpty()) {
          if (evidences_.isEmpty()) {
            evidences_ = other.evidences_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEvidencesIsMutable();
            evidences_.addAll(other.evidences_);
          }
          onChanged();
        }
      } else {
        if (!other.evidences_.isEmpty()) {
          if (evidencesBuilder_.isEmpty()) {
            evidencesBuilder_.dispose();
            evidencesBuilder_ = null;
            evidences_ = other.evidences_;
            bitField0_ = (bitField0_ & ~0x00000004);
            evidencesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getEvidencesFieldBuilder() : null;
          } else {
            evidencesBuilder_.addAllMessages(other.evidences_);
          }
        }
      }
      if (constraintsBuilder_ == null) {
        if (!other.constraints_.isEmpty()) {
          if (constraints_.isEmpty()) {
            constraints_ = other.constraints_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureConstraintsIsMutable();
            constraints_.addAll(other.constraints_);
          }
          onChanged();
        }
      } else {
        if (!other.constraints_.isEmpty()) {
          if (constraintsBuilder_.isEmpty()) {
            constraintsBuilder_.dispose();
            constraintsBuilder_ = null;
            constraints_ = other.constraints_;
            bitField0_ = (bitField0_ & ~0x00000008);
            constraintsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getConstraintsFieldBuilder() : null;
          } else {
            constraintsBuilder_.addAllMessages(other.constraints_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 16: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 26: {
              com.google.ads.googleads.v21.common.PolicyTopicEvidence m =
                  input.readMessage(
                      com.google.ads.googleads.v21.common.PolicyTopicEvidence.parser(),
                      extensionRegistry);
              if (evidencesBuilder_ == null) {
                ensureEvidencesIsMutable();
                evidences_.add(m);
              } else {
                evidencesBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 34: {
              com.google.ads.googleads.v21.common.PolicyTopicConstraint m =
                  input.readMessage(
                      com.google.ads.googleads.v21.common.PolicyTopicConstraint.parser(),
                      extensionRegistry);
              if (constraintsBuilder_ == null) {
                ensureConstraintsIsMutable();
                constraints_.add(m);
              } else {
                constraintsBuilder_.addMessage(m);
              }
              break;
            } // case 34
            case 42: {
              topic_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 42
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object topic_ = "";
    /**
     * <pre>
     * Policy topic this finding refers to. For example, "ALCOHOL",
     * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
     * policy topics is not fixed for a particular API version and may change
     * at any time.
     * </pre>
     *
     * <code>optional string topic = 5;</code>
     * @return Whether the topic field is set.
     */
    public boolean hasTopic() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Policy topic this finding refers to. For example, "ALCOHOL",
     * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
     * policy topics is not fixed for a particular API version and may change
     * at any time.
     * </pre>
     *
     * <code>optional string topic = 5;</code>
     * @return The topic.
     */
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Policy topic this finding refers to. For example, "ALCOHOL",
     * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
     * policy topics is not fixed for a particular API version and may change
     * at any time.
     * </pre>
     *
     * <code>optional string topic = 5;</code>
     * @return The bytes for topic.
     */
    public com.google.protobuf.ByteString
        getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Policy topic this finding refers to. For example, "ALCOHOL",
     * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
     * policy topics is not fixed for a particular API version and may change
     * at any time.
     * </pre>
     *
     * <code>optional string topic = 5;</code>
     * @param value The topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopic(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      topic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Policy topic this finding refers to. For example, "ALCOHOL",
     * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
     * policy topics is not fixed for a particular API version and may change
     * at any time.
     * </pre>
     *
     * <code>optional string topic = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearTopic() {
      topic_ = getDefaultInstance().getTopic();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Policy topic this finding refers to. For example, "ALCOHOL",
     * "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
     * policy topics is not fixed for a particular API version and may change
     * at any time.
     * </pre>
     *
     * <code>optional string topic = 5;</code>
     * @param value The bytes for topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopicBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      topic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Describes the negative or positive effect this policy will have on serving.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Describes the negative or positive effect this policy will have on serving.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Describes the negative or positive effect this policy will have on serving.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType getType() {
      com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType result = com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Describes the negative or positive effect this policy will have on serving.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Describes the negative or positive effect this policy will have on serving.
     * </pre>
     *
     * <code>.google.ads.googleads.v21.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType type = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v21.common.PolicyTopicEvidence> evidences_ =
      java.util.Collections.emptyList();
    private void ensureEvidencesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        evidences_ = new java.util.ArrayList<com.google.ads.googleads.v21.common.PolicyTopicEvidence>(evidences_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v21.common.PolicyTopicEvidence, com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder, com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder> evidencesBuilder_;

    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public java.util.List<com.google.ads.googleads.v21.common.PolicyTopicEvidence> getEvidencesList() {
      if (evidencesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(evidences_);
      } else {
        return evidencesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public int getEvidencesCount() {
      if (evidencesBuilder_ == null) {
        return evidences_.size();
      } else {
        return evidencesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicEvidence getEvidences(int index) {
      if (evidencesBuilder_ == null) {
        return evidences_.get(index);
      } else {
        return evidencesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder setEvidences(
        int index, com.google.ads.googleads.v21.common.PolicyTopicEvidence value) {
      if (evidencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEvidencesIsMutable();
        evidences_.set(index, value);
        onChanged();
      } else {
        evidencesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder setEvidences(
        int index, com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder builderForValue) {
      if (evidencesBuilder_ == null) {
        ensureEvidencesIsMutable();
        evidences_.set(index, builderForValue.build());
        onChanged();
      } else {
        evidencesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder addEvidences(com.google.ads.googleads.v21.common.PolicyTopicEvidence value) {
      if (evidencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEvidencesIsMutable();
        evidences_.add(value);
        onChanged();
      } else {
        evidencesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder addEvidences(
        int index, com.google.ads.googleads.v21.common.PolicyTopicEvidence value) {
      if (evidencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEvidencesIsMutable();
        evidences_.add(index, value);
        onChanged();
      } else {
        evidencesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder addEvidences(
        com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder builderForValue) {
      if (evidencesBuilder_ == null) {
        ensureEvidencesIsMutable();
        evidences_.add(builderForValue.build());
        onChanged();
      } else {
        evidencesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder addEvidences(
        int index, com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder builderForValue) {
      if (evidencesBuilder_ == null) {
        ensureEvidencesIsMutable();
        evidences_.add(index, builderForValue.build());
        onChanged();
      } else {
        evidencesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder addAllEvidences(
        java.lang.Iterable<? extends com.google.ads.googleads.v21.common.PolicyTopicEvidence> values) {
      if (evidencesBuilder_ == null) {
        ensureEvidencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, evidences_);
        onChanged();
      } else {
        evidencesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder clearEvidences() {
      if (evidencesBuilder_ == null) {
        evidences_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        evidencesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public Builder removeEvidences(int index) {
      if (evidencesBuilder_ == null) {
        ensureEvidencesIsMutable();
        evidences_.remove(index);
        onChanged();
      } else {
        evidencesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder getEvidencesBuilder(
        int index) {
      return getEvidencesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder getEvidencesOrBuilder(
        int index) {
      if (evidencesBuilder_ == null) {
        return evidences_.get(index);  } else {
        return evidencesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder> 
         getEvidencesOrBuilderList() {
      if (evidencesBuilder_ != null) {
        return evidencesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(evidences_);
      }
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder addEvidencesBuilder() {
      return getEvidencesFieldBuilder().addBuilder(
          com.google.ads.googleads.v21.common.PolicyTopicEvidence.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder addEvidencesBuilder(
        int index) {
      return getEvidencesFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v21.common.PolicyTopicEvidence.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional information that explains policy finding
     * (for example, the brand name for a trademark finding).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicEvidence evidences = 3;</code>
     */
    public java.util.List<com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder> 
         getEvidencesBuilderList() {
      return getEvidencesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v21.common.PolicyTopicEvidence, com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder, com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder> 
        getEvidencesFieldBuilder() {
      if (evidencesBuilder_ == null) {
        evidencesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v21.common.PolicyTopicEvidence, com.google.ads.googleads.v21.common.PolicyTopicEvidence.Builder, com.google.ads.googleads.v21.common.PolicyTopicEvidenceOrBuilder>(
                evidences_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        evidences_ = null;
      }
      return evidencesBuilder_;
    }

    private java.util.List<com.google.ads.googleads.v21.common.PolicyTopicConstraint> constraints_ =
      java.util.Collections.emptyList();
    private void ensureConstraintsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        constraints_ = new java.util.ArrayList<com.google.ads.googleads.v21.common.PolicyTopicConstraint>(constraints_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v21.common.PolicyTopicConstraint, com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder, com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder> constraintsBuilder_;

    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public java.util.List<com.google.ads.googleads.v21.common.PolicyTopicConstraint> getConstraintsList() {
      if (constraintsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(constraints_);
      } else {
        return constraintsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public int getConstraintsCount() {
      if (constraintsBuilder_ == null) {
        return constraints_.size();
      } else {
        return constraintsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicConstraint getConstraints(int index) {
      if (constraintsBuilder_ == null) {
        return constraints_.get(index);
      } else {
        return constraintsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder setConstraints(
        int index, com.google.ads.googleads.v21.common.PolicyTopicConstraint value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintsIsMutable();
        constraints_.set(index, value);
        onChanged();
      } else {
        constraintsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder setConstraints(
        int index, com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.set(index, builderForValue.build());
        onChanged();
      } else {
        constraintsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder addConstraints(com.google.ads.googleads.v21.common.PolicyTopicConstraint value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintsIsMutable();
        constraints_.add(value);
        onChanged();
      } else {
        constraintsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder addConstraints(
        int index, com.google.ads.googleads.v21.common.PolicyTopicConstraint value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintsIsMutable();
        constraints_.add(index, value);
        onChanged();
      } else {
        constraintsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder addConstraints(
        com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.add(builderForValue.build());
        onChanged();
      } else {
        constraintsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder addConstraints(
        int index, com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.add(index, builderForValue.build());
        onChanged();
      } else {
        constraintsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder addAllConstraints(
        java.lang.Iterable<? extends com.google.ads.googleads.v21.common.PolicyTopicConstraint> values) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, constraints_);
        onChanged();
      } else {
        constraintsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder clearConstraints() {
      if (constraintsBuilder_ == null) {
        constraints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        constraintsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public Builder removeConstraints(int index) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.remove(index);
        onChanged();
      } else {
        constraintsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder getConstraintsBuilder(
        int index) {
      return getConstraintsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder getConstraintsOrBuilder(
        int index) {
      if (constraintsBuilder_ == null) {
        return constraints_.get(index);  } else {
        return constraintsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder> 
         getConstraintsOrBuilderList() {
      if (constraintsBuilder_ != null) {
        return constraintsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(constraints_);
      }
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder addConstraintsBuilder() {
      return getConstraintsFieldBuilder().addBuilder(
          com.google.ads.googleads.v21.common.PolicyTopicConstraint.getDefaultInstance());
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder addConstraintsBuilder(
        int index) {
      return getConstraintsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v21.common.PolicyTopicConstraint.getDefaultInstance());
    }
    /**
     * <pre>
     * Indicates how serving of this resource may be affected (for example, not
     * serving in a country).
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v21.common.PolicyTopicConstraint constraints = 4;</code>
     */
    public java.util.List<com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder> 
         getConstraintsBuilderList() {
      return getConstraintsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v21.common.PolicyTopicConstraint, com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder, com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder> 
        getConstraintsFieldBuilder() {
      if (constraintsBuilder_ == null) {
        constraintsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v21.common.PolicyTopicConstraint, com.google.ads.googleads.v21.common.PolicyTopicConstraint.Builder, com.google.ads.googleads.v21.common.PolicyTopicConstraintOrBuilder>(
                constraints_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        constraints_ = null;
      }
      return constraintsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v21.common.PolicyTopicEntry)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v21.common.PolicyTopicEntry)
  private static final com.google.ads.googleads.v21.common.PolicyTopicEntry DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v21.common.PolicyTopicEntry();
  }

  public static com.google.ads.googleads.v21.common.PolicyTopicEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PolicyTopicEntry>
      PARSER = new com.google.protobuf.AbstractParser<PolicyTopicEntry>() {
    @java.lang.Override
    public PolicyTopicEntry parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<PolicyTopicEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PolicyTopicEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v21.common.PolicyTopicEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

