/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.axis.utils.v201905;

import com.google.api.ads.admanager.axis.utils.v201905.Pql;
import com.google.api.ads.admanager.axis.v201905.Statement;
import com.google.api.ads.admanager.axis.v201905.String_ValueMapEntry;
import com.google.api.ads.admanager.axis.v201905.Value;
import com.google.api.ads.admanager.lib.utils.QueryBuilder;
import com.google.api.ads.admanager.lib.utils.QueryBuilderInterface;
import com.google.api.ads.common.lib.utils.Maps;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;

public final class StatementBuilder {
    public static final int SUGGESTED_PAGE_LIMIT = 500;
    private final QueryBuilderInterface<Value> queryBuilder;

    public StatementBuilder() {
        this((QueryBuilderInterface<Value>)new QueryBuilder());
    }

    @VisibleForTesting
    StatementBuilder(QueryBuilderInterface<Value> queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public StatementBuilder withBindVariableValue(String key, Object value) {
        return this.withBindVariableValue(key, Pql.createValue(value));
    }

    public StatementBuilder withBindVariableValue(String key, Value value) {
        this.queryBuilder.withBindVariableValue(key, (Object)value);
        return this;
    }

    public Statement toStatement() {
        Statement statement = new Statement();
        statement.setQuery(this.queryBuilder.buildQuery());
        statement.setValues(Maps.toList((Map)this.queryBuilder.getBindVariableMap(), String_ValueMapEntry.class).toArray(new String_ValueMapEntry[0]));
        return statement;
    }

    public StatementBuilder select(String columns) {
        this.queryBuilder.select(columns);
        return this;
    }

    public StatementBuilder from(String table) {
        this.queryBuilder.from(table);
        return this;
    }

    public StatementBuilder where(String conditions) {
        this.queryBuilder.where(conditions);
        return this;
    }

    public StatementBuilder limit(Integer count) {
        this.queryBuilder.limit(count);
        return this;
    }

    public StatementBuilder offset(Integer count) {
        this.queryBuilder.offset(count);
        return this;
    }

    public StatementBuilder increaseOffsetBy(Integer amount) {
        this.queryBuilder.increaseOffsetBy(amount);
        return this;
    }

    public Integer getOffset() {
        return this.queryBuilder.getOffset();
    }

    public StatementBuilder removeLimitAndOffset() {
        this.queryBuilder.removeLimitAndOffset();
        return this;
    }

    public StatementBuilder orderBy(String orderBy) {
        this.queryBuilder.orderBy(orderBy);
        return this;
    }

    public Map<String, Value> getBindVariableMap() {
        return this.queryBuilder.getBindVariableMap();
    }

    public String buildQuery() {
        return this.queryBuilder.buildQuery();
    }
}

