/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.axis.AxisHandler;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.api.ads.dfp.lib.soap.DfpHttpHeaderHandler;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.apache.axis.client.Stub;
import org.apache.commons.beanutils.BeanUtils;

public class DfpAxisHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private final AxisHandler soapClientHandler;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final DfpHttpHeaderHandler dfpHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;
    private final AdsLibConfiguration adsLibConfiguration;

    @Inject
    public DfpAxisHeaderHandler(AxisHandler soapClientHandler, DfpApiConfiguration dfpApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, DfpHttpHeaderHandler dfpHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.dfpHttpHeaderHandler = dfpHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            Preconditions.checkArgument((boolean)(soapClient instanceof Stub), (String)"soapClient must be Stub but was: %s", (Object)soapClient);
            Stub stub = (Stub)soapClient;
            this.dfpHttpHeaderHandler.setHttpHeaders(soapClient, dfpSession);
            Object soapHeader = this.createSoapHeader(dfpServiceDescriptor);
            BeanUtils.setProperty((Object)soapHeader, (String)"applicationName", (Object)this.userAgentCombiner.getUserAgent(dfpSession.getApplicationName()));
            if (dfpSession.getNetworkCode() != null) {
                BeanUtils.setProperty((Object)soapHeader, (String)"networkCode", (Object)dfpSession.getNetworkCode());
            }
            this.setAuthenticationHeaders(soapClient, dfpSession);
            String namespace = this.dfpApiConfiguration.getNamespacePrefix() + "/" + dfpServiceDescriptor.getVersion();
            this.soapClientHandler.setHeader(stub, namespace, "RequestHeader", soapHeader);
            this.soapClientHandler.setCompression(stub, this.adsLibConfiguration.isCompressionEnabled());
            this.soapClientHandler.setRequestTimeout(stub, this.adsLibConfiguration.getSoapRequestTimeout());
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }

    private void setAuthenticationHeaders(Object soapClient, DfpSession dfpSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)dfpSession);
    }

    private Object createSoapHeader(DfpServiceDescriptor adsServiceDescriptor) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(adsServiceDescriptor.getInterfaceClass().getPackage().getName() + ".SoapRequestHeader").newInstance();
    }
}

