/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.jaxws;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.api.ads.dfp.lib.soap.DfpHttpHeaderHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public class DfpJaxWsHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final AdsLibConfiguration adsLibConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final DfpHttpHeaderHandler dfpHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public DfpJaxWsHeaderHandler(SoapClientHandlerInterface soapClientHandler, DfpApiConfiguration dfpApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, DfpHttpHeaderHandler dfpHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.dfpHttpHeaderHandler = dfpHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        this.dfpHttpHeaderHandler.setHttpHeaders(soapClient, dfpSession);
        Map<String, Object> headerData = this.readHeaderElements(dfpSession);
        this.setAuthenticationHeaders(soapClient, headerData, dfpSession);
        this.soapClientHandler.setHeader(soapClient, null, null, (Object)this.constructSoapHeader(headerData, dfpServiceDescriptor));
        this.soapClientHandler.setCompression(soapClient, this.adsLibConfiguration.isCompressionEnabled());
        this.soapClientHandler.setRequestTimeout(soapClient, this.adsLibConfiguration.getSoapRequestTimeout());
    }

    @VisibleForTesting
    void setAuthenticationHeaders(Object soapClient, Map<String, Object> headerElements, DfpSession dfpSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)dfpSession);
    }

    private Map<String, Object> readHeaderElements(DfpSession dfpSession) {
        LinkedHashMap mapToFill = Maps.newLinkedHashMap();
        mapToFill.put("networkCode", dfpSession.getNetworkCode());
        mapToFill.put("applicationName", this.userAgentCombiner.getUserAgent(dfpSession.getApplicationName()));
        return mapToFill;
    }

    private SOAPElement constructSoapHeader(Map<String, Object> headerData, DfpServiceDescriptor dfpServiceDescriptor) {
        String string = String.valueOf(this.dfpApiConfiguration.getNamespacePrefix());
        String string2 = String.valueOf(dfpServiceDescriptor.getVersion());
        String requestHeaderNamespace = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPElement requestHeader = soapFactory.createElement(REQUEST_HEADER_LOCAL_PART, "ns1", requestHeaderNamespace);
            for (String headerElementName : headerData.keySet()) {
                if (headerData.get(headerElementName) == null) continue;
                SOAPElement newElement = requestHeader.addChildElement(headerElementName, "ns1", requestHeaderNamespace);
                newElement.addTextNode(headerData.get(headerElementName).toString());
            }
            return requestHeader;
        }
        catch (SOAPException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }
}

