/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.xml.sax.InputSource;

public class AxisDeserializer {
    private static final String SOAP_START_BODY = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>";
    private static final String SOAP_END_BODY = "</soapenv:Body></soapenv:Envelope>";
    private static final String TAG_MUTATE_RESPONSE = "mutateResponse";
    private static final String TAG_RVAL = "rval";
    private static final String INDENT_AMOUNT = "4";

    public <ResultT> List<ResultT> deserializeBatchJobMutateResults(URL url, List<TypeMapping> serviceTypeMappings, Class<ResultT> resultClass, QName resultQName) throws Exception {
        return this.deserializeBatchJobMutateResults(url, serviceTypeMappings, resultClass, resultQName, 0, Integer.MAX_VALUE);
    }

    public <ResultT> List<ResultT> deserializeBatchJobMutateResults(URL url, List<TypeMapping> serviceTypeMappings, Class<ResultT> resultClass, QName resultQName, int startIndex, int numberResults) throws Exception {
        ArrayList results = Lists.newArrayList();
        InputStream wrappedStream = this.buildWrappedInputStream(url, startIndex, numberResults);
        MessageContext messageContext = new MessageContext((AxisEngine)new AxisClient());
        TypeMappingRegistryImpl typeMappingRegistry = new TypeMappingRegistryImpl(true);
        messageContext.setTypeMappingRegistry((TypeMappingRegistry)typeMappingRegistry);
        DeserializationContext deserializationContext = new DeserializationContext(new InputSource(wrappedStream), messageContext, "response");
        TypeMapping registryTypeMapping = typeMappingRegistry.getOrMakeTypeMapping(messageContext.getEncodingStyle());
        this.registerTypeMappings(registryTypeMapping, serviceTypeMappings);
        deserializationContext.parse();
        SOAPEnvelope envelope = deserializationContext.getEnvelope();
        SOAPBodyElement body = envelope.getFirstBody();
        Iterator iter = body.getChildElements();
        while (iter.hasNext()) {
            Object child = iter.next();
            MessageElement childElm = (MessageElement)child;
            Object mutateResult = childElm.getValueAsType(resultQName, resultClass);
            results.add(mutateResult);
        }
        return results;
    }

    private InputStream buildWrappedInputStream(URL url, int startIndex, int numberResults) throws IOException, XMLStreamException, TransformerException {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (Object)"startIndex must not be negative");
        Preconditions.checkArgument((numberResults > 0 ? 1 : 0) != 0, (Object)"numberResults must be positive");
        StringWriter stringWriter = new StringWriter();
        XMLEventReader xmlEventReader = XMLInputFactory.newFactory().createXMLEventReader(url.openStream());
        XMLEventWriter xmlEventWriter = XMLOutputFactory.newFactory().createXMLEventWriter(stringWriter);
        XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
        int index = 0;
        boolean included = false;
        while (xmlEventReader.hasNext()) {
            String name;
            XMLEvent event = xmlEventReader.nextEvent();
            if (event.isStartElement()) {
                name = ((StartElement)event).getName().getLocalPart();
                if (name.equals(TAG_MUTATE_RESPONSE)) {
                    xmlEventWriter.add(event);
                    continue;
                }
                if (name.equals(TAG_RVAL) && ++index > startIndex) {
                    included = true;
                }
            } else if (event.isEndElement()) {
                name = ((EndElement)event).getName().getLocalPart();
                if (name.equals(TAG_MUTATE_RESPONSE)) {
                    xmlEventWriter.add(event);
                    break;
                }
                if (included && name.equals(TAG_RVAL) && index == startIndex + numberResults) {
                    xmlEventWriter.add(event);
                    xmlEventWriter.add(xmlEventFactory.createEndElement("", "", TAG_MUTATE_RESPONSE));
                    break;
                }
            }
            if (!included) continue;
            xmlEventWriter.add(event);
        }
        xmlEventReader.close();
        xmlEventWriter.close();
        InputStream truncatedInputStream = ByteSource.wrap((byte[])stringWriter.toString().getBytes(StandardCharsets.UTF_8)).openStream();
        Transformer omitXmlDeclarationTransformer = TransformerFactory.newInstance().newTransformer();
        omitXmlDeclarationTransformer.setOutputProperty("indent", "yes");
        omitXmlDeclarationTransformer.setOutputProperty("omit-xml-declaration", "yes");
        omitXmlDeclarationTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENT_AMOUNT);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outputStream);
        StreamSource xmlSource = new StreamSource(truncatedInputStream);
        omitXmlDeclarationTransformer.transform(xmlSource, streamResult);
        return ByteSource.concat((ByteSource[])new ByteSource[]{ByteSource.wrap((byte[])SOAP_START_BODY.getBytes(StandardCharsets.UTF_8)), ByteSource.wrap((byte[])outputStream.toByteArray()), ByteSource.wrap((byte[])SOAP_END_BODY.getBytes(StandardCharsets.UTF_8))}).openStream();
    }

    private void registerTypeMappings(TypeMapping registryTypeMapping, List<TypeMapping> typeMappings) {
        Preconditions.checkNotNull((Object)registryTypeMapping, (Object)"Null registry type mapping");
        Preconditions.checkNotNull(typeMappings, (Object)"Null type mappings");
        Preconditions.checkArgument((!typeMappings.isEmpty() ? 1 : 0) != 0, (Object)"Empty type mappings");
        for (TypeMapping typeMapping : typeMappings) {
            for (Class mappingClass : typeMapping.getAllClasses()) {
                QName classQName = typeMapping.getTypeQName(mappingClass);
                DeserializerFactory deserializer = typeMapping.getDeserializer(mappingClass, classQName);
                if (deserializer == null || registryTypeMapping.isRegistered(mappingClass, classQName)) continue;
                registryTypeMapping.register(mappingClass, classQName, (SerializerFactory)((org.apache.axis.encoding.SerializerFactory)null), deserializer);
            }
        }
    }
}

