/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201708.shopping;

import com.google.api.ads.adwords.axis.utils.v201708.shopping.ProductPartitionNode;
import com.google.api.ads.adwords.axis.v201708.cm.AdGroupCriterion;
import com.google.api.ads.adwords.axis.v201708.cm.BidSource;
import com.google.api.ads.adwords.axis.v201708.cm.BiddableAdGroupCriterion;
import com.google.api.ads.adwords.axis.v201708.cm.BiddingStrategyConfiguration;
import com.google.api.ads.adwords.axis.v201708.cm.Bids;
import com.google.api.ads.adwords.axis.v201708.cm.CpcBid;
import com.google.api.ads.adwords.axis.v201708.cm.CustomParameter;
import com.google.api.ads.adwords.axis.v201708.cm.CustomParameters;
import com.google.api.ads.adwords.axis.v201708.cm.Money;
import com.google.api.ads.adwords.axis.v201708.cm.NegativeAdGroupCriterion;
import com.google.api.ads.adwords.axis.v201708.cm.ProductPartition;
import com.google.api.ads.adwords.axis.v201708.cm.ProductPartitionType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;

class ProductPartitionNodeAdapter {
    private ProductPartitionNodeAdapter() {
    }

    static AdGroupCriterion createCriterionForRemove(ProductPartitionNode node, long adGroupId) {
        Preconditions.checkNotNull((Object)node, (Object)"Null node");
        AdGroupCriterion adGroupCriterion = new AdGroupCriterion();
        adGroupCriterion.setAdGroupId(adGroupId);
        adGroupCriterion.setCriterion(new ProductPartition());
        adGroupCriterion.getCriterion().setId(node.getProductPartitionId());
        return adGroupCriterion;
    }

    static AdGroupCriterion createCriterionForAdd(ProductPartitionNode node, long adGroupId, BiddingStrategyConfiguration biddingConfig) {
        AdGroupCriterion adGroupCriterion;
        Preconditions.checkNotNull((Object)node, (Object)"Null node");
        Preconditions.checkNotNull((Object)biddingConfig, (Object)"Null bidding configuration");
        if (node.isExcludedUnit()) {
            adGroupCriterion = new NegativeAdGroupCriterion();
        } else if (node.isBiddableUnit()) {
            BiddableAdGroupCriterion biddableCriterion = new BiddableAdGroupCriterion();
            if (node.getBid() != null) {
                Money bidMoney = new Money();
                bidMoney.setMicroAmount(node.getBid());
                CpcBid cpcBid = new CpcBid();
                cpcBid.setBid(bidMoney);
                cpcBid.setCpcBidSource(BidSource.CRITERION);
                biddingConfig.setBids(new Bids[]{cpcBid});
                biddableCriterion.setBiddingStrategyConfiguration(biddingConfig);
            }
            if (node.getTrackingUrlTemplate() != null) {
                biddableCriterion.setTrackingUrlTemplate(node.getTrackingUrlTemplate());
            }
            biddableCriterion.setUrlCustomParameters(ProductPartitionNodeAdapter.createCustomParameters(node));
            adGroupCriterion = biddableCriterion;
        } else {
            adGroupCriterion = new BiddableAdGroupCriterion();
        }
        adGroupCriterion.setAdGroupId(adGroupId);
        ProductPartition partition = new ProductPartition();
        partition.setId(node.getProductPartitionId());
        if (node.getParent() != null) {
            partition.setParentCriterionId(node.getParent().getProductPartitionId());
        }
        partition.setCaseValue(node.getDimension());
        partition.setPartitionType(node.isUnit() ? ProductPartitionType.UNIT : ProductPartitionType.SUBDIVISION);
        adGroupCriterion.setCriterion(partition);
        return adGroupCriterion;
    }

    static AdGroupCriterion createCriterionForSetBiddableUnit(ProductPartitionNode node, long adGroupId, BiddingStrategyConfiguration biddingConfig) {
        Preconditions.checkNotNull((Object)node, (Object)"Null node");
        Preconditions.checkNotNull((Object)biddingConfig, (Object)"Null bidding configuration");
        Preconditions.checkArgument((boolean)node.isBiddableUnit(), (Object)"Node is not a biddable unit");
        BiddableAdGroupCriterion biddableCriterion = new BiddableAdGroupCriterion();
        biddableCriterion.setAdGroupId(adGroupId);
        ProductPartition partition = new ProductPartition();
        partition.setId(node.getProductPartitionId());
        if (node.getParent() != null) {
            partition.setParentCriterionId(node.getParent().getProductPartitionId());
        }
        partition.setCaseValue(node.getDimension());
        partition.setPartitionType(ProductPartitionType.UNIT);
        biddableCriterion.setCriterion(partition);
        if (node.getBid() != null) {
            Money bidMoney = new Money();
            bidMoney.setMicroAmount(node.getBid());
            CpcBid cpcBid = new CpcBid();
            cpcBid.setBid(bidMoney);
            biddingConfig.setBids(new Bids[]{cpcBid});
        } else {
            biddingConfig.setBids(new Bids[0]);
        }
        biddableCriterion.setBiddingStrategyConfiguration(biddingConfig);
        if (node.getTrackingUrlTemplate() != null) {
            biddableCriterion.setTrackingUrlTemplate(node.getTrackingUrlTemplate());
        }
        biddableCriterion.setUrlCustomParameters(ProductPartitionNodeAdapter.createCustomParameters(node));
        return biddableCriterion;
    }

    private static CustomParameters createCustomParameters(ProductPartitionNode node) {
        Preconditions.checkArgument((boolean)node.isBiddableUnit(), (Object)"Node is not a biddable unit. Custom parameters not supported.");
        CustomParameters customParameters = new CustomParameters();
        ArrayList<CustomParameter> parameters = new ArrayList<CustomParameter>();
        for (Map.Entry customParamEntry : node.getCustomParameters().entrySet()) {
            CustomParameter customParameter = new CustomParameter();
            customParameter.setKey((String)customParamEntry.getKey());
            customParameter.setValue((String)customParamEntry.getValue());
            parameters.add(customParameter);
        }
        customParameters.setParameters(parameters.toArray(new CustomParameter[0]));
        customParameters.setDoReplace(true);
        return customParameters;
    }
}

