/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.axis.AxisHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.axis.client.Stub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdWordsAxisExpressHeaderHandler
implements HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> {
    private final AxisHandler axisHandler;
    @VisibleForTesting
    static final String EXPRESS_BUSINESS_ID_LOCAL_PART = "expressBusinessId";

    @Inject
    public AdWordsAxisExpressHeaderHandler(AxisHandler axisHandler) {
        this.axisHandler = axisHandler;
    }

    public void setHeaders(Object soapClient, AdWordsSession adWordsSession, AdWordsServiceDescriptor adWordsServiceDescriptor) throws ServiceException, AuthenticationException {
        if (adWordsSession.getExpressBusinessId() != null) {
            Preconditions.checkArgument((boolean)(soapClient instanceof Stub), (String)"soapClient must be Stub but was: %s", (Object[])new Object[]{soapClient});
            Stub stub = (Stub)soapClient;
            this.axisHandler.setHeaderChild(stub, "RequestHeader", EXPRESS_BUSINESS_ID_LOCAL_PART, (Object)adWordsSession.getExpressBusinessId());
        }
    }
}

