/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201109;

import com.google.api.ads.adwords.axis.v201109.cm.ReportDefinition;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.auth.OAuthAuthorizationHeaderProvider;
import com.google.api.ads.common.lib.auth.OAuthCompatible;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.client.http.GenericUrl;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;

public final class ReportDownloader {
    private static final String DOWNLOAD_SERVER_URI = "/api/adwords/reportdownload";
    private static final String VERSION = "v201109";
    private static final String ERROR_MESSAGE_REGEX = "^.*!!![^|]*\\|\\|\\|([^|]*)\\|\\|\\|([^?]*)\\?\\?\\?.*$";
    private static final String REMOVE_ATTRIBUTES_REGEX = "( )?(xmlns|xsi):(\\w)+=\".*?\"|ns\\d:|<\\?xml.*?>";
    private static final String REMOVE_SELF_CLOSING_TAG = "<\\w+( )?/>";
    private static final String REPORT_BY_ID = "?__rd=%d";
    private static final int ERROR_MESSAGE_GROUP = 2;
    static final int REPORT_HEAD_LENGTH = 1024;
    private static final String REQUEST_METHOD = "POST";
    private static final String SUCCESS = "SUCCESS";
    private final OAuthAuthorizationHeaderProvider oAuthAuthorizationHeaderProvider = new OAuthAuthorizationHeaderProvider("POST");
    private final AdWordsSession session;

    public ReportDownloader(AdWordsSession session) {
        this.session = session;
    }

    @VisibleForTesting
    static void checkForException(String reportHead) throws ReportException {
        Matcher matcher = Pattern.compile(ERROR_MESSAGE_REGEX).matcher(reportHead);
        if (matcher.matches()) {
            throw new ReportException(matcher.group(2));
        }
    }

    public ReportDownloadResponse downloadReport(long reportDefinitionId) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(reportDefinitionId);
            HttpURLConnection conn = this.getReportHttpUrlConnection(downloadUrl);
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            int status = conn.getResponseCode();
            String responseMessage = SUCCESS;
            InputStream inputStream = null;
            if (status == 200) {
                inputStream = conn.getInputStream();
            } else {
                responseMessage = Streams.readAll((InputStream)conn.getErrorStream());
            }
            return new ReportDownloadResponse(status, responseMessage, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", (Throwable)e);
        }
    }

    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(null);
            HttpURLConnection conn = this.getReportHttpUrlConnection(downloadUrl);
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setRequestMethod(REQUEST_METHOD);
            conn.setDoOutput(true);
            this.writeReportToStream(conn.getOutputStream(), reportDefinition);
            int status = conn.getResponseCode();
            String responseMessage = SUCCESS;
            InputStream inputStream = null;
            if (status == 200) {
                inputStream = conn.getInputStream();
            } else {
                responseMessage = Streams.readAll((InputStream)conn.getErrorStream());
            }
            return new ReportDownloadResponse(status, responseMessage, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", (Throwable)e);
        }
    }

    @VisibleForTesting
    void writeReportToStream(OutputStream outputStream, ReportDefinition reportDefinition) throws UnsupportedEncodingException, IOException {
        String reportDefinitionXml = this.toXml(reportDefinition);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write("__rdxml=" + URLEncoder.encode(reportDefinitionXml, "UTF-8"));
        writer.close();
    }

    @VisibleForTesting
    String toXml(ReportDefinition reportDefinition) throws IOException {
        Serializer serializer = ReportDefinition.getSerializer("reportDefinition", ReportDefinition.class, ReportDefinition.getTypeDesc().getXmlType());
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext((Writer)writer);
        serializer.serialize(ReportDefinition.getTypeDesc().getXmlType(), null, (Object)reportDefinition, context);
        return this.sanitize(writer.toString());
    }

    @VisibleForTesting
    String sanitize(String string) {
        string = string.replaceAll(REMOVE_ATTRIBUTES_REGEX, "");
        string = string.replaceAll(REMOVE_SELF_CLOSING_TAG, "");
        string = string.replaceAll("ReportDefinition", "reportDefinition");
        return string;
    }

    @VisibleForTesting
    String generateReportUrl(Long reportDefinitionId) {
        String url = String.valueOf(this.session.getEndpoint()) + DOWNLOAD_SERVER_URI + '/' + VERSION;
        if (reportDefinitionId != null) {
            url = String.valueOf(url) + String.format(REPORT_BY_ID, reportDefinitionId);
        }
        return url;
    }

    @VisibleForTesting
    HttpURLConnection getReportHttpUrlConnection(String reportUrl) throws MalformedURLException, IOException, ReportException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(reportUrl).openConnection();
        httpUrlConnection.setRequestMethod(REQUEST_METHOD);
        if (this.session.getClientLoginToken() != null) {
            httpUrlConnection.setRequestProperty("Authorization", "GoogleLogin auth=" + this.session.getClientLoginToken());
        } else if (this.session.getOAuthParameters() != null) {
            try {
                String authorizationHeader = this.oAuthAuthorizationHeaderProvider.getOAuthAuthorizationHeader((OAuthCompatible)this.session, new GenericUrl(reportUrl));
                httpUrlConnection.setRequestProperty("Authorization", authorizationHeader);
            }
            catch (OAuthException e) {
                throw new ReportException("Could not set OAuth header", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Either ClientLoginToken or OAuth header must be provided.");
        }
        httpUrlConnection.setRequestProperty("developerToken", this.session.getDeveloperToken());
        httpUrlConnection.setRequestProperty("clientCustomerId", this.session.getClientCustomerId());
        httpUrlConnection.setRequestProperty("returnMoneyInMicros", Boolean.toString(this.session.isReportMoneyInMicros()));
        httpUrlConnection.setInstanceFollowRedirects(false);
        return httpUrlConnection;
    }
}

