/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.api.ads.common.lib.utils.AdsUtility;
import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@Singleton
@ThreadSafe
public final class AdsUtilityRegistry {
    private volatile Set<AdsUtility> adsUtilities = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final AdsUtilityRegistry INSTANCE = new AdsUtilityRegistry();

    public static AdsUtilityRegistry getInstance() {
        return INSTANCE;
    }

    private AdsUtilityRegistry() {
    }

    public void addUtility(AdsUtility adsUtility) {
        Preconditions.checkNotNull((Object)((Object)adsUtility), (Object)"Null ads utility");
        this.adsUtilities.add(adsUtility);
    }

    public Set<AdsUtility> popRegisteredUtilities() {
        Set<AdsUtility> result = Collections.unmodifiableSet(this.adsUtilities);
        this.adsUtilities = Collections.newSetFromMap(new ConcurrentHashMap());
        return result;
    }
}

