/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxb;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.lang.SerializationException;

public class JaxBSerializer<T> {
    private final Class<T> clazz;
    private final QName qname;
    private final JAXBContext jaxbContext;

    public JaxBSerializer(Class<T> clazz, QName qname) {
        this.clazz = clazz;
        this.qname = qname;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            throw new SerializationException(String.format("Could not construct a serializer for class %s and QName %s.", clazz, qname), (Throwable)e);
        }
    }

    public String serialize(T object) {
        return this.serialize(object, true);
    }

    public String serialize(T object, boolean includeXmlDeclaration) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)(!includeXmlDeclaration ? 1 : 0));
            JAXBElement element = new JAXBElement(this.qname, this.clazz, object);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)element, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new SerializationException(String.format("Could not serialize object: %s.", object), (Throwable)e);
        }
    }
}

