/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.api.ads.common.lib.utils.AdsUtility;
import com.google.api.ads.common.lib.utils.AdsUtilityRegistry;
import com.google.api.ads.common.lib.utils.UsesAdsUtilities;
import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AdsUtilityInvocationHandler
extends AbstractInvocationHandler {
    private final AdsUtilityRegistry adsUtilityRegistry;
    private final Object objectToProxy;

    public AdsUtilityInvocationHandler(Object objectToProxy, AdsUtilityRegistry adsUtilityRegistry) {
        this.adsUtilityRegistry = adsUtilityRegistry;
        this.objectToProxy = objectToProxy;
    }

    public Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        UsesAdsUtilities utilityAnnotation = method.getAnnotation(UsesAdsUtilities.class);
        if (utilityAnnotation != null && utilityAnnotation.value() != null) {
            for (AdsUtility utility : utilityAnnotation.value()) {
                this.adsUtilityRegistry.addUtility(utility);
            }
        }
        try {
            return method.invoke(this.objectToProxy, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new RuntimeException("Method invocation failed", e);
        }
    }
}

