/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.lib.factory.helper;

import com.google.api.ads.admanager.lib.client.AdManagerServiceClient;
import com.google.api.ads.admanager.lib.client.AdManagerServiceDescriptor;
import com.google.api.ads.admanager.lib.client.AdManagerSession;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.factory.FactoryModule;
import com.google.api.ads.common.lib.factory.helper.BaseAdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class AdManagerServiceClientFactoryHelper
extends BaseAdsServiceClientFactoryHelper<AdManagerServiceClient, AdManagerSession, AdManagerServiceDescriptor> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^.*(v[0-9][^\\.]*).*$");
    private final AdsLibConfiguration adsLibConfiguration;

    @Inject
    public AdManagerServiceClientFactoryHelper(FactoryModule.AdsServiceClientFactoryInterface<AdManagerServiceClient, AdManagerSession, AdManagerServiceDescriptor> adsServiceClientFactory, FactoryModule.AdsServiceDescriptorFactoryInterface<AdManagerServiceDescriptor> adsServiceDescriptorFactory, SoapClientHandlerInterface soapClientHandler, AdsLibConfiguration adsLibConfiguration) {
        super(adsServiceClientFactory, adsServiceDescriptorFactory, soapClientHandler);
        this.adsLibConfiguration = adsLibConfiguration;
    }

    @Override
    public String determineVersion(Class<?> interfaceClass) {
        Matcher m = VERSION_PATTERN.matcher(interfaceClass.getPackage().getName());
        if (m.matches()) {
            String version = m.group(1);
            return version.replace('_', '.');
        }
        return this.adsLibConfiguration.getDuckTypedVersion();
    }
}

