/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeExtractor {
    public String extractNodeValue(@Nullable Node parentNode, Iterable<String> xPath) {
        Node node = this.extractNode(parentNode, xPath);
        if (node == null || node.getFirstChild() == null) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public Node extractNode(@Nullable Node parentNode, Iterable<String> xPath) {
        Preconditions.checkNotNull(xPath, (Object)"Null xpath list");
        Node node = parentNode;
        boolean wasMatch = false;
        Iterator<String> xPathElementsIter = xPath.iterator();
        block0: while (xPathElementsIter.hasNext() && node != null) {
            wasMatch = false;
            String localName = xPathElementsIter.next();
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null || childName.contains(":")) {
                    childName = childNode.getNodeName();
                }
                if (!localName.equals(childName)) continue;
                node = childNode;
                wasMatch = true;
                continue block0;
            }
        }
        return wasMatch ? node : null;
    }
}

