/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.conf;

import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.inject.name.Named;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;

public class AdWordsLibConfiguration
extends AdsLibConfiguration {
    private static final String KEY_PREFIX = "api.adwords";
    private static final String REPORT_DOWNLOAD_TIMEOUT_KEY = "reportDownloadTimeout";
    private static final int DEFAULT_REPORT_DOWNLOAD_TIMEOUT = 180000;

    @Inject
    public AdWordsLibConfiguration(@Named(value="lib") Configuration config) {
        super(config);
    }

    @Override
    public boolean isAutoRefreshOAuth2TokenEnabled() {
        return this.config.getBoolean("api.adwords.refreshOAuth2Token", true);
    }

    public int getReportDownloadTimeout() {
        return this.config.getInt("api.adwords.reportDownloadTimeout", 180000);
    }

    @Override
    public boolean isCompressionEnabled() {
        return this.config.getBoolean("api.adwords.useCompression", false);
    }

    @Override
    public int getSoapRequestTimeout() {
        return this.config.getInt("api.adwords.soapRequestTimeout", 1200000);
    }

    @Override
    public boolean isIncludeAdsUtilitiesInUserAgent() {
        Boolean isInclude = this.config.getBoolean("api.adwords.includeUtilitiesInUserAgent", null);
        return isInclude != null ? isInclude.booleanValue() : super.isIncludeAdsUtilitiesInUserAgent();
    }
}

