/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.ads.adwords.lib.utils.logging.BatchJobLogger;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.Charsets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;

public class BatchJobUploader {
    private final AdWordsSession session;
    private final HttpTransport httpTransport;
    private final BatchJobLogger batchJobLogger;
    private static final Charset REQUEST_CHARSET = Charsets.UTF_8;
    @VisibleForTesting
    static final int REQUIRED_CONTENT_LENGTH_INCREMENT = 262144;

    public BatchJobUploader(AdWordsSession session) {
        this(session, AdWordsInternals.getInstance().getHttpTransport());
    }

    @VisibleForTesting
    BatchJobUploader(AdWordsSession session, HttpTransport httpTransport) {
        this.session = session;
        this.httpTransport = httpTransport;
        this.batchJobLogger = AdWordsInternals.getInstance().getAdWordsServiceLoggers().getBatchJobLogger();
    }

    private HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType("application/xml");
        headers.setUserAgent(this.session.getUserAgent());
        return headers;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BatchJobUploadResponse uploadIncrementalBatchJobOperations(BatchJobMutateRequestInterface request, final boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) throws BatchJobException {
        BatchJobUploadStatus effectiveStatus;
        Preconditions.checkNotNull((Object)batchJobUploadStatus, (Object)"Null batch job upload status");
        Preconditions.checkNotNull((Object)batchJobUploadStatus.getResumableUploadUri(), (Object)"No resumable session URI");
        if (batchJobUploadStatus.getTotalContentLength() == 0L) {
            URI uploadUri = this.initiateResumableUpload(batchJobUploadStatus.getResumableUploadUri());
            effectiveStatus = new BatchJobUploadStatus(0L, uploadUri);
        } else {
            effectiveStatus = batchJobUploadStatus;
        }
        ByteArrayContent content = request.createBatchJobUploadBodyProvider().getHttpContent(request, effectiveStatus.getTotalContentLength() == 0L, isLastRequest);
        try {
            content = this.postProcessContent(content, effectiveStatus.getTotalContentLength() == 0L, isLastRequest);
        }
        catch (IOException e) {
            throw new BatchJobException("Failed to post-process the request content", e);
        }
        String requestXml = null;
        Throwable exception = null;
        BatchJobUploadResponse batchJobUploadResponse = null;
        final long contentLength = content.getLength();
        try {
            HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) throws IOException {
                    HttpHeaders headers = BatchJobUploader.this.createHttpHeaders();
                    headers.setContentLength(Long.valueOf(contentLength));
                    headers.setContentRange(BatchJobUploader.this.constructContentRangeHeaderValue(contentLength, isLastRequest, effectiveStatus));
                    request.setHeaders(headers);
                    request.setLoggingEnabled(true);
                }
            });
            HttpRequest httpRequest = requestFactory.buildPutRequest(new GenericUrl(effectiveStatus.getResumableUploadUri()), (HttpContent)content);
            requestXml = Streams.readAll(content.getInputStream(), REQUEST_CHARSET);
            content.getInputStream().reset();
            HttpResponse response = httpRequest.execute();
            BatchJobUploadResponse batchJobUploadResponse2 = batchJobUploadResponse = new BatchJobUploadResponse(response, effectiveStatus.getTotalContentLength() + httpRequest.getContent().getLength(), effectiveStatus.getResumableUploadUri());
            this.logRequestResponse(requestXml, effectiveStatus.getResumableUploadUri(), batchJobUploadResponse, exception);
            return batchJobUploadResponse2;
        }
        catch (HttpResponseException e) {
            block10: {
                try {
                    if (e.getStatusCode() != 308) break block10;
                    BatchJobUploadResponse batchJobUploadResponse3 = batchJobUploadResponse = new BatchJobUploadResponse(new ByteArrayInputStream(new byte[0]), e.getStatusCode(), e.getStatusMessage(), effectiveStatus.getTotalContentLength() + contentLength, effectiveStatus.getResumableUploadUri());
                    this.logRequestResponse(requestXml, effectiveStatus.getResumableUploadUri(), batchJobUploadResponse, exception);
                    return batchJobUploadResponse3;
                }
                catch (Throwable throwable) {
                    this.logRequestResponse(requestXml, effectiveStatus.getResumableUploadUri(), batchJobUploadResponse, exception);
                    throw throwable;
                }
            }
            exception = e;
            throw new BatchJobException("Failed response status from batch upload URL.", e);
            catch (IOException e2) {
                exception = e2;
                throw new BatchJobException("Problem sending data to batch upload URL.", e2);
            }
        }
    }

    private URI initiateResumableUpload(URI batchJobUploadUrl) throws BatchJobException {
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                HttpHeaders headers = BatchJobUploader.this.createHttpHeaders();
                headers.setContentLength(Long.valueOf(0L));
                headers.set("x-goog-resumable", (Object)"start");
                request.setHeaders(headers);
                request.setLoggingEnabled(true);
            }
        });
        try {
            HttpRequest httpRequest = requestFactory.buildPostRequest(new GenericUrl(batchJobUploadUrl), (HttpContent)new EmptyContent());
            HttpResponse response = httpRequest.execute();
            if (response.getHeaders() == null || response.getHeaders().getLocation() == null) {
                throw new BatchJobException("Initiate upload failed. Resumable upload URI was not in the response.");
            }
            return URI.create(response.getHeaders().getLocation());
        }
        catch (IOException e) {
            throw new BatchJobException("Failed to initiate upload", e);
        }
    }

    private ByteArrayContent postProcessContent(ByteArrayContent content, boolean isFirstRequest, boolean isLastRequest) throws IOException {
        if (isFirstRequest && isLastRequest) {
            return content;
        }
        String serializedRequest = Streams.readAll(content.getInputStream(), REQUEST_CHARSET);
        int numBytes = (serializedRequest = this.trimStartEndElements(serializedRequest, isFirstRequest, isLastRequest)).getBytes(REQUEST_CHARSET).length;
        int remainder = numBytes % 262144;
        if (remainder > 0) {
            int pad = 262144 - remainder;
            serializedRequest = Strings.padEnd((String)serializedRequest, (int)(numBytes + pad), (char)' ');
        }
        return new ByteArrayContent(content.getType(), serializedRequest.getBytes(REQUEST_CHARSET));
    }

    @VisibleForTesting
    String trimStartEndElements(String serializedRequest, boolean isFirstRequest, boolean isLastRequest) {
        int beginIndex = 0;
        int endIndex = serializedRequest.length();
        if (!isFirstRequest) {
            beginIndex = serializedRequest.indexOf(62) + 1;
            Preconditions.checkArgument((boolean)serializedRequest.substring(0, beginIndex - 1).contains("mutate"), (String)"Did not find an opening <mutate> element at the beginning of serialized request: %s", (Object)serializedRequest);
        }
        if (!isLastRequest) {
            endIndex = serializedRequest.lastIndexOf(60);
            Preconditions.checkArgument((boolean)serializedRequest.substring(endIndex).contains("mutate"), (String)"Did not find a closing </mutate> element at the end of serialized request: %s", (Object)serializedRequest);
        }
        return serializedRequest.substring(beginIndex, endIndex);
    }

    private void logRequestResponse(String requestXml, Object uploadUri, BatchJobUploadResponse batchJobUploadResponse, Throwable exception) {
        this.batchJobLogger.logUpload(requestXml, uploadUri, batchJobUploadResponse, exception);
    }

    @VisibleForTesting
    String constructContentRangeHeaderValue(long requestLength, boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) {
        long previousTotalLength;
        Preconditions.checkArgument((requestLength > 0L ? 1 : 0) != 0, (String)"Request length %s is <= 0", (long)requestLength);
        long contentLowerBound = previousTotalLength = batchJobUploadStatus.getTotalContentLength();
        long contentUpperBound = previousTotalLength + requestLength - 1L;
        String totalBytesString = isLastRequest ? String.valueOf(contentUpperBound + 1L) : "*";
        return String.format("bytes %d-%d/%s", contentLowerBound, contentUpperBound, totalBytesString);
    }
}

