/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.soap.RequestInfo;
import com.google.api.ads.common.lib.soap.ResponseInfo;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsServiceLoggers {
    public static final Logger ADS_API_LIB_LOG = LoggerFactory.getLogger((String)String.valueOf(AdsServiceLoggers.class.getName()).concat(".ads_api_lib"));
    private final PrettyPrinterInterface prettyPrinter;
    private final Logger soapXmlLogger;
    private final Logger requestInfoLogger;

    @Inject
    protected AdsServiceLoggers(PrettyPrinterInterface prettyPrinter, @Named(value="soapXmlLogger") Logger soapXmlLogger, @Named(value="requestInfoLogger") Logger requestInfoLogger) {
        this.prettyPrinter = prettyPrinter;
        this.soapXmlLogger = soapXmlLogger;
        this.requestInfoLogger = requestInfoLogger;
    }

    public Logger getLibLogger() {
        return ADS_API_LIB_LOG;
    }

    public void logSoapXml(SoapCallReturn soapCallReturn) {
        RequestInfo request = soapCallReturn.getRequestInfo();
        ResponseInfo response = soapCallReturn.getResponseInfo();
        if (this.soapXmlLogger.isInfoEnabled() || this.soapXmlLogger.isWarnEnabled() && soapCallReturn.getException() != null) {
            String prettyResponse;
            String string = String.valueOf(this.prettyPrinter.prettyPrint(request.getSoapRequestXml()));
            String prettyRequest = string.length() != 0 ? "SOAP Request:\n".concat(string) : new String("SOAP Request:\n");
            String string2 = String.valueOf(this.prettyPrinter.prettyPrint(response.getSoapResponseXml()));
            String string3 = prettyResponse = string2.length() != 0 ? "SOAP Response:\n".concat(string2) : new String("SOAP Response:\n");
            if (soapCallReturn.getException() == null) {
                this.soapXmlLogger.info(prettyRequest);
                this.soapXmlLogger.info(prettyResponse);
            } else {
                this.soapXmlLogger.warn(prettyRequest);
                this.soapXmlLogger.warn(prettyResponse);
            }
        }
    }

    public void logRequest(SoapCallReturn soapCallReturn) {
        RequestInfo request = soapCallReturn.getRequestInfo();
        this.requestInfoLogger.info("Request made: Service: \"{}\" Method: \"{}\" URL: \"{}\"", new Object[]{request.getServiceName(), request.getMethodName(), request.getUrl()});
    }
}

