/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.utils.Builder;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class GoogleClientSecretsBuilder {
    public GoogleClientSecretsForApiBuilder forApi(Api api) {
        return new GoogleClientSecretsForApiBuilder(api);
    }

    public static enum Api {
        ADWORDS("api.adwords."),
        DFA("api.dfa."),
        DFP("api.dfp.");

        private final String propKeyPrefix;

        private Api(String propKeyPrefix) {
            this.propKeyPrefix = propKeyPrefix;
        }

        public String getPropKeyPrefix() {
            return this.propKeyPrefix;
        }
    }

    public static class GoogleClientSecretsForApiBuilder
    implements Builder<GoogleClientSecrets> {
        private final ConfigurationHelper configHelper;
        private final Api api;
        private String clientId;
        private String clientSecret;
        private String filePath;

        private GoogleClientSecretsForApiBuilder(Api api) {
            this(new ConfigurationHelper(), api);
        }

        @VisibleForTesting
        GoogleClientSecretsForApiBuilder(ConfigurationHelper configHelper, Api api) {
            this.configHelper = configHelper;
            this.api = api;
        }

        public GoogleClientSecretsForApiBuilder withClientSecrets(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public GoogleClientSecrets build() throws ValidationException {
            this.validate();
            GoogleClientSecrets.Details details = new GoogleClientSecrets.Details();
            details.setClientId(this.clientId);
            details.setClientSecret(this.clientSecret);
            GoogleClientSecrets googleClientSecrets = new GoogleClientSecrets();
            googleClientSecrets.setInstalled(details);
            return googleClientSecrets;
        }

        private void validate() throws ValidationException {
            if (Strings.isNullOrEmpty((String)this.clientId) || this.clientId.startsWith("INSERT_CLIENT_ID_HERE")) {
                throw new ValidationException(String.format("Client ID must be set%s\nIf you do not have a client ID or secret, please create one in the API console: https://console.developers.google.com", this.filePath != null ? this.generateFilePathWarning("clientId") : "."), "clientId");
            }
            if (Strings.isNullOrEmpty((String)this.clientSecret) || this.clientId.startsWith("INSERT_CLIENT_SECRET_HERE")) {
                throw new ValidationException(String.format("Client secret must be set%s\nIf you do not have a client ID or secret, please create one in the API console: https://console.developers.google.com", this.filePath != null ? this.generateFilePathWarning("clientSecret") : "."), "clientSecret");
            }
        }

        public GoogleClientSecretsForApiBuilder from(Configuration config) {
            this.clientId = config.getString(this.getPropertyKey("clientId"), null);
            this.clientSecret = config.getString(this.getPropertyKey("clientSecret"), null);
            return this;
        }

        private GoogleClientSecretsForApiBuilder from(Configuration config, String filePath) {
            this.from(config);
            this.filePath = filePath;
            return this;
        }

        public GoogleClientSecretsForApiBuilder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path);
        }

        public GoogleClientSecretsForApiBuilder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.getAbsolutePath());
        }

        public GoogleClientSecretsForApiBuilder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.toString());
        }

        public GoogleClientSecretsForApiBuilder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        private String getPropertyKey(String suffix) {
            return String.valueOf(this.api.getPropKeyPrefix()) + suffix;
        }

        private String generateFilePathWarning(String key) {
            return String.format(" as %s in %s.", this.getPropertyKey(key), this.filePath);
        }
    }
}

