/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.logging.ReportServiceLogger;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.util.GenericData;
import java.io.IOException;

class ReportResponseInterceptor
implements HttpResponseInterceptor {
    private final ReportServiceLogger reportServiceLogger;

    public ReportResponseInterceptor(ReportServiceLogger reportServiceLogger) {
        this.reportServiceLogger = reportServiceLogger;
    }

    public void interceptResponse(HttpResponse response) throws IOException {
        if (response == null) {
            return;
        }
        HttpRequest request = response.getRequest();
        if (request != null) {
            this.reportServiceLogger.logRequest(request.getRequestMethod(), request.getUrl(), request.getContent(), (GenericData)request.getHeaders(), response.isSuccessStatusCode());
        }
        this.reportServiceLogger.logResponse(response.getStatusCode(), response.getStatusMessage(), response.isSuccessStatusCode());
    }
}

