/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.useragent;

import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.useragent.UserAgentProvider;
import com.google.api.ads.common.lib.utils.AdsUtility;
import com.google.api.ads.common.lib.utils.AdsUtilityRegistry;
import com.google.api.ads.common.lib.utils.Internals;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import javax.annotation.Nullable;

public class AdsUtilitiesUserAgentProvider
implements UserAgentProvider {
    private final Provider<Internals> internalsProvider;
    private final AdsLibConfiguration adsLibConfiguration;
    private static final Function<AdsUtility, String> ADS_UTILITY_FUNCTION = new Function<AdsUtility, String>(){

        @Nullable
        public String apply(@Nullable AdsUtility input) {
            return input == null ? null : input.getUserAgentIdentifier();
        }
    };

    @Inject
    public AdsUtilitiesUserAgentProvider(Provider<Internals> internals, AdsLibConfiguration adsLibConfiguration) {
        this.internalsProvider = internals;
        this.adsLibConfiguration = adsLibConfiguration;
    }

    @Override
    public String getUserAgent() {
        AdsUtilityRegistry adsUtilityRegistry = ((Internals)this.internalsProvider.get()).getAdsUtilityRegistry();
        Set<AdsUtility> adsUtilities = adsUtilityRegistry.getRegisteredUtilities();
        adsUtilityRegistry.removeUtilities(adsUtilities);
        if (!this.adsLibConfiguration.isIncludeAdsUtilitiesInUserAgent() || adsUtilities.isEmpty()) {
            return null;
        }
        return Joiner.on((String)", ").skipNulls().join((Iterable)Sets.newTreeSet((Iterable)Collections2.transform(adsUtilities, ADS_UTILITY_FUNCTION)));
    }
}

