/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportBodyProviderFactory;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.ReportRequest;
import com.google.api.ads.adwords.lib.utils.ReportRequestFactoryHelper;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Charsets;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;

public class AdHocReportDownloadHelper {
    private final AdWordsSession session;
    private final ReportRequestFactoryHelper reportRequestFactoryHelper;
    private final ReportBodyProviderFactory reportBodyProviderFactory;
    private final String version;
    @VisibleForTesting
    public static final Charset REPORT_CHARSET = Charsets.UTF_8;

    public AdHocReportDownloadHelper(AdWordsSession session, String version) {
        this.session = session;
        this.version = version;
        this.reportRequestFactoryHelper = new ReportRequestFactoryHelper(session);
        this.reportBodyProviderFactory = new ReportBodyProviderFactory();
    }

    public RawReportDownloadResponse downloadReport(ReportRequest reportRequest) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(this.version);
            HttpRequestFactory requestFactory = this.reportRequestFactoryHelper.getHttpRequestFactory(downloadUrl, this.version);
            ReportBodyProvider reportBodyProvider = this.reportBodyProviderFactory.getReportBodyProvider(reportRequest);
            HttpRequest httpRequest = requestFactory.buildPostRequest(new GenericUrl(downloadUrl), reportBodyProvider.getHttpContent());
            HttpResponse response = httpRequest.execute();
            Charset charSet = REPORT_CHARSET;
            if (response.getMediaType() != null && response.getMediaType().getCharsetParameter() != null) {
                charSet = response.getMediaType().getCharsetParameter();
            }
            return new RawReportDownloadResponse(response.getStatusCode(), response.getContent(), charSet, reportRequest.getDownloadFormat().name());
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
        catch (AuthenticationException e) {
            throw new ReportException("Problem with OAuth authorization.", e);
        }
    }

    private String generateReportUrl(String version) {
        String string = this.session.getEndpoint();
        String string2 = String.valueOf("/api/adwords/reportdownload");
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(version).length()).append(string).append(string2).append("/").append(version).toString();
    }

    public int getReportDownloadTimeout() {
        return this.reportRequestFactoryHelper.getReportDownloadTimeout();
    }

    public void setReportDownloadTimeout(int reportDownloadTimeout) {
        this.reportRequestFactoryHelper.setReportDownloadTimeout(reportDownloadTimeout);
    }
}

