/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinter;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingModule
extends AbstractModule {
    private final String loggerPrefix;

    public LoggingModule(String loggerPrefix) {
        this.loggerPrefix = loggerPrefix;
    }

    protected void configure() {
        this.bind(AdsServiceLoggers.class);
        this.bind(PrettyPrinterInterface.class).to(PrettyPrinter.class).in(Singleton.class);
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)"libLogger")).toInstance((Object)AdsServiceLoggers.ADS_API_LIB_LOG);
        this.configureLogger(this.loggerPrefix, "soapXmlLogger");
        this.configureLogger(this.loggerPrefix, "requestInfoLogger");
    }

    protected void configureLogger(String prefix, String name) {
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new LoggerProvider(prefix, name)).asEagerSingleton();
    }

    protected static class LoggerProvider
    implements Provider<Logger> {
        private final String loggerPrefix;
        private final String logType;

        public LoggerProvider(String loggerPrefix, String logType) {
            this.loggerPrefix = loggerPrefix;
            this.logType = logType;
        }

        public Logger get() {
            return LoggerFactory.getLogger((String)(String.valueOf(this.loggerPrefix) + "." + this.logType));
        }
    }
}

