/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.logging;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Data;
import com.google.api.client.util.GenericData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ReportServiceLogger {
    private final Logger reportLogger;
    @VisibleForTesting
    static final Set<String> SCRUBBED_HEADERS = Sets.newHashSet((Object[])new String[]{"authorization", "authtoken", "password", "developertoken"});
    @VisibleForTesting
    static final String SCRUBBED_HEADERS_VALUE = "REDACTED";

    @Inject
    ReportServiceLogger(@Named(value="report_download") Logger reportLogger) {
        this.reportLogger = reportLogger;
    }

    public void logRequest(String requestMethod, GenericUrl url, HttpContent requestContent, GenericData requestHeaders, boolean isSuccessful) {
        if (!this.isLoggable(isSuccessful)) {
            return;
        }
        this.log(String.format("Request made: %s %s%n", requestMethod, url), isSuccessful);
        StringBuilder messageBuilder = new StringBuilder();
        if (requestHeaders != null) {
            messageBuilder.append(this.getMapAsString((Map<String, Object>)requestHeaders));
        }
        messageBuilder.append(String.format("%nParameters:%n", new Object[0]));
        if (requestContent instanceof UrlEncodedContent) {
            UrlEncodedContent encodedContent = (UrlEncodedContent)requestContent;
            messageBuilder.append(this.getMapAsString(Data.mapOf((Object)encodedContent.getData())));
        } else if (requestContent != null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                requestContent.writeTo((OutputStream)byteStream);
                messageBuilder.append(byteStream.toString());
            }
            catch (IOException e) {
                messageBuilder.append("Unable to read request content due to exception: " + e);
            }
        }
        this.log(messageBuilder.toString(), isSuccessful);
    }

    public void logResponse(int statusCode, String statusMessage, boolean isSuccessful) {
        if (!this.isLoggable(isSuccessful)) {
            return;
        }
        String responseInfo = String.format("Response received with status code %d and message: %s%n", statusCode, statusMessage);
        this.log(responseInfo, isSuccessful);
    }

    public Logger getLogger() {
        return this.reportLogger;
    }

    private String getMapAsString(Map<String, Object> map) {
        StringBuilder messageBuilder = new StringBuilder();
        for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
            Object headerValue = mapEntry.getValue();
            if (SCRUBBED_HEADERS.contains(mapEntry.getKey().toLowerCase())) {
                headerValue = SCRUBBED_HEADERS_VALUE;
            }
            messageBuilder.append(String.format("%s: %s%n", mapEntry.getKey(), headerValue));
        }
        return messageBuilder.toString();
    }

    private boolean isLoggable(boolean isSuccessful) {
        return isSuccessful ? this.reportLogger.isInfoEnabled() : this.reportLogger.isWarnEnabled();
    }

    private void log(String message, boolean isSuccessful) {
        if (isSuccessful) {
            this.reportLogger.info(message);
        } else {
            this.reportLogger.warn(message);
        }
    }
}

