/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;

public class OAuth2Helper {
    private final Long refreshWindowSeconds;
    private final AdsServiceLoggers adsServiceLoggers;

    @Inject
    public OAuth2Helper(AdsServiceLoggers adsServiceLoggers, @Named(value="oAuth2RefreshWindow") Long refreshWindowSeconds) {
        this.adsServiceLoggers = adsServiceLoggers;
        this.refreshWindowSeconds = refreshWindowSeconds;
    }

    public Credential refreshCredential(Credential credential) throws IOException {
        if (this.isCredentialRefreshable(credential) && !this.callRefreshToken(credential)) {
            this.adsServiceLoggers.getLibLogger().warn("OAuth2 token could not be refreshed. Add a refreshListener to the Credential to capture this failure.");
        }
        return credential;
    }

    @VisibleForTesting
    boolean callRefreshToken(Credential credential) throws IOException {
        return credential.refreshToken();
    }

    @VisibleForTesting
    boolean isCredentialRefreshable(Credential credential) {
        return credential.getAccessToken() == null || credential.getExpiresInSeconds() != null && credential.getExpiresInSeconds() <= this.refreshWindowSeconds;
    }
}

