/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory;

import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryConfiguration {
    private Class<?> adWordsSoapModuleClass;
    private Class<?> dfaSoapModuleClass;
    private Class<?> dfpSoapModuleClass;

    private FactoryConfiguration() {
    }

    public Class<?> getAdWordsSoapModule() {
        return this.adWordsSoapModuleClass;
    }

    public Class<?> getDfaSoapModule() {
        return this.dfaSoapModuleClass;
    }

    public Class<?> getDfpSoapModule() {
        return this.dfpSoapModuleClass;
    }

    /* synthetic */ FactoryConfiguration(FactoryConfiguration factoryConfiguration) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<FactoryConfiguration> {
        private FactoryConfiguration factoryConfiguration = new FactoryConfiguration(null);
        private String adWordsSoapModuleClassString;
        private String dfaSoapModuleClassString;
        private String dfpSoapModuleClassString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        @VisibleForTesting
        Builder(ConfigurationHelper configHelper) {
            this.configHelper = configHelper;
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            String dfpSoapModuleClassString;
            String dfaSoapModuleClassString;
            String adWordsSoapModuleClassString = config.getString("api.adwords.soapModule", null);
            if (adWordsSoapModuleClassString != null) {
                this.adWordsSoapModuleClassString = adWordsSoapModuleClassString;
            }
            if ((dfaSoapModuleClassString = config.getString("api.dfa.soapModule", null)) != null) {
                this.dfaSoapModuleClassString = dfaSoapModuleClassString;
            }
            if ((dfpSoapModuleClassString = config.getString("api.dfp.soapModule", null)) != null) {
                this.dfpSoapModuleClassString = dfpSoapModuleClassString;
            }
            return this;
        }

        public Builder withAdWordsSoapModuleClass(Class<?> soapModuleClass) {
            this.factoryConfiguration.adWordsSoapModuleClass = soapModuleClass;
            return this;
        }

        public Builder withDfaSoapModuleClass(Class<?> soapModuleClass) {
            this.factoryConfiguration.dfaSoapModuleClass = soapModuleClass;
            return this;
        }

        public Builder withDfpSoapModuleClass(Class<?> soapModuleClass) {
            this.factoryConfiguration.dfpSoapModuleClass = soapModuleClass;
            return this;
        }

        @Nullable
        public FactoryConfiguration buildDefault() {
            FactoryConfiguration factoryConfiguration = null;
            try {
                factoryConfiguration = new Builder().fromFile().build();
            }
            catch (ConfigurationLoadException e) {
                if (!(Throwables.getRootCause((Throwable)e) instanceof ConfigurationException)) {
                    throw new IllegalStateException(e);
                }
            }
            catch (ValidationException e) {
                throw new IllegalStateException("A SOAP module specified in your properties file is invalid.", e);
            }
            return factoryConfiguration;
        }

        @Override
        public FactoryConfiguration build() throws ValidationException {
            try {
                this.from((Configuration)this.configHelper.createCombinedConfiguration(ConfigurationHelper.newList(Lists.newArrayList((Object[])new String[]{"ads.properties"}), true), null));
            }
            catch (ConfigurationLoadException configurationLoadException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.debug("Factory configuration could not be loaded.");
            }
            this.validate(this.factoryConfiguration);
            return this.factoryConfiguration;
        }

        private void validate(FactoryConfiguration factoryConfiguration) throws ValidationException {
            if (this.adWordsSoapModuleClassString != null) {
                try {
                    factoryConfiguration.adWordsSoapModuleClass = Class.forName(this.adWordsSoapModuleClassString);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Cannot find SOAP module class: " + this.adWordsSoapModuleClassString, "api.adwords.soapModule", e);
                }
            }
            if (this.dfaSoapModuleClassString != null) {
                try {
                    factoryConfiguration.dfaSoapModuleClass = Class.forName(this.dfaSoapModuleClassString);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Cannot find SOAP module class: " + this.dfaSoapModuleClassString, "api.dfa.soapModule", e);
                }
            }
            if (this.dfpSoapModuleClassString != null) {
                try {
                    factoryConfiguration.dfpSoapModuleClass = Class.forName(this.dfpSoapModuleClassString);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Cannot find SOAP module class: " + this.dfpSoapModuleClassString, "api.dfp.soapModule", e);
                }
            }
        }
    }
}

