/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.auth.ClientLogin;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.googleapis.auth.clientlogin.ClientLoginResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

@Deprecated
public class ClientLoginTokens {
    @VisibleForTesting
    ClientLogin clientLogin;
    private String clientLoginTokenOverride;

    @VisibleForTesting
    ClientLoginTokens(ClientLogin clientLogin) {
        this.clientLogin = clientLogin;
    }

    public String requestToken(String captchaToken, String captchaAnswer) throws ClientLoginResponseException, IOException {
        if (this.clientLogin == null) {
            throw new IllegalStateException("requestToken() and requestToken(captchaToken, captchaAnswer) can only be used with ClientLoginTokens created from ClientLogin.Builder");
        }
        try {
            this.clientLogin.setCaptchaAnswer(captchaAnswer);
            this.clientLogin.setCaptchaToken(captchaToken);
            String string = this.requestToken();
            return string;
        }
        finally {
            this.clientLogin.setCaptchaAnswer(null);
            this.clientLogin.setCaptchaToken(null);
        }
    }

    public String getToken() throws ClientLoginResponseException, IOException {
        return this.clientLoginTokenOverride != null && !this.clientLoginTokenOverride.trim().isEmpty() ? this.clientLoginTokenOverride : this.requestToken();
    }

    public String requestToken() throws ClientLoginResponseException, IOException {
        if (this.clientLogin == null) {
            throw new IllegalStateException("requestToken() and requestToken(captchaToken, captchaAnswer) can only be used with ClientLoginTokens created from ClientLogin.Builder");
        }
        return this.clientLogin.requestToken();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Api {
        DFP("gam", "api.dfp.");

        private final String service;
        private final String propKeyPrefix;

        private Api(String service, String propKeyPrefix) {
            this.service = service;
            this.propKeyPrefix = propKeyPrefix;
        }

        public String getService() {
            return this.service;
        }

        public String getPropKeyPrefix() {
            return this.propKeyPrefix;
        }
    }

    public static class Builder {
        public ForApiBuilder forApi(Api api) {
            return new ForApiBuilder(api);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForApiBuilder
    implements com.google.api.ads.common.lib.utils.Builder<ClientLoginTokens> {
        private static final HttpTransport DEFAULT_HTTP_TRANSPORT = new NetHttpTransport();
        private final ConfigurationHelper configHelper;
        private final Api api;
        private final ClientLoginTokens clientLoginTokens;

        private ForApiBuilder(Api api) {
            this(new ConfigurationHelper(), new ClientLogin(), api);
        }

        @VisibleForTesting
        ForApiBuilder(ConfigurationHelper configHelper, ClientLogin clientLogin, Api api) {
            this.configHelper = configHelper;
            this.clientLoginTokens = new ClientLoginTokens(clientLogin);
            this.api = api;
        }

        public ForApiBuilder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public ForApiBuilder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public ForApiBuilder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public ForApiBuilder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public ForApiBuilder from(Configuration config) {
            this.clientLoginTokens.clientLoginTokenOverride = config.getString(this.getPropertyKey("clientLoginToken"), null);
            this.clientLoginTokens.clientLogin.setUsername(config.getString(this.getPropertyKey("email"), null));
            this.clientLoginTokens.clientLogin.setPassword(config.getString(this.getPropertyKey("password"), null));
            String clientLoginServerUrl = config.getString("clientLoginServerUrl", null);
            if (!Strings.isNullOrEmpty((String)clientLoginServerUrl)) {
                this.clientLoginTokens.clientLogin.setServerUrl(new GenericUrl(clientLoginServerUrl));
            }
            return this;
        }

        public ForApiBuilder withEmailAndPassword(String email, String password) {
            this.clientLoginTokens.clientLogin.setUsername(email);
            this.clientLoginTokens.clientLogin.setPassword(password);
            return this;
        }

        public ForApiBuilder withHttpTransport(HttpTransport httpTransport) {
            this.clientLoginTokens.clientLogin.setTransport(httpTransport);
            return this;
        }

        public ForApiBuilder withClientLoginServerUrl(String serverUrl) {
            this.clientLoginTokens.clientLogin.setServerUrl(new GenericUrl(serverUrl));
            return this;
        }

        private void validate() throws ValidationException {
            if (!(Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLoginTokenOverride) || Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getUsername()) && Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getPassword()))) {
                throw new ValidationException("Email and password or client login token should be set. Not both.", "");
            }
            if (Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLoginTokenOverride) && (Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getUsername()) || Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getPassword()))) {
                throw new ValidationException("Email and password or client login token must be set.", "");
            }
        }

        @Override
        public ClientLoginTokens build() throws ValidationException {
            this.validate();
            if (this.clientLoginTokens.clientLogin.getTransport() == null) {
                this.clientLoginTokens.clientLogin.setTransport(DEFAULT_HTTP_TRANSPORT);
            }
            this.clientLoginTokens.clientLogin.setAccountType("GOOGLE");
            this.clientLoginTokens.clientLogin.setAuthTokenType(this.api.getService());
            return this.clientLoginTokens;
        }

        @VisibleForTesting
        String getPropertyKey(String suffix) {
            return String.valueOf(this.api.getPropKeyPrefix()) + suffix;
        }
    }
}

