/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.factory.helper;

import com.google.api.ads.adwords.lib.client.AdWordsServiceClient;
import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.factory.FactoryModule;
import com.google.api.ads.common.lib.factory.helper.BaseAdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdWordsServiceClientFactoryHelper
extends BaseAdsServiceClientFactoryHelper<AdWordsServiceClient, AdWordsSession, AdWordsServiceDescriptor> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^.*(v[0-9][^\\.]*).*$");
    private static final String FINAL_CLIENT_LOGIN_VERSION = "v201309";
    private final AdsLibConfiguration adsLibConfiguration;

    @Inject
    public AdWordsServiceClientFactoryHelper(FactoryModule.AdsServiceClientFactoryInterface<AdWordsServiceClient, AdWordsSession, AdWordsServiceDescriptor> adsServiceClientFactory, FactoryModule.AdsServiceDescriptorFactoryInterface<AdWordsServiceDescriptor> adsServiceDescriptorFactory, SoapClientHandlerInterface soapClientHandler, AdsLibConfiguration adsLibConfiguration) {
        super(adsServiceClientFactory, adsServiceDescriptorFactory, soapClientHandler);
        this.adsLibConfiguration = adsLibConfiguration;
    }

    @Override
    public String determineVersion(Class<?> interfaceClass) {
        Matcher m = VERSION_PATTERN.matcher(interfaceClass.getPackage().getName());
        if (m.matches()) {
            return m.group(1);
        }
        return this.adsLibConfiguration.getDuckTypedVersion();
    }

    @Override
    public void checkServiceClientPreconditions(AdWordsSession adWordsSession, Class<?> interfaceClass) throws ServiceException {
        String version = this.determineVersion(interfaceClass);
        if (!Strings.isNullOrEmpty((String)adWordsSession.getClientLoginToken()) && version.compareTo(FINAL_CLIENT_LOGIN_VERSION) > 0) {
            throw new ServiceException(String.format("ClientLogin is not supported in version %s. Please upgrade to OAuth2.", version));
        }
    }
}

