/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.client;

import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.soap.SoapServiceClient;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdsServiceClient<S extends AdsSession, D extends AdsServiceDescriptor>
extends SoapServiceClient<Object> {
    private S adsSession;
    private final D adsServiceDescriptor;
    private final AdsServiceLoggers adsServiceLoggers;
    private final HeaderHandler<S, D> headerHandler;

    public AdsServiceClient(Object soapClient, S adsSession, D adsServiceDescriptor, SoapClientHandlerInterface<Object> soapClientHandler, HeaderHandler<S, D> headerHandler, AdsServiceLoggers adsServiceLoggers) {
        super(soapClientHandler, soapClient);
        this.adsSession = adsSession;
        this.adsServiceDescriptor = adsServiceDescriptor;
        this.adsServiceLoggers = adsServiceLoggers;
        this.headerHandler = headerHandler;
    }

    public S getAdsSession() {
        return this.adsSession;
    }

    public D getAdsServiceDescriptor() {
        return this.adsServiceDescriptor;
    }

    public void setAdsSession(S session) {
        this.adsSession = session;
    }

    @Override
    protected void logSoapCall(SoapCallReturn soapCallReturn) {
        this.adsServiceLoggers.logRequest(soapCallReturn);
        this.adsServiceLoggers.logSoapXml(soapCallReturn);
    }

    @Override
    protected void setHeaders() throws ServiceException, AuthenticationException {
        this.getSoapClientHandler().clearHeaders(this.getSoapClient());
        this.headerHandler.setHeaders(this.getSoapClient(), this.adsSession, this.adsServiceDescriptor);
    }
}

