/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.common.annotations.VisibleForTesting;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.EmptyStackException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class PrettyPrinter
implements PrettyPrinterInterface {
    private static final String INDENT_AMOUNT = "4";
    private static Transformer transformer;

    public PrettyPrinter() {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENT_AMOUNT);
        }
        catch (TransformerConfigurationException e) {
            AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to initialize XML PrettyPrinter. Error: " + e.toString());
        }
        catch (TransformerFactoryConfigurationError e) {
            AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to initialize XML PrettyPrinter. Error: " + e.toString());
        }
    }

    @VisibleForTesting
    PrettyPrinter(Transformer transformer) {
        PrettyPrinter.transformer = transformer;
    }

    public String prettyPrint(String xml) {
        if (transformer != null) {
            try {
                StreamResult result = new StreamResult(new StringWriter());
                transformer.transform(new StreamSource(new StringReader(xml)), result);
                return result.getWriter().toString();
            }
            catch (TransformerException transformerException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to pretty print XML: {}", (Object)xml);
                return xml;
            }
            catch (NullPointerException nullPointerException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to pretty print XML: {}", (Object)xml);
                return xml;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to pretty print XML: {}", (Object)xml);
                return xml;
            }
            catch (EmptyStackException emptyStackException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to pretty print XML: {}", (Object)xml);
                return xml;
            }
        }
        return xml;
    }
}

