/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.factory;

import com.google.api.ads.adwords.lib.AdWordsModule;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.factory.AdWordsServiceClientFactory;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.factory.FactoryConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdWordsServices {
    private final AdWordsServiceClientFactory factory;

    public AdWordsServices() {
        FactoryConfiguration factoryConfiguration = null;
        try {
            factoryConfiguration = new FactoryConfiguration.Builder().fromFile().build();
        }
        catch (IllegalArgumentException e) {
            if (!(Throwables.getRootCause((Throwable)e) instanceof ConfigurationException)) {
                throw new IllegalStateException(e);
            }
        }
        catch (ValidationException e) {
            throw new IllegalStateException("A SOAP module specified in your properties file is invalid.", e);
        }
        this.factory = factoryConfiguration == null ? new AdWordsServiceClientFactory() : new AdWordsServiceClientFactory(new AdWordsModule(factoryConfiguration));
    }

    @VisibleForTesting
    AdWordsServices(AdWordsServiceClientFactory factory) {
        this.factory = factory;
    }

    public AdWordsServices(FactoryConfiguration factoryConfiguration) {
        this.factory = new AdWordsServiceClientFactory(new AdWordsModule(factoryConfiguration));
    }

    public <T> T get(AdWordsSession adWordsSession, Class<T> interfaceClass) {
        return this.factory.getServiceClientAsInterface(adWordsSession, interfaceClass);
    }
}

