/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201209;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.jaxb.v201209.DownloadFormat;
import com.google.api.ads.adwords.lib.jaxb.v201209.ReportDefinition;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.XmlFieldExtractor;
import com.google.api.ads.adwords.lib.utils.v201209.DetailedReportDownloadResponseException;
import com.google.api.ads.common.lib.soap.jaxb.JaxBSerializer;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDownloader {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    private static final String VERSION = "v201209";
    private final AdHocReportDownloadHelper adHocReportDownloadHelper;
    private final JaxBSerializer<ReportDefinition> serializer;

    public ReportDownloader(AdWordsSession session) {
        this.adHocReportDownloadHelper = new AdHocReportDownloadHelper(session, VERSION);
        this.serializer = new JaxBSerializer<ReportDefinition>(ReportDefinition.class, new QName("reportDefinition"));
    }

    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException, ReportDownloadResponseException {
        return this.handleResponse(this.adHocReportDownloadHelper.downloadReport(this.toXml(reportDefinition)));
    }

    @VisibleForTesting
    ReportDownloadResponse handleResponse(RawReportDownloadResponse response) throws ReportDownloadResponseException {
        String responseText;
        if (response.getHttpStatus() == 200) {
            return new ReportDownloadResponse(response.getHttpStatus(), "SUCCESS", response.getInputStream());
        }
        try {
            responseText = Streams.readAll(response.getInputStream());
        }
        catch (IOException e1) {
            throw new ReportDownloadResponseException(response.getHttpStatus(), (Throwable)e1);
        }
        DetailedReportDownloadResponseException exception = new DetailedReportDownloadResponseException(response.getHttpStatus(), responseText);
        XmlFieldExtractor extractor = new XmlFieldExtractor();
        Map<String, String> fields = extractor.extract(new ByteArrayInputStream(responseText.getBytes()), new String[]{"fieldPath", "trigger", "type"});
        exception.setFieldPath(fields.get("fieldPath"));
        exception.setTrigger(fields.get("trigger"));
        exception.setType(fields.get("type"));
        throw exception;
    }

    public ReportDownloadResponse downloadReport(String reportQuery, DownloadFormat format) throws ReportException, ReportDownloadResponseException {
        return this.handleResponse(this.adHocReportDownloadHelper.downloadReport(reportQuery, format.value()));
    }

    @VisibleForTesting
    String toXml(ReportDefinition reportDefinition) {
        return this.serializer.serialize(reportDefinition);
    }
}

