/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.axis;

import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.RequestInfo;
import com.google.api.ads.common.lib.soap.ResponseInfo;
import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.soap.SoapClientHandler;
import com.google.api.ads.common.lib.soap.SoapServiceDescriptor;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisHandler
extends SoapClientHandler<Stub> {
    public void setEndpointAddress(Stub soapClient, String endpointAddress) {
        soapClient._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpointAddress);
    }

    public Object getHeader(Stub soapClient, String headerName) {
        SOAPHeaderElement[] soapHeaders;
        SOAPHeaderElement[] sOAPHeaderElementArray = soapHeaders = soapClient.getHeaders();
        int n = soapHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            SOAPHeaderElement soapHeader = sOAPHeaderElementArray[n2];
            if (soapHeader.getName().equals(headerName)) {
                return soapHeader;
            }
            ++n2;
        }
        return null;
    }

    public void clearHeaders(Stub soapClient) {
        soapClient._setProperty("HTTP-Request-Headers", new Hashtable());
        soapClient.clearHeaders();
    }

    public void setHeader(Stub soapClient, String namespace, String headerName, Object headerValue) {
        try {
            QName qName = new QName(namespace, headerName);
            SOAPHeaderElement soapHeaderElement = new SOAPHeaderElement(qName);
            soapHeaderElement.setObjectValue(headerValue);
            soapHeaderElement.setActor(null);
            soapClient.setHeader(soapHeaderElement);
        }
        catch (SOAPException e) {
            throw new ServiceException("Could not set header.", (Throwable)e);
        }
    }

    public void putAllHttpHeaders(Stub soapClient, Map<String, String> headersMap) {
        Hashtable<String, String> headers = (Hashtable<String, String>)soapClient._getProperty("HTTP-Request-Headers");
        if (headers == null) {
            headers = new Hashtable<String, String>();
        }
        headers.putAll(headersMap);
        soapClient._setProperty("HTTP-Request-Headers", headers);
    }

    public void setCompression(Stub soapClient, boolean compress) {
        soapClient._setProperty("transport.http.acceptGzip", (Object)compress);
        soapClient._setProperty("transport.http.gzipRequest", (Object)compress);
    }

    public Stub createSoapClient(SoapServiceDescriptor soapServiceDescriptor) throws ServiceException {
        try {
            if (soapServiceDescriptor instanceof AxisCompatible) {
                AxisCompatible axisCompatibleService = (AxisCompatible)soapServiceDescriptor;
                Service locator = (Service)axisCompatibleService.getLocatorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                return (Stub)locator.getClass().getMethod("getPort", Class.class).invoke((Object)locator, soapServiceDescriptor.getInterfaceClass());
            }
            throw new ServiceException("Service [" + soapServiceDescriptor + "] not compatible with Axis", null);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoapCallReturn invokeSoapCall(SoapCall<Stub> soapCall) {
        Stub stub = (Stub)soapCall.getSoapClient();
        SoapCallReturn.Builder builder = new SoapCallReturn.Builder();
        Stub stub2 = stub;
        synchronized (stub2) {
            Object result;
            block26: {
                result = null;
                try {
                    result = this.invoke(soapCall);
                }
                catch (InvocationTargetException e) {
                    builder.withException(e.getTargetException());
                    MessageContext messageContext = stub._getCall().getMessageContext();
                    try {
                        builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(messageContext.getRequestMessage().getSOAPPartAsString()).withMethodName(stub._getCall().getOperationName().getLocalPart()).withServiceName(stub.getPortName().getLocalPart()).withUrl(stub._getCall().getTargetEndpointAddress()).build());
                    }
                    catch (AxisFault e2) {
                        builder.withException((Throwable)e2);
                    }
                    try {
                        builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(messageContext.getResponseMessage().getSOAPPartAsString()).build());
                    }
                    catch (AxisFault e3) {
                        builder.withException((Throwable)e3);
                    }
                    break block26;
                }
                catch (Exception e) {
                    try {
                        builder.withException((Throwable)e);
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        MessageContext messageContext = stub._getCall().getMessageContext();
                        try {
                            builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(messageContext.getRequestMessage().getSOAPPartAsString()).withMethodName(stub._getCall().getOperationName().getLocalPart()).withServiceName(stub.getPortName().getLocalPart()).withUrl(stub._getCall().getTargetEndpointAddress()).build());
                        }
                        catch (AxisFault e4) {
                            builder.withException((Throwable)e4);
                        }
                        try {
                            builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(messageContext.getResponseMessage().getSOAPPartAsString()).build());
                        }
                        catch (AxisFault e5) {
                            builder.withException((Throwable)e5);
                        }
                    }
                }
                MessageContext messageContext = stub._getCall().getMessageContext();
                try {
                    builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(messageContext.getRequestMessage().getSOAPPartAsString()).withMethodName(stub._getCall().getOperationName().getLocalPart()).withServiceName(stub.getPortName().getLocalPart()).withUrl(stub._getCall().getTargetEndpointAddress()).build());
                }
                catch (AxisFault e) {
                    builder.withException((Throwable)e);
                }
                try {
                    builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(messageContext.getResponseMessage().getSOAPPartAsString()).build());
                }
                catch (AxisFault e) {
                    builder.withException((Throwable)e);
                }
            }
            return builder.withReturnValue(result).build();
        }
    }

    public String getEndpointAddress(Stub soapClient) {
        return (String)soapClient._getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public javax.xml.soap.SOAPHeaderElement createSoapHeaderElement(QName qName) {
        return new SOAPHeaderElement(qName);
    }
}

