/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Creative;
import com.google.ads.admanager.v1.CreativeServiceClient;
import com.google.ads.admanager.v1.GetCreativeRequest;
import com.google.ads.admanager.v1.ListCreativesRequest;
import com.google.ads.admanager.v1.ListCreativesResponse;
import com.google.ads.admanager.v1.stub.CreativeServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCreativeServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CreativeServiceStubSettings
extends StubSettings<CreativeServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetCreativeRequest, Creative> getCreativeSettings;
    private final PagedCallSettings<ListCreativesRequest, ListCreativesResponse, CreativeServiceClient.ListCreativesPagedResponse> listCreativesSettings;
    private static final PagedListDescriptor<ListCreativesRequest, ListCreativesResponse, Creative> LIST_CREATIVES_PAGE_STR_DESC = new PagedListDescriptor<ListCreativesRequest, ListCreativesResponse, Creative>(){

        public String emptyToken() {
            return "";
        }

        public ListCreativesRequest injectToken(ListCreativesRequest payload, String token) {
            return ListCreativesRequest.newBuilder((ListCreativesRequest)payload).setPageToken(token).build();
        }

        public ListCreativesRequest injectPageSize(ListCreativesRequest payload, int pageSize) {
            return ListCreativesRequest.newBuilder((ListCreativesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCreativesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCreativesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Creative> extractResources(ListCreativesResponse payload) {
            return payload.getCreativesList() == null ? ImmutableList.of() : payload.getCreativesList();
        }
    };
    private static final PagedListResponseFactory<ListCreativesRequest, ListCreativesResponse, CreativeServiceClient.ListCreativesPagedResponse> LIST_CREATIVES_PAGE_STR_FACT = new PagedListResponseFactory<ListCreativesRequest, ListCreativesResponse, CreativeServiceClient.ListCreativesPagedResponse>(){

        public ApiFuture<CreativeServiceClient.ListCreativesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCreativesRequest, ListCreativesResponse> callable, ListCreativesRequest request, ApiCallContext context, ApiFuture<ListCreativesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CREATIVES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CreativeServiceClient.ListCreativesPagedResponse.createAsync((PageContext<ListCreativesRequest, ListCreativesResponse, Creative>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCreativeRequest, Creative> getCreativeSettings() {
        return this.getCreativeSettings;
    }

    public PagedCallSettings<ListCreativesRequest, ListCreativesResponse, CreativeServiceClient.ListCreativesPagedResponse> listCreativesSettings() {
        return this.listCreativesSettings;
    }

    public CreativeServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCreativeServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CreativeServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CreativeServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CreativeServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCreativeSettings = settingsBuilder.getCreativeSettings().build();
        this.listCreativesSettings = settingsBuilder.listCreativesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CreativeServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCreativeRequest, Creative> getCreativeSettings;
        private final PagedCallSettings.Builder<ListCreativesRequest, ListCreativesResponse, CreativeServiceClient.ListCreativesPagedResponse> listCreativesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCreativeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCreativesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CREATIVES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCreativeSettings, this.listCreativesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CreativeServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCreativeSettings = settings.getCreativeSettings.toBuilder();
            this.listCreativesSettings = settings.listCreativesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCreativeSettings, this.listCreativesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CreativeServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CreativeServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CreativeServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CreativeServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCreativeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCreativesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCreativeRequest, Creative> getCreativeSettings() {
            return this.getCreativeSettings;
        }

        public PagedCallSettings.Builder<ListCreativesRequest, ListCreativesResponse, CreativeServiceClient.ListCreativesPagedResponse> listCreativesSettings() {
            return this.listCreativesSettings;
        }

        public CreativeServiceStubSettings build() throws IOException {
            return new CreativeServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

