/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BatchCreateSitesRequest;
import com.google.ads.admanager.v1.BatchCreateSitesResponse;
import com.google.ads.admanager.v1.BatchDeactivateSitesRequest;
import com.google.ads.admanager.v1.BatchDeactivateSitesResponse;
import com.google.ads.admanager.v1.BatchSubmitSitesForApprovalRequest;
import com.google.ads.admanager.v1.BatchSubmitSitesForApprovalResponse;
import com.google.ads.admanager.v1.BatchUpdateSitesRequest;
import com.google.ads.admanager.v1.BatchUpdateSitesResponse;
import com.google.ads.admanager.v1.CreateSiteRequest;
import com.google.ads.admanager.v1.GetSiteRequest;
import com.google.ads.admanager.v1.ListSitesRequest;
import com.google.ads.admanager.v1.ListSitesResponse;
import com.google.ads.admanager.v1.Site;
import com.google.ads.admanager.v1.SiteServiceClient;
import com.google.ads.admanager.v1.UpdateSiteRequest;
import com.google.ads.admanager.v1.stub.HttpJsonSiteServiceStub;
import com.google.ads.admanager.v1.stub.SiteServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SiteServiceStubSettings
extends StubSettings<SiteServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetSiteRequest, Site> getSiteSettings;
    private final PagedCallSettings<ListSitesRequest, ListSitesResponse, SiteServiceClient.ListSitesPagedResponse> listSitesSettings;
    private final UnaryCallSettings<CreateSiteRequest, Site> createSiteSettings;
    private final UnaryCallSettings<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesSettings;
    private final UnaryCallSettings<UpdateSiteRequest, Site> updateSiteSettings;
    private final UnaryCallSettings<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesSettings;
    private final UnaryCallSettings<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesSettings;
    private final UnaryCallSettings<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalSettings;
    private static final PagedListDescriptor<ListSitesRequest, ListSitesResponse, Site> LIST_SITES_PAGE_STR_DESC = new PagedListDescriptor<ListSitesRequest, ListSitesResponse, Site>(){

        public String emptyToken() {
            return "";
        }

        public ListSitesRequest injectToken(ListSitesRequest payload, String token) {
            return ListSitesRequest.newBuilder((ListSitesRequest)payload).setPageToken(token).build();
        }

        public ListSitesRequest injectPageSize(ListSitesRequest payload, int pageSize) {
            return ListSitesRequest.newBuilder((ListSitesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSitesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSitesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Site> extractResources(ListSitesResponse payload) {
            return payload.getSitesList();
        }
    };
    private static final PagedListResponseFactory<ListSitesRequest, ListSitesResponse, SiteServiceClient.ListSitesPagedResponse> LIST_SITES_PAGE_STR_FACT = new PagedListResponseFactory<ListSitesRequest, ListSitesResponse, SiteServiceClient.ListSitesPagedResponse>(){

        public ApiFuture<SiteServiceClient.ListSitesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSitesRequest, ListSitesResponse> callable, ListSitesRequest request, ApiCallContext context, ApiFuture<ListSitesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SITES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SiteServiceClient.ListSitesPagedResponse.createAsync((PageContext<ListSitesRequest, ListSitesResponse, Site>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetSiteRequest, Site> getSiteSettings() {
        return this.getSiteSettings;
    }

    public PagedCallSettings<ListSitesRequest, ListSitesResponse, SiteServiceClient.ListSitesPagedResponse> listSitesSettings() {
        return this.listSitesSettings;
    }

    public UnaryCallSettings<CreateSiteRequest, Site> createSiteSettings() {
        return this.createSiteSettings;
    }

    public UnaryCallSettings<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesSettings() {
        return this.batchCreateSitesSettings;
    }

    public UnaryCallSettings<UpdateSiteRequest, Site> updateSiteSettings() {
        return this.updateSiteSettings;
    }

    public UnaryCallSettings<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesSettings() {
        return this.batchUpdateSitesSettings;
    }

    public UnaryCallSettings<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesSettings() {
        return this.batchDeactivateSitesSettings;
    }

    public UnaryCallSettings<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalSettings() {
        return this.batchSubmitSitesForApprovalSettings;
    }

    public SiteServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSiteServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SiteServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SiteServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SiteServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSiteSettings = settingsBuilder.getSiteSettings().build();
        this.listSitesSettings = settingsBuilder.listSitesSettings().build();
        this.createSiteSettings = settingsBuilder.createSiteSettings().build();
        this.batchCreateSitesSettings = settingsBuilder.batchCreateSitesSettings().build();
        this.updateSiteSettings = settingsBuilder.updateSiteSettings().build();
        this.batchUpdateSitesSettings = settingsBuilder.batchUpdateSitesSettings().build();
        this.batchDeactivateSitesSettings = settingsBuilder.batchDeactivateSitesSettings().build();
        this.batchSubmitSitesForApprovalSettings = settingsBuilder.batchSubmitSitesForApprovalSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SiteServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetSiteRequest, Site> getSiteSettings;
        private final PagedCallSettings.Builder<ListSitesRequest, ListSitesResponse, SiteServiceClient.ListSitesPagedResponse> listSitesSettings;
        private final UnaryCallSettings.Builder<CreateSiteRequest, Site> createSiteSettings;
        private final UnaryCallSettings.Builder<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesSettings;
        private final UnaryCallSettings.Builder<UpdateSiteRequest, Site> updateSiteSettings;
        private final UnaryCallSettings.Builder<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesSettings;
        private final UnaryCallSettings.Builder<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesSettings;
        private final UnaryCallSettings.Builder<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSitesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SITES_PAGE_STR_FACT);
            this.createSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateSitesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSiteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateSitesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeactivateSitesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchSubmitSitesForApprovalSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSiteSettings, this.listSitesSettings, this.createSiteSettings, this.batchCreateSitesSettings, this.updateSiteSettings, this.batchUpdateSitesSettings, this.batchDeactivateSitesSettings, this.batchSubmitSitesForApprovalSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SiteServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getSiteSettings = settings.getSiteSettings.toBuilder();
            this.listSitesSettings = settings.listSitesSettings.toBuilder();
            this.createSiteSettings = settings.createSiteSettings.toBuilder();
            this.batchCreateSitesSettings = settings.batchCreateSitesSettings.toBuilder();
            this.updateSiteSettings = settings.updateSiteSettings.toBuilder();
            this.batchUpdateSitesSettings = settings.batchUpdateSitesSettings.toBuilder();
            this.batchDeactivateSitesSettings = settings.batchDeactivateSitesSettings.toBuilder();
            this.batchSubmitSitesForApprovalSettings = settings.batchSubmitSitesForApprovalSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSiteSettings, this.listSitesSettings, this.createSiteSettings, this.batchCreateSitesSettings, this.updateSiteSettings, this.batchUpdateSitesSettings, this.batchDeactivateSitesSettings, this.batchSubmitSitesForApprovalSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SiteServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SiteServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SiteServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SiteServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateSiteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchDeactivateSitesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchSubmitSitesForApprovalSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetSiteRequest, Site> getSiteSettings() {
            return this.getSiteSettings;
        }

        public PagedCallSettings.Builder<ListSitesRequest, ListSitesResponse, SiteServiceClient.ListSitesPagedResponse> listSitesSettings() {
            return this.listSitesSettings;
        }

        public UnaryCallSettings.Builder<CreateSiteRequest, Site> createSiteSettings() {
            return this.createSiteSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesSettings() {
            return this.batchCreateSitesSettings;
        }

        public UnaryCallSettings.Builder<UpdateSiteRequest, Site> updateSiteSettings() {
            return this.updateSiteSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesSettings() {
            return this.batchUpdateSitesSettings;
        }

        public UnaryCallSettings.Builder<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesSettings() {
            return this.batchDeactivateSitesSettings;
        }

        public UnaryCallSettings.Builder<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalSettings() {
            return this.batchSubmitSitesForApprovalSettings;
        }

        public SiteServiceStubSettings build() throws IOException {
            return new SiteServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

