/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.ContentLabel;
import com.google.ads.admanager.v1.ContentLabelServiceClient;
import com.google.ads.admanager.v1.GetContentLabelRequest;
import com.google.ads.admanager.v1.ListContentLabelsRequest;
import com.google.ads.admanager.v1.ListContentLabelsResponse;
import com.google.ads.admanager.v1.stub.ContentLabelServiceStub;
import com.google.ads.admanager.v1.stub.ContentLabelServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonContentLabelServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonContentLabelServiceStub
extends ContentLabelServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetContentLabelRequest, ContentLabel> getContentLabelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContentLabelService/GetContentLabel").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/contentLabels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ContentLabel.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListContentLabelsRequest, ListContentLabelsResponse> listContentLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContentLabelService/ListContentLabels").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/contentLabels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListContentLabelsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetContentLabelRequest, ContentLabel> getContentLabelCallable;
    private final UnaryCallable<ListContentLabelsRequest, ListContentLabelsResponse> listContentLabelsCallable;
    private final UnaryCallable<ListContentLabelsRequest, ContentLabelServiceClient.ListContentLabelsPagedResponse> listContentLabelsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonContentLabelServiceStub create(ContentLabelServiceStubSettings settings) throws IOException {
        return new HttpJsonContentLabelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonContentLabelServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonContentLabelServiceStub(ContentLabelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonContentLabelServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonContentLabelServiceStub(ContentLabelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonContentLabelServiceStub(ContentLabelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonContentLabelServiceCallableFactory());
    }

    protected HttpJsonContentLabelServiceStub(ContentLabelServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getContentLabelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getContentLabelMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listContentLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listContentLabelsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getContentLabelCallable = callableFactory.createUnaryCallable(getContentLabelTransportSettings, settings.getContentLabelSettings(), clientContext);
        this.listContentLabelsCallable = callableFactory.createUnaryCallable(listContentLabelsTransportSettings, settings.listContentLabelsSettings(), clientContext);
        this.listContentLabelsPagedCallable = callableFactory.createPagedCallable(listContentLabelsTransportSettings, settings.listContentLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getContentLabelMethodDescriptor);
        methodDescriptors.add(listContentLabelsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetContentLabelRequest, ContentLabel> getContentLabelCallable() {
        return this.getContentLabelCallable;
    }

    @Override
    public UnaryCallable<ListContentLabelsRequest, ListContentLabelsResponse> listContentLabelsCallable() {
        return this.listContentLabelsCallable;
    }

    @Override
    public UnaryCallable<ListContentLabelsRequest, ContentLabelServiceClient.ListContentLabelsPagedResponse> listContentLabelsPagedCallable() {
        return this.listContentLabelsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

