/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.ContentBundle;
import com.google.ads.admanager.v1.ContentBundleServiceClient;
import com.google.ads.admanager.v1.GetContentBundleRequest;
import com.google.ads.admanager.v1.ListContentBundlesRequest;
import com.google.ads.admanager.v1.ListContentBundlesResponse;
import com.google.ads.admanager.v1.stub.ContentBundleServiceStub;
import com.google.ads.admanager.v1.stub.ContentBundleServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonContentBundleServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonContentBundleServiceStub
extends ContentBundleServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetContentBundleRequest, ContentBundle> getContentBundleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContentBundleService/GetContentBundle").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/contentBundles/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ContentBundle.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListContentBundlesRequest, ListContentBundlesResponse> listContentBundlesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContentBundleService/ListContentBundles").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/contentBundles", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListContentBundlesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetContentBundleRequest, ContentBundle> getContentBundleCallable;
    private final UnaryCallable<ListContentBundlesRequest, ListContentBundlesResponse> listContentBundlesCallable;
    private final UnaryCallable<ListContentBundlesRequest, ContentBundleServiceClient.ListContentBundlesPagedResponse> listContentBundlesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonContentBundleServiceStub create(ContentBundleServiceStubSettings settings) throws IOException {
        return new HttpJsonContentBundleServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonContentBundleServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonContentBundleServiceStub(ContentBundleServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonContentBundleServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonContentBundleServiceStub(ContentBundleServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonContentBundleServiceStub(ContentBundleServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonContentBundleServiceCallableFactory());
    }

    protected HttpJsonContentBundleServiceStub(ContentBundleServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getContentBundleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getContentBundleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listContentBundlesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listContentBundlesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getContentBundleCallable = callableFactory.createUnaryCallable(getContentBundleTransportSettings, settings.getContentBundleSettings(), clientContext);
        this.listContentBundlesCallable = callableFactory.createUnaryCallable(listContentBundlesTransportSettings, settings.listContentBundlesSettings(), clientContext);
        this.listContentBundlesPagedCallable = callableFactory.createPagedCallable(listContentBundlesTransportSettings, settings.listContentBundlesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getContentBundleMethodDescriptor);
        methodDescriptors.add(listContentBundlesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetContentBundleRequest, ContentBundle> getContentBundleCallable() {
        return this.getContentBundleCallable;
    }

    @Override
    public UnaryCallable<ListContentBundlesRequest, ListContentBundlesResponse> listContentBundlesCallable() {
        return this.listContentBundlesCallable;
    }

    @Override
    public UnaryCallable<ListContentBundlesRequest, ContentBundleServiceClient.ListContentBundlesPagedResponse> listContentBundlesPagedCallable() {
        return this.listContentBundlesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

