/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Application;
import com.google.ads.admanager.v1.ApplicationServiceClient;
import com.google.ads.admanager.v1.GetApplicationRequest;
import com.google.ads.admanager.v1.ListApplicationsRequest;
import com.google.ads.admanager.v1.ListApplicationsResponse;
import com.google.ads.admanager.v1.stub.ApplicationServiceStub;
import com.google.ads.admanager.v1.stub.ApplicationServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonApplicationServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonApplicationServiceStub
extends ApplicationServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetApplicationRequest, Application> getApplicationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ApplicationService/GetApplication").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/applications/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Application.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListApplicationsRequest, ListApplicationsResponse> listApplicationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ApplicationService/ListApplications").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/applications", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListApplicationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable;
    private final UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable;
    private final UnaryCallable<ListApplicationsRequest, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonApplicationServiceStub create(ApplicationServiceStubSettings settings) throws IOException {
        return new HttpJsonApplicationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonApplicationServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonApplicationServiceStub(ApplicationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonApplicationServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonApplicationServiceStub(ApplicationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonApplicationServiceStub(ApplicationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonApplicationServiceCallableFactory());
    }

    protected HttpJsonApplicationServiceStub(ApplicationServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getApplicationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getApplicationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listApplicationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listApplicationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getApplicationCallable = callableFactory.createUnaryCallable(getApplicationTransportSettings, settings.getApplicationSettings(), clientContext);
        this.listApplicationsCallable = callableFactory.createUnaryCallable(listApplicationsTransportSettings, settings.listApplicationsSettings(), clientContext);
        this.listApplicationsPagedCallable = callableFactory.createPagedCallable(listApplicationsTransportSettings, settings.listApplicationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getApplicationMethodDescriptor);
        methodDescriptors.add(listApplicationsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.getApplicationCallable;
    }

    @Override
    public UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable() {
        return this.listApplicationsCallable;
    }

    @Override
    public UnaryCallable<ListApplicationsRequest, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsPagedCallable() {
        return this.listApplicationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

